package fr.onema.sispea.struts;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.util.message.Messages;
import org.springframework.beans.factory.InitializingBean;

/**
 * Cette classe permet d'acceder aux messages predefinis
 * du paquetage. Tous les sous-paquetages
 * doivent utiliser cette classe pour envoyer des messages.
 * La classe implemente le modele de conception singleton
 * pour ne charger le fichier de messages qu'une fois.
 *
 * @author CS
 * @version $Revision: 1.2 $
 * @since 1.0
 */
public class StrutsMessages extends Messages implements InitializingBean {

    /**
     * Nom du paquetage.
     *
     * @since 1.0
     */
    static final private String PACKAGE_NAME = "fr/onema/sispea/struts";

    public StrutsMessages() {
        super();
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        load(PACKAGE_NAME, messages);
    }
}
