package fr.onema.sispea.struts;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.service.data.ExerciseDto;
import fr.onema.sispea.service.exchange.ExchangeMessageDto;
import fr.onema.sispea.service.referential.TerritoryDto;
import fr.onema.sispea.service.search.SearchTerritoryDto;
import fr.onema.sispea.service.search.SearchTerritoryResultDto;
import fr.onema.sispea.service.search.UsersFilterDto;
import fr.onema.sispea.service.user.UserDto;
import fr.onema.sispea.service.user.UsersFormDto;
import fr.onema.sispea.struts.common.bean.MenuBean;
import fr.onema.sispea.struts.referential.bean.XmlGroupTab;
import fr.onema.sispea.struts.referential.bean.XmlGroupTableDetail;
import fr.onema.sispea.struts.referential.bean.XmlGroupTableDetailValue;
import org.apache.log4j.Logger;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * This class contains all SISPEA information of the session. This should be the
 * only object put in session by the SISPEA web app.
 *
 * The class contains an init method. This method should be called to reinitialize
 * all sequence / context specific attributes of the SISPEA session.
 *
 * All context specific attributes should be reinitialized (set to null) by the
 * init method.
 *
 * @author CS
 */
public class SispeaSession implements Serializable {

    /**
     * The session object used by the SISPEA web app. This object should be the
     * only SISPEA object in the session scope.
     */
    public static final String SISPEA_SESSION = "fr.onema.sispea.struts.session";

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(SispeaSession.class);

    /**
     * The current user. This attribute may be null if there is not any
     * authenticated user yet.
     */
    protected UserDto user = null;

    /**
     * The current menu. This attribute should not be null.
     */
    protected MenuBean menu = null;

    /**
     * The full screen mode
     */
    protected Boolean fullScreen = null; // AThimel 29/06/15 null value is used

    /**
     * Selected result Territory.
     */
    protected List<TerritoryDto> selectedTerritories = new ArrayList<>();

    /**
     * the map containing loaeded territories
     */
    protected Map<String, List<SearchTerritoryResultDto>> territoryIncludedSpeasIds = new HashMap<>();

    /**
     * the speas ids of the comparator table .
     */
    protected List<Integer> comparatorSpeasIds = new ArrayList<>();

    /**
     * the exercice chosen by user for comparator
     */
    protected Integer chosenExerciseId = null;

    /**
     * the competence chosen by user for comparator
     */
    protected Integer competenceId = null;

    /**
     * Current session's municipality Id.
     */
    protected Integer municipalityId = null;

    /**
     * Current session's territory.
     */
    protected TerritoryDto territory = null;

    /**
     * The messages issued by the uploaded file validation.
     */
    protected Collection<ExchangeMessageDto> uploadedFileMsgs = null;

    /**
     * The last request parameters used for the territory search.
     * These parameters are re-used when scrolling through the result pages.
     */
    protected SearchTerritoryDto searchTerritory = null;

    /**
     * list of "my request" for the territory search.
     */
    protected List<SearchTerritoryDto> mySearchsTerritorys;

    /**
     * list of "my request" for the users search.
     */
    protected List<UsersFilterDto> mySearchsUsers;

    /**
     * LDAP Users Email loaded
     */
    protected boolean LDAPUsersEmailLoaded = false; // FIXME AThimel 29/06/15 Ça n'a rien à faire dans la session utilisateur je pense

    /**
     * The user filter informations associated with the action.
     */
    protected UsersFormDto usersSearchInfo = null;

    /**
     * The initial url asked for by the user before redirected to the
     * login page. This attribute should only be used in the login process.
     */
    protected String urlGoingTo = null; // FIXME AThimel 29/06/15 This should not be stored in session

    /**
     * display xmlGroup list
     */
    protected List<XmlGroupTab> xmlGroups = new ArrayList<>();

    /**
     * context detail values for tax editor
     */
    protected List<XmlGroupTableDetailValue> xmlCurrentContextGroup = null;

    /**
     * current xmlGroup detailed for price or tax editor
     */
    protected XmlGroupTableDetailValue xmlCurrentGroupDetailed = null;

    /**
     * current xmlGroup to detail for price or tax editor
     */
    protected XmlGroupTableDetail xmlCurrentGroupToDetail = null;

    /**
     * This method initializes the session.
     * Each action that start a new GUI sequence should call this method
     * to have a initialized and clean session.
     *
     * This method must be updated whenever new objects are added to the
     * SISPEA session.
     */
    public void init() {
        if (logger.isDebugEnabled()) {
            logger.debug("Reinitializing session");
        }

        // Do not reinitialize the user attribute.
        // Do not reinitialize the menu_ attribute.

        // Initialize all objects of a GUI sequence here.
        // All sequence specific attributes should be set to null.
        uploadedFileMsgs = null;
        urlGoingTo = null;
    }

    public UserDto getUser() {
        return user;
    }

    public void setUser(UserDto pUser) {
        user = pUser;
    }

    public MenuBean getMenu() {
        return menu;
    }

    public void setMenu(MenuBean pMenu) {
        menu = pMenu;
    }

    public Collection<ExchangeMessageDto> getUploadedFileMsgs() {
        return uploadedFileMsgs;
    }

    public void setUploadedFileMsgs(Collection<ExchangeMessageDto> pUploadedFileMsgs) {
        uploadedFileMsgs = pUploadedFileMsgs;
    }

    public SearchTerritoryDto getSearchTerritory() {
        return searchTerritory;
    }

    public void setSearchTerritory(SearchTerritoryDto pSearchTerritory) {
        searchTerritory = pSearchTerritory;
    }

    public Integer getMunicipalityId() {
        return municipalityId;
    }

    public void setMunicipalityId(Integer pMunicipalityId) {
        municipalityId = pMunicipalityId;
    }

    public List<SearchTerritoryDto> getMySearchsTerritorys() {

        if (mySearchsTerritorys == null) {
            mySearchsTerritorys = new ArrayList<>();
        }
        return mySearchsTerritorys;
    }

    public void setMySearchsTerritorys(List<SearchTerritoryDto> pMySearchsTerritorys) {
        mySearchsTerritorys = pMySearchsTerritorys;
    }

    public List<UsersFilterDto> getMySearchsUsers() {

        if (mySearchsUsers == null) {
            mySearchsUsers = new ArrayList<>();
        }
        return mySearchsUsers;
    }

    public void setMySearchsUsers(List<UsersFilterDto> pMySearchsUsers) {
        mySearchsUsers = pMySearchsUsers;
    }

    public TerritoryDto getTerritory() {
        return territory;
    }

    public void setTerritory(TerritoryDto pTerritory) {
        territory = pTerritory;
    }

    public String getUrlGoingTo() {
        return urlGoingTo;
    }

    public void setUrlGoingTo(String pUrlGoingTo) {
        urlGoingTo = pUrlGoingTo;
    }

    public List<TerritoryDto> getSelectedTerritories() {
        return selectedTerritories;
    }

    public void setSelectedTerritories(List<TerritoryDto> pSelectedTerritories) {
        selectedTerritories = pSelectedTerritories;
    }

    public UsersFormDto getUsersSearchInfo() {
        return usersSearchInfo;
    }

    public void setUsersSearchInfo(UsersFormDto pUsersSearchInfo) {
        usersSearchInfo = pUsersSearchInfo;
    }

    public List<Integer> getComparatorSpeasIds() {
        return comparatorSpeasIds;
    }

    public void setComparatorSpeasIds(List<Integer> pComparatorSpeasIds) {
        comparatorSpeasIds = pComparatorSpeasIds;
    }

    public Integer getChosenExerciseId() {
        return chosenExerciseId;
    }

    public void setChosenExerciseId(Integer pChosenExerciseId) {
        chosenExerciseId = pChosenExerciseId;
    }

    public Integer getCompetenceId() {
        return competenceId;
    }

    public void setCompetenceId(Integer pCompetenceId) {
        competenceId = pCompetenceId;
    }

    public List<XmlGroupTab> getXmlGroups() {
        return xmlGroups;
    }

    public void setXmlGroups(List<XmlGroupTab> pXmlGroups) {
        xmlGroups = pXmlGroups;
    }

    public XmlGroupTableDetailValue getXmlCurrentGroupDetailed() {
        return xmlCurrentGroupDetailed;
    }

    public void setXmlCurrentGroupDetailed(XmlGroupTableDetailValue pXmlCurrentGroupDetailed) {
        xmlCurrentGroupDetailed = pXmlCurrentGroupDetailed;
    }

    public XmlGroupTableDetail getXmlCurrentGroupToDetail() {
        return xmlCurrentGroupToDetail;
    }

    public void setXmlCurrentGroupToDetail(
            XmlGroupTableDetail pXmlCurrentGroupToDetail) {
        xmlCurrentGroupToDetail = pXmlCurrentGroupToDetail;
    }

    public List<XmlGroupTableDetailValue> getXmlCurrentContextGroup() {
        return xmlCurrentContextGroup;
    }

    public void setXmlCurrentContextGroup(
            List<XmlGroupTableDetailValue> pXmlCurrentContextGroup) {
        xmlCurrentContextGroup = pXmlCurrentContextGroup;
    }

    public boolean isFullScreen() {
        if (fullScreen == null) {
            // First start: if user authenticated full screen is on by default
            if (user == null) {
                return false;
            } else {
                return true;
            }
        } else {
            return fullScreen;
        }
    }

    public void setFullScreen(boolean pFullScreen) {
        fullScreen = pFullScreen;
    }

    public List<SearchTerritoryResultDto> getTerritoryIncludedSpeasIds(TerritoryDto pTerritory, ExerciseDto pExercise) {

        // init
        List<SearchTerritoryResultDto> lRes = null;

        // key
        String lKey = buildMapKey(pTerritory, pExercise);
        if (lKey != null) {
            lRes = territoryIncludedSpeasIds.get(lKey);
        }

        // result
        return lRes;
    }

    public void setTerritoryIncludedSpeasIds(TerritoryDto pTerritory, ExerciseDto pExercise, List<SearchTerritoryResultDto> pSearchTerritoryResult) {

        // key
        String lKey = buildMapKey(pTerritory, pExercise);
        if (lKey != null) {
            territoryIncludedSpeasIds.put(lKey, pSearchTerritoryResult);
        }

    }

    public void clearTerritoryIncludedSpeasIds() {
        territoryIncludedSpeasIds = new HashMap<>();
    }

    protected String buildMapKey(TerritoryDto pTerritory, ExerciseDto pExercise) {

        // init
        String lKey = null;

        // key
        if (pTerritory != null) {
            lKey = pTerritory.getId().toString();
        }
        if (pExercise != null && lKey != null) {
            lKey = lKey + "|" + pExercise.getId().toString();
        }

        // result
        return lKey;

    }

    public boolean isLDAPUsersEmailLoaded() {
        return LDAPUsersEmailLoaded;
    }

    public void setLDAPUsersEmailLoaded(boolean lDAPUsersEmailLoaded) {
        LDAPUsersEmailLoaded = lDAPUsersEmailLoaded;
    }
}
