/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.t3.web.interceptors;

import com.google.common.collect.Sets;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.util.TextParseUtil;
import fr.ird.t3.web.T3Session;
import fr.ird.t3.web.interceptors.AbstractCheckInterceptor;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CheckInUserSessionInterceptor
extends AbstractCheckInterceptor {
    private static final long serialVersionUID = 1L;
    protected static final Log log = LogFactory.getLog(CheckInUserSessionInterceptor.class);
    private Set<String> parameters = Collections.emptySet();

    public void setParameters(String parameters) {
        this.parameters = TextParseUtil.commaDelimitedStringToSet((String)parameters);
    }

    protected boolean doCheck(ActionInvocation invocation) {
        T3Session t3Session = T3Session.getT3Session((ActionContext)invocation.getInvocationContext());
        HashSet missingKeys = null;
        for (String parameter : this.parameters) {
            boolean ok = t3Session.contains(parameter);
            if (ok) continue;
            if (missingKeys == null) {
                missingKeys = Sets.newHashSet();
            }
            missingKeys.add(parameter);
        }
        boolean result = true;
        if (CollectionUtils.isNotEmpty(missingKeys)) {
            String message = "Some objects were not found in session : " + missingKeys + ", " + "redirect to " + this.redirectAction;
            if (log.isInfoEnabled()) {
                log.info((Object)message);
            }
            result = false;
        }
        return result;
    }
}

