/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.t3.web;

import fr.ird.converter.FloatConverter;
import fr.ird.t3.T3Configuration;
import fr.ird.t3.T3ServiceFactory;
import fr.ird.t3.entities.user.T3User;
import fr.ird.t3.entities.user.T3UserImpl;
import fr.ird.t3.services.DatabaseService;
import fr.ird.t3.services.UserService;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cfg.Configuration;
import org.nuiton.i18n.I18n;
import org.nuiton.i18n.init.DefaultI18nInitializer;
import org.nuiton.i18n.init.I18nInitializer;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.framework.TopiaUtil;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.converter.ConverterUtil;

public class T3ApplicationListener
implements ServletContextListener {
    protected static final Log log;

    public void contextInitialized(ServletContextEvent sce) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Application starting at " + new Date() + "..."));
        }
        T3Configuration configuration = new T3Configuration();
        configuration.init();
        T3ServiceFactory.setConfiguration((ApplicationConfig)configuration);
        DefaultI18nInitializer i18nInitializer = new DefaultI18nInitializer("t3-i18n");
        i18nInitializer.setMissingKeyReturnNull(true);
        I18n.init((I18nInitializer)i18nInitializer, (Locale)Locale.getDefault());
        Converter converter = ConverterUtil.getConverter(Float.class);
        if (converter != null) {
            ConvertUtils.deregister(Float.class);
        }
        ConvertUtils.register((Converter)new FloatConverter(), Float.class);
        T3ServiceFactory serviceFactory = T3ServiceFactory.newInstance();
        this.initInternalDatabase(serviceFactory, configuration);
    }

    public void contextDestroyed(ServletContextEvent sce) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Application is ending at " + new Date() + "..."));
        }
        T3ServiceFactory.destroy();
    }

    protected void initInternalDatabase(T3ServiceFactory serviceFactory, T3Configuration configuration) {
        DatabaseService databaseService = (DatabaseService)serviceFactory.newService(DatabaseService.class);
        try {
            boolean schemaNeedUpdate;
            boolean bl = schemaNeedUpdate = !this.isInternalSchemaCreated(databaseService) || configuration.getOptionAsBoolean("updateSchema");
            if (schemaNeedUpdate) {
                this.updateInternalSchema(databaseService);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("could not start db", e);
        }
        try {
            this.createAdminUser(serviceFactory, databaseService);
        }
        catch (Exception e) {
            throw new IllegalStateException("could not create default admin user", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateInternalSchema(DatabaseService databaseService) throws TopiaException {
        if (log.isInfoEnabled()) {
            log.info((Object)"Will create or update schema for db.");
        }
        Properties dbConf = databaseService.getInternalDatabaseConfiguration();
        dbConf.put("hibernate.hbm2ddl.auto", "update");
        TopiaContext tx = null;
        try {
            tx = databaseService.beginInternalTransaction();
        }
        finally {
            dbConf.put("hibernate.hbm2ddl.auto", "none");
            this.closeTransaction(tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createAdminUser(T3ServiceFactory serviceFactory, DatabaseService databaseService) throws Exception {
        TopiaContext tx = databaseService.beginInternalTransaction();
        try {
            UserService service = (UserService)serviceFactory.newTransactionalService(UserService.class, tx);
            List users = service.getUsers();
            if (CollectionUtils.isEmpty((Collection)users)) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"No user in database, will create default admin user (password admin).");
                }
                T3UserImpl u = new T3UserImpl();
                u.setLogin("admin");
                u.setPassword("admin");
                u.setAdmin(true);
                service.createUser((T3User)u);
            }
        }
        finally {
            this.closeTransaction(tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isInternalSchemaCreated(DatabaseService databaseService) throws TopiaException {
        TopiaContextImplementor tx = (TopiaContextImplementor)databaseService.beginInternalTransaction();
        try {
            boolean schemaFound;
            boolean bl = schemaFound = TopiaUtil.isSchemaExist((Configuration)tx.getHibernateConfiguration(), (String)T3UserImpl.class.getName());
            return bl;
        }
        finally {
            this.closeTransaction((TopiaContext)tx);
        }
    }

    protected void closeTransaction(TopiaContext tx) throws TopiaException {
        if (tx != null && !tx.isClosed()) {
            tx.closeContext();
        }
    }

    static {
        block5: {
            block4: {
                log = LogFactory.getLog(T3ApplicationListener.class);
                try {
                    Class.forName("org.postgresql.Driver");
                }
                catch (ClassNotFoundException e) {
                    if (!log.isErrorEnabled()) break block4;
                    log.error((Object)"Could not find pg driver", (Throwable)e);
                }
            }
            try {
                Class.forName("org.h2.Driver");
            }
            catch (ClassNotFoundException e) {
                if (!log.isErrorEnabled()) break block5;
                log.error((Object)"Could not find h2 driver", (Throwable)e);
            }
        }
    }
}

