/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.t3.web.actions.json;

import fr.ird.t3.entities.data.Trip;
import fr.ird.t3.entities.data.TripDAO;
import fr.ird.t3.entities.data.TripDTO;
import fr.ird.t3.entities.reference.Country;
import fr.ird.t3.entities.reference.Ocean;
import fr.ird.t3.entities.reference.Vessel;
import fr.ird.t3.services.ioc.InjectDAO;
import fr.ird.t3.web.actions.T3BaseTransactionAction;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;

public class GetTripsAction
extends T3BaseTransactionAction {
    private static final long serialVersionUID = 1L;
    @InjectDAO(entityType=Trip.class)
    protected transient TripDAO tripDAO;
    protected List<TripDTO> trips;
    protected List<Integer> years;
    protected List<String> oceanIds;
    protected List<String> fleetIds;
    protected List<String> vesselIds;

    public List<TripDTO> getTrips() {
        return this.trips;
    }

    public void setYears(List<Integer> years) {
        this.years = years;
    }

    public void setOceanIds(List<String> oceanIds) {
        this.oceanIds = oceanIds;
    }

    public void setFleetIds(List<String> fleetIds) {
        this.fleetIds = fleetIds;
    }

    public void setVesselIds(List<String> vesselIds) {
        this.vesselIds = vesselIds;
    }

    public String execute() throws Exception {
        Trip trip;
        Iterator itr;
        this.injectOnly(new Class[]{InjectDAO.class});
        List t3Trips = this.tripDAO.findAll();
        if (CollectionUtils.isNotEmpty((Collection)this.years)) {
            Calendar cal = Calendar.getInstance();
            Iterator itr2 = t3Trips.iterator();
            while (itr2.hasNext()) {
                Trip trip2 = (Trip)itr2.next();
                Date departureDate = trip2.getDepartureDate();
                cal.setTime(departureDate);
                int year = cal.get(1);
                if (this.years.contains(year)) continue;
                itr2.remove();
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)this.oceanIds)) {
            itr = t3Trips.iterator();
            while (itr.hasNext()) {
                trip = (Trip)itr.next();
                boolean oceanFound = false;
                Set allOceans = trip.getAllOceans();
                for (Ocean ocean : allOceans) {
                    if (!this.oceanIds.contains(ocean.getTopiaId())) continue;
                    oceanFound = true;
                    break;
                }
                if (oceanFound) continue;
                itr.remove();
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)this.fleetIds)) {
            itr = t3Trips.iterator();
            while (itr.hasNext()) {
                trip = (Trip)itr.next();
                Country fleet = trip.getVessel().getFleetCountry();
                if (this.fleetIds.contains(fleet.getTopiaId())) continue;
                itr.remove();
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)this.vesselIds)) {
            itr = t3Trips.iterator();
            while (itr.hasNext()) {
                trip = (Trip)itr.next();
                Vessel vessel = trip.getVessel();
                if (this.vesselIds.contains(vessel.getTopiaId())) continue;
                itr.remove();
            }
        }
        this.trips = TripDAO.toDTO((Collection)t3Trips);
        return "success";
    }
}

