/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.t3.web.actions.data.level1;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import fr.ird.t3.actions.T3ActionConfiguration;
import fr.ird.t3.actions.data.level1.Level1Configuration;
import fr.ird.t3.entities.T3EntityHelper;
import fr.ird.t3.entities.data.Trip;
import fr.ird.t3.entities.data.TripDAO;
import fr.ird.t3.entities.reference.Country;
import fr.ird.t3.entities.reference.CountryDAO;
import fr.ird.t3.entities.reference.Ocean;
import fr.ird.t3.entities.reference.OceanDAO;
import fr.ird.t3.entities.reference.SampleQuality;
import fr.ird.t3.entities.reference.SampleQualityDAO;
import fr.ird.t3.entities.reference.SampleType;
import fr.ird.t3.entities.reference.SampleTypeDAO;
import fr.ird.t3.entities.type.T3Date;
import fr.ird.t3.services.ioc.InjectDecoratedBeans;
import fr.ird.t3.services.ioc.InjectFromDAO;
import fr.ird.t3.web.actions.AbstractConfigureAction;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;
import org.nuiton.util.decorator.Decorator;
import org.nuiton.web.struts2.interceptor.TopiaTransactionInterceptor;

@TopiaTransactionInterceptor.NoCommit
public class ManageLevel1ConfigurationAction
extends AbstractConfigureAction<Level1Configuration> {
    private static final long serialVersionUID = 1L;
    @InjectDecoratedBeans(beanType=SampleQuality.class)
    protected Map<String, String> sampleQualities;
    @InjectDecoratedBeans(beanType=SampleType.class)
    protected Map<String, String> sampleTypes;
    @InjectDecoratedBeans(beanType=Country.class)
    protected Map<String, String> fleets;
    @InjectDecoratedBeans(beanType=Ocean.class)
    protected Map<String, String> oceans;
    @InjectFromDAO(entityType=Trip.class)
    protected Collection<Trip> trips;
    protected Map<String, Trip> tripByTopiaIds;

    public ManageLevel1ConfigurationAction() {
        super(Level1Configuration.class);
    }

    public void prepare() throws Exception {
        this.setConfirm(false);
        boolean configExists = this.isConfigurationInSession();
        Level1Configuration conf = (Level1Configuration)this.getConfiguration();
        this.injectExcept(new Class[]{InjectDecoratedBeans.class});
        this.tripByTopiaIds = T3EntityHelper.splitByTopiaId((Collection)this.trips);
        if (!configExists) {
            MutablePair landingBound = TripDAO.getActivityBoundDate((Collection)this.trips);
            Date firstDate = (Date)landingBound.getLeft();
            Date lastDate = (Date)landingBound.getRight();
            if (firstDate != null) {
                conf.setBeginDate(T3Date.newDate((Date)firstDate));
            }
            if (lastDate != null) {
                conf.setEndDate(T3Date.newDate((Date)lastDate));
            }
            conf.setSampleQualities(this.sortToList((Collection)SampleQualityDAO.getAllSampleQualities((Collection)this.trips)));
            conf.setSampleTypes(this.sortToList((Collection)SampleTypeDAO.getAllSampleTypes((Collection)this.trips)));
            conf.setFleets(this.sortToList((Collection)CountryDAO.getAllFleetCountries((Collection)this.trips)));
            conf.setOceans(this.sortToList((Collection)OceanDAO.getAllOcean((Collection)this.trips)));
            List ids = Lists.newArrayList();
            conf.setFleetIds(ids);
            ids = T3EntityHelper.selectIdsByCodes((Collection)conf.getSampleQualities(), (Integer[])new Integer[]{1, 2, 3, 9});
            conf.setSampleQualityIds(ids);
            ids = T3EntityHelper.selectIdsByCodes((Collection)conf.getSampleTypes(), (Integer[])new Integer[]{1, 2, 3, 9});
            conf.setSampleTypeIds(ids);
            ids = TopiaEntityHelper.getTopiaIdList((List)conf.getFleets());
            conf.setFleetIds(ids);
        }
        this.injectOnly(new Class[]{InjectDecoratedBeans.class});
        Multimap matchingTrips = conf.getMatchingTrips(this.trips);
        conf.setSampleIdsByTripId(matchingTrips);
    }

    @TopiaTransactionInterceptor.NoCommit
    public final String prepareConfiguration() throws Exception {
        if (!this.isConfigurationInSession() && !this.hasFieldErrors()) {
            this.storeActionConfiguration(this.configuration);
        }
        return "input";
    }

    public String saveConfiguration() throws Exception {
        Level1Configuration config = (Level1Configuration)this.getConfiguration();
        config.getExecutedSteps().clear();
        this.storeActionConfiguration((T3ActionConfiguration)config);
        this.setConfirm(true);
        return "success";
    }

    @SkipValidation
    public String removeConfiguration() throws Exception {
        boolean saved = this.isConfigurationInSession();
        if (saved) {
            this.removeConfigurationFromSession();
        }
        return "success";
    }

    public int getMatchingTripCount() {
        Map tripIds = this.getTripIds();
        return MapUtils.isEmpty((Map)tripIds) ? 0 : tripIds.size();
    }

    public int getMatchingSampleCount() {
        Map tripIds = this.getTripIds();
        if (MapUtils.isEmpty((Map)tripIds)) {
            return 0;
        }
        int nbSamples = 0;
        for (Collection sampleIds : tripIds.values()) {
            nbSamples += sampleIds.size();
        }
        return nbSamples;
    }

    public Map<String, Collection<String>> getTripIds() {
        Map ids = ((Level1Configuration)this.getConfiguration()).getSampleIdsByTripId().asMap();
        return ids;
    }

    public Map<String, String> getSampleQualities() {
        return this.sampleQualities;
    }

    public Map<String, String> getSampleTypes() {
        return this.sampleTypes;
    }

    public Map<String, String> getFleets() {
        return this.fleets;
    }

    public Map<String, String> getOceans() {
        return this.oceans;
    }

    public Decorator<Trip> getTripDecorator() {
        return this.getDecorator(Trip.class);
    }

    public Map<String, Trip> getTripByTopiaIds() {
        return this.tripByTopiaIds;
    }
}

