/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.t3.web.actions;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import fr.ird.t3.T3ConfigurationHelper;
import fr.ird.t3.T3ServiceFactory;
import fr.ird.t3.entities.reference.Idable;
import fr.ird.t3.services.DatabaseService;
import fr.ird.t3.services.DecoratorService;
import fr.ird.t3.services.FreeMarkerService;
import fr.ird.t3.services.IOCService;
import fr.ird.t3.services.T3InputService;
import fr.ird.t3.services.T3OutputService;
import fr.ird.t3.services.ZoneStratumService;
import fr.ird.t3.web.T3Session;
import fr.ird.t3.web.T3SessionAware;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.decorator.Decorator;
import org.nuiton.web.struts2.BaseAction;

public class T3BaseAction
extends BaseAction
implements T3SessionAware {
    private static final long serialVersionUID = 1L;
    public static final String LOG_LINE = "--------------------------------------------------------------------------------";
    private transient T3Session t3Session;

    public final void setT3Session(T3Session t3Session) {
        this.t3Session = t3Session;
    }

    protected T3Session getT3Session() {
        return this.t3Session;
    }

    protected <C> C getActionConfiguration(Class<C> configurationClass) {
        return (C)this.getT3Session().getActionConfiguration(configurationClass);
    }

    public static String getApplicationVersion() {
        return T3ConfigurationHelper.getApplicationVersion((ApplicationConfig)T3ServiceFactory.getConfiguration());
    }

    protected ApplicationConfig getApplicationConfig() {
        return T3ServiceFactory.getConfiguration();
    }

    public T3ServiceFactory getServiceFactory() {
        Preconditions.checkNotNull((Object)this.t3Session, (Object)"No t3 user session injected.");
        T3ServiceFactory factory = this.t3Session.getServiceFactory();
        return factory;
    }

    public DecoratorService getDecoratorService() {
        return (DecoratorService)this.getServiceFactory().newService(DecoratorService.class);
    }

    public FreeMarkerService getFreeMarkerService() {
        return (FreeMarkerService)this.getServiceFactory().newService(FreeMarkerService.class);
    }

    public DatabaseService getDatabaseService() {
        return (DatabaseService)this.getServiceFactory().newService(DatabaseService.class);
    }

    public IOCService getIocService() {
        return (IOCService)this.getServiceFactory().newService(IOCService.class);
    }

    public ZoneStratumService getZoneStratumService() {
        return (ZoneStratumService)this.getServiceFactory().newService(ZoneStratumService.class);
    }

    public T3InputService getT3InputService() {
        return (T3InputService)this.getServiceFactory().newService(T3InputService.class);
    }

    public T3OutputService getT3OutputService() {
        return (T3OutputService)this.getServiceFactory().newService(T3OutputService.class);
    }

    protected void injectExcept(Class<?> ... annotations) throws Exception {
        this.getIocService().injectExcept((Object)this, (Class[])annotations);
    }

    protected void injectOnly(Class<?> ... annotations) throws Exception {
        this.getIocService().injectOnly((Object)this, (Class[])annotations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addContentInFile(T3Session session, String content) {
        File userLogfile = session.getUserLogFile();
        try {
            FileWriter writer = new FileWriter(userLogfile, true);
            try {
                writer.append(content);
            }
            finally {
                writer.close();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not write content in user log file " + userLogfile, e);
        }
    }

    public <O> Decorator<O> getDecorator(Class<O> type) {
        Decorator decorator = this.getDecorator(type, null);
        return decorator;
    }

    public <O> Decorator<O> getDecorator(Class<O> type, String context) {
        Decorator decorator = this.getDecoratorService().getDecorator(this.getLocale(), type, context);
        return decorator;
    }

    protected <E extends TopiaEntity> Map<String, String> sortAndDecorate(Collection<E> beans) {
        Map result = this.sortAndDecorate(beans, null);
        return result;
    }

    protected <E extends TopiaEntity> Map<String, String> sortAndDecorate(Collection<E> beans, String context) {
        Map result = this.getDecoratorService().sortAndDecorate(this.getLocale(), beans, context);
        return result;
    }

    protected <E extends Idable> Map<String, String> sortAndDecorateIdAbles(Collection<E> beans) {
        Map result = this.sortAndDecorateIdAbles(beans, null);
        return result;
    }

    protected <E extends Idable> Map<String, String> sortAndDecorateIdAbles(Collection<E> beans, String context) {
        Map result = this.getDecoratorService().sortAndDecorateIdAbles(this.getLocale(), beans, context);
        return result;
    }

    protected <E> List<E> sortToList(Collection<E> beans) {
        List list = this.sortToList(beans, null);
        return list;
    }

    protected <E> List<E> sortToList(Collection<E> beans, String context) {
        List list = this.getDecoratorService().sortToList(this.getLocale(), beans, context);
        return list;
    }

    protected Map<String, String> createTimeSteps() {
        LinkedHashMap timeSteps = Maps.newLinkedHashMap();
        for (int i = 1; i < 13; ++i) {
            timeSteps.put("" + i, "" + i);
        }
        return timeSteps;
    }
}

