/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.list;

import fr.ird.observe.ui.content.ContentUIModel;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class ContentListUIModel<E extends TopiaEntity, C extends TopiaEntity>
extends ContentUIModel<E> {
    public static final String PROPERTY_DATA = "data";
    public static final String PROPERTY_SELECTED_DATA = "selectedData";
    public static final String PROPERTY_EMPTY = "empty";
    public static final String PROPERTY_CAN_REOPEN = "canReopen";
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ContentListUIModel.class);
    protected final Class<C> childType;
    protected List<C> data;
    protected C selectedData;
    protected boolean canReopen;

    public ContentListUIModel(Class<E> beanType, Class<C> childType) {
        super(beanType);
        this.childType = childType;
    }

    public Class<C> getChildType() {
        return this.childType;
    }

    public List<C> getData() {
        return this.data;
    }

    public void setData(List<C> data) {
        boolean wasEmpty = this.isEmpty();
        this.data = data;
        this.firePropertyChange(PROPERTY_DATA, null, data);
        this.firePropertyChange(PROPERTY_EMPTY, wasEmpty, this.isEmpty());
        this.setSelectedData(null);
    }

    public C getSelectedData() {
        return this.selectedData;
    }

    public void setSelectedData(C selectedData) {
        C old = this.getSelectedData();
        this.selectedData = selectedData;
        if (log.isDebugEnabled()) {
            log.debug((Object)("New selected data : " + selectedData));
        }
        this.firePropertyChange(PROPERTY_SELECTED_DATA, old, selectedData);
    }

    public boolean isCanReopen() {
        return this.canReopen;
    }

    public void setCanReopen(boolean canReopen) {
        boolean old = this.isCanReopen();
        this.canReopen = canReopen;
        this.firePropertyChange(PROPERTY_CAN_REOPEN, old, canReopen);
    }

    public boolean isEmpty() {
        return this.data == null || this.data.isEmpty();
    }
}

