<%--
  #%L
  Agrosyst :: Web
  $Id$
  $HeadURL$
  %%
  Copyright (C) 2017 INRA
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as
  published by the Free Software Foundation, either version 3 of the
  License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public
  License along with this program.  If not, see
  <http://www.gnu.org/licenses/gpl-3.0.html>.
  #L%
  --%>
<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8" session="false" %>
<%@taglib uri="/struts-tags" prefix="s" %>

<div ng-controller="CropPestMasterEditController">
<div ng-controller="CropAllPestMastersController">
<div ng-controller="CropArboDiseaseMastersController">
  <input type="hidden" name="arboCropDiseaseMastersJson" value="{{cropPestMasters}}"/>

  <div class="wwgrp">
    <span class="wwlbl">
      <label class="tags">
        <div class="tags">
          <a ng-click="loadCropPestMaster('arboDisease')" href=""><span class="required">*&nbsp;</span>Maîtrise des maladies et bactérioses</a>
          <div ng-if="(viewPortArray && viewPortArray.length === 0) || (cropPestMasters && cropPestMasters.length === 0)">
            <input type="text" ng-model="error" required="true" style="opacity:0;width: 0;"/>
          </div>
        </div>
      </label>
    </span>
  </div>

  <div ng-show="showArboDiseaseCropPestMasters" class="loadContentEnclosure">
      <div class="grid-enclosure" ng-attr-style="grid-template-columns: 20% repeat({{viewPortArray.length||1}}, 1fr) min-content;"
            ng-style="{'-ms-grid-columns': '20% (1fr)[' + (viewPortArray.length||1) + '] min-content;'}">
        <div ng-attr-style="grid-column: 1;grid-row: 1;" ng-click="moveViewPort(-1)" ng-if="viewPortIndex > 0" class="gridArrow">&Lang;</div>
        <div ng-attr-style="grid-column: {{viewPortArray.length + 3}}; grid-row: 1 / span 2;" ng-click="moveViewPort(+1)" ng-if="viewPortIndex < maxViewPort - 3" class="gridArrow">&rarr;</div>
        <div ng-attr-style="grid-column: 1;grid-row: 3;" class="gridColumnMainHeader">Pression sur le système de culture&nbsp;:</div>
        <div ng-attr-style="grid-column: 1;grid-row: 4;" class="gridColumnHeader oddCell">- Inoculum année(s) précédente(s)</div>
        <div ng-attr-style="grid-column: 1;grid-row: 5;" class="gridColumnHeader">- Evolution par rapport à l’année précédente</div>
        <div ng-attr-style="grid-column: 1;grid-row: 6;" class="gridColumnHeader">- Echelle de pression</div>
        <div ng-attr-style="grid-column: 1;grid-row: 7;" class="gridColumnMainHeader">Résultats obtenus, niveau de maîtrise finale&nbsp;:</div>
        <div ng-attr-style="grid-column: 1;grid-row: 8;" class="gridColumnHeader">- <span class="required">*&nbsp;</span>Échelle de maîtrise</div>
        <div ng-attr-style="grid-column: 1;grid-row: 9;" class="gridColumnHeader">- % parcelles touchées</div>
        <div ng-attr-style="grid-column: 1;grid-row: 10;" class="gridColumnHeader oddCell">- % arbres touchés</div>
        <div ng-attr-style="grid-column: 1;grid-row: 11;" class="gridColumnHeader">- % dommages sur fruits</div>
        <div ng-attr-style="grid-column: 1;grid-row: 12;" class="gridColumnHeader oddCell">- % dommages sur pousses ou feuilles</div>
        <div ng-attr-style="grid-column: 1;grid-row: 13;" class="gridColumnHeader">- Inoculum pour les années suivantes</div>
        <div ng-attr-style="grid-column: 1;grid-row: 14;" class="gridColumnHeader">- <span class="required">*&nbsp;</span>Qualification du niveau de maîtrise</div>
        <div ng-attr-style="grid-column: 1;grid-row: 15;" class="gridColumnHeader">- Expression de l’agriculteur</div>
        <div ng-attr-style="grid-column: 1;grid-row: 16;" class="gridColumnHeader oddCell">- Commentaire du conseiller/de l'expérimentateur</div>
        <div ng-attr-style="grid-column: 1;grid-row: 17;" class="gridColumnMainHeader">IFT&nbsp;:</div>
        <div ng-attr-style="grid-column: 1;grid-row: 18;" class="gridColumnHeader">- Nombre de traitements</div>
        <div ng-attr-style="grid-column: 1;grid-row: 19;" class="gridColumnHeader">- IFT-Fongicide (chimique)</div>
        <div ng-attr-style="grid-column: 1;grid-row: 20;" class="gridColumnHeader" >- IFT-fongicide biocontrôle</div>
        <div ng-attr-style="grid-column: 1;grid-row: 21;" class="gridColumnHeader"></div>

        <div ng-attr-style="grid-column: {{$index+2}} / span {{pestMaster.$$cropspan}}; grid-row: 1;" class="gridMainHeader" ng-repeat-start="pestMaster in viewPortArray" ng-if="pestMaster.$$cropspan > 0">
          <span ng-repeat="crop in pestMaster.$$crop.crops">
            {{crop.name}}<span ng-if="!$last">,</span>
          </span>
        </div>
        <div ng-attr-style="grid-column: {{$index+2}};grid-row: 2;" class="gridSubHeader">{{getAgressorLabel(pestMaster)}}</div>
        <div ng-attr-style="grid-column: {{$index+2}};grid-row: 3;" class="gridCell" ng-class="{gridCellLast: $last}"></div>
        <div ng-attr-style="grid-column: {{$index+2}};grid-row: 4;" class="gridCell oddCell" ng-class="{gridCellLast: $last}">{{pestMaster.previousYearInoculum|translate:'InoculumLevel'}}</div>
        <div ng-attr-style="grid-column: {{$index+2}};grid-row: 5;" class="gridCell" ng-class="{gridCellLast: $last}">{{pestMaster.pressureEvolution|translate:'PressureEvolution'}}</div>
        <div ng-attr-style="grid-column: {{$index+2}};grid-row: 6;" class="gridCell" ng-class="{gridCellLast: $last}">{{pestMaster.pressureScale|translate:'PressureScale'}}</div>
        <div ng-attr-style="grid-column: {{$index+2}};grid-row: 7;" class="gridCell" ng-class="{gridCellLast: $last}"></div>
        <div ng-attr-style="grid-column: {{$index+2}};grid-row: 8;" class="gridCell" ng-class="{gridCellLast: $last}">{{pestMaster.masterScale|translate:'MasterScale'}}</div>
        <div ng-attr-style="grid-column: {{$index+2}};grid-row: 9;" class="gridCell" ng-class="{gridCellLast: $last}">{{pestMaster.percentAffectedPlots|translate:'DamageLevel'}}</div>
        <div ng-attr-style="grid-column: {{$index+2}};grid-row: 10;" class="gridCell oddCell" ng-class="{gridCellLast: $last}">{{pestMaster.percentAffectedTrees}}</div>
        <div ng-attr-style="grid-column: {{$index+2}};grid-row: 11;" class="gridCell" ng-class="{gridCellLast: $last}">{{pestMaster.percentDamageFruits}}</div>
        <div ng-attr-style="grid-column: {{$index+2}};grid-row: 12;" class="gridCell oddCell" ng-class="{gridCellLast: $last}">{{pestMaster.percentDamageLeafs}}</div>
        <div ng-attr-style="grid-column: {{$index+2}};grid-row: 13;" class="gridCell" ng-class="{gridCellLast: $last}">{{pestMaster.nextYearInoculum|translate:'InoculumLevel'}}</div>
        <div ng-attr-style="grid-column: {{$index+2}};grid-row: 14;" class="gridCell" ng-class="{gridCellLast: $last}">{{pestMaster.qualifier|translate:'GlobalMasterLevelQualifier'}}</div>
        <div ng-attr-style="grid-column: {{$index+2}};grid-row: 15;" class="gridCell" ng-class="{gridCellLast: $last}" ag-read-more="{{pestMaster.resultFarmerComment}}"></div>
        <div ng-attr-style="grid-column: {{$index+2}};grid-row: 16;" class="gridCell oddCell" ng-class="{gridCellLast: $last}" ag-read-more="{{pestMaster.adviserComments}}"></div>
        <div ng-attr-style="grid-column: {{$index+2}};grid-row: 17;" class="gridCell  oddCell" ng-class="{gridCellLast: $last}"></div>
        <div id="ArboDiseaseCropPestMasters_treatmentCount_{{$index}}" ng-attr-style="grid-column: {{$index+2}} / span {{pestMaster.$$cropspan}};grid-row: 18;" class="gridCell cellForCrop" ng-class="{gridCellLast: $last}" ng-if="pestMaster.$$cropspan > 0">{{pestMaster.$$crop.treatmentCount}}<input type="text" ng-model="pestMaster.$$crop.treatmentCount" style="opacity:0;width: 0;"/></div>
        <div id="ArboDiseaseCropPestMasters_chemicalPestIFT_{{$index}}" ng-attr-style="grid-column: {{$index+2}} / span {{pestMaster.$$cropspan}};grid-row: 19;" class="gridCell cellForCrop" ng-class="{gridCellLast: $last}" ng-if="pestMaster.$$cropspan > 0">{{pestMaster.$$crop.chemicalPestIFT}}<input type="text" ng-model="pestMaster.$$crop.chemicalPestIFT" style="opacity:0;width: 0;"/></div>
        <div id="ArboDiseaseCropPestMasters_bioControlPestIFT_{{$index}}" ng-attr-style="grid-column: {{$index+2}} / span {{pestMaster.$$cropspan}};grid-row: 20;" class="gridCell cellForCrop" ng-class="{gridCellLast: $last}" ng-if="pestMaster.$$cropspan > 0">{{pestMaster.$$crop.bioControlPestIFT}}<input type="text" ng-model="pestMaster.$$crop.bioControlPestIFT"  style="opacity:0;width: 0;"/></div>

        <div ng-attr-style="grid-column: {{$index+2}};grid-row: 21;" class="gridActions" ng-class="{gridCellLast: $last}" ng-repeat-end>
          <input type="button" class="btn-icon icon-edit" value="Modifier" title="Modifier" ng-click="editPestMasterFromCropPestMaster(pestMaster.$$crop, pestMaster)" />
          <input type="button" class="btn-icon icon-delete" value="Supprimer" title="Supprimer" ng-click="deleteCropPestMaster(pestMaster.$$crop)" />
        </div>
        <div ng-attr-style="grid-column: 2;grid-row: 1 / span 22;" class="gridEmpty" ng-if="viewPortArray.length == 0">
          Aucune donnée présente. Vous pouvez en ajouter un en cliquant sur le bouton "Ajouter"
        </div>
        <div ng-attr-style="grid-column: 1 / span 5;grid-row: 23;" class="gridFooter">
          <input type="button" value="Ajouter une culture" ng-click="addCropPestMaster()"/>
        </div>
      </div>

      <div class="wwgrp">
          <s:fielderror fieldName="reportGrowingSystem.arboChemicalFungicideIFT" />
          <span class="wwlbl">
             <label class="label">IFT-fongicide du système de culture (chimique)&nbsp;:</label>
          </span>
          <span class="wwctrl">
            <input id="ArboDiseaseCropPestMasters_arboChemicalFungicideIFT"
                 class="column-xlarge" type="text" name="reportGrowingSystem.arboChemicalFungicideIFT" value="${reportGrowingSystem.arboChemicalFungicideIFT}" placeholder="ex: 1.5" />
          </span>
      </div>
      <div class="wwgrp">
            <s:fielderror fieldName="reportGrowingSystem.arboBioControlFungicideIFT" />
            <span class="wwlbl">
               <label class="label">IFT-fongicide biocontrôle du système de culture&nbsp;:</label>
            </span>
            <span class="wwctrl">
              <input id="ArboDiseaseCropPestMasters_arboBioControlFungicideIFT"
                 class="column-xlarge" type="text" name="reportGrowingSystem.arboBioControlFungicideIFT" value="${reportGrowingSystem.arboBioControlFungicideIFT}" placeholder="ex: 1.5" />
            </span>
      </div>
      <div class="wwgrp">
          <s:fielderror fieldName="reportGrowingSystem.arboCopperQuantity" />
          <span class="wwlbl">
             <label class="label">Quantité de cuivre appliquée (Kg Cu/ha)&nbsp;:</label>
          </span>
          <span class="wwctrl">
            <input id="ArboDiseaseCropPestMasters_arboCopperQuantity"
                 class="column-xlarge" type="text" name="reportGrowingSystem.arboCopperQuantity" value="${reportGrowingSystem.arboCopperQuantity}" placeholder="ex: 1.5"/>
          </span>
      </div>
      <s:select label="Niveau global de maîtrise des maladies"
                id="ArboDiseaseCropPestMasters_arboDiseaseQualifier"
                requiredLabel="true" ng-required="viewPortArray.length > 0" emptyOption="true"
                name="reportGrowingSystem.arboDiseaseQualifier" list="globalMasterLevelQualifiers"
                labelPosition="left" labelSeparator=" :" cssClass="column-xlarge"/>

      <div class="wwgrp">
        <span class="wwlbl"><label>Modèle décisionnel&nbsp;:</label></span>
        <span class="wwctrl">
          <div>
            <a class="asLabelUnderlined" ng-if="observeManagementModeId" target="_blank" rel="noopener noreferrer"
               href="<s:url namespace='/managementmodes' action='management-modes-edit-input'/>?managementModeTopiaId={{observeManagementModeId}}#sectionTypes_MALADIES">
               Ouvrir le modèle décisionnel
            </a>
          </div>
          <div id="redirectObserveManagementModeMALADIES" ng-if="!observeManagementModeId">Aucun</div>
        </span>
      </div>
  </div>

  <!-- edition -->
  <jqdialog dialog-name="addArboDiseaseCrops" auto-open="false" width="'55%'" class="dialog-form" modal="true"
      buttons="{'OK': onCropDialogOk, 'Annuler': onCropDialogCancel}"
      button-classes="{'OK': 'btn-primary', 'Annuler': 'float-left btn-secondary'}"
      title="'Maîtrise des maladies et batérioses'">
      <div class="asTable">

        <%@include file="inc-crop-template.jsp" %>

        <div class="section"><span class="required">*</span>&nbsp;Maladie(s) pour ces cultures</div>

        <div>
          <ul class="asTable">
            <li class="asContentTable0 fromContent">

              <span ng-repeat="pestMaster in editedCropObject.pestMasters">
                <span style="cursor:pointer" class="link"
                   ng-click="editPestMaster(editedCropObject, pestMaster)">{{getAgressorLabel(pestMaster)}}</span>
                <input type="button" class="btn-icon icon-delete" ng-click="deletePestMaster(editedCropObject, pestMaster)" value="x" title="Supprimer"/>
                <span ng-if="!$last">,</span>
              </span>

              <span class="info" ng-if="editedCropObject.pestMasters.length === 0">
                Aucune maladie déclarée
              </span>

              <span class="endLine">
                <div style="cursor:pointer"
                     class="textIcones blue x2"
                     ng-click="editPestMaster(editedCropObject)"
                     title="Déclarer une adventice">
                     +
                </div>
              </span>

            </li>
          </ul>
        </div>

        <div class="section">Quel niveau d’utilisation de pesticides ?</div>

        <div class="wwgrp">
          <span class="wwlbl wide-label"><label for="arboAdventicetreatmentCount">Nombre de traitements&nbsp;:</label></span>
          <span class="wwctrl">
            <input id="arboAdventicetreatmentCount"
                   class="column-xlarge"
                   type="text"
                   ng-model="editedCropObject.treatmentCount"
                   placeholder="ex: 1"
                   ag-float2dec
                   pattern="^\d+(?:[\.,]\d{1,2})?$"/>
          </span>
        </div>

        <div class="wwgrp">
          <span class="wwlbl wide-label"><label for="arboAdventicechemicalPestIFT">IFT-Fongicide (chimique)&nbsp;:</label></span>
          <span class="wwctrl">
            <input id="arboAdventicechemicalPestIFT"
                 class="column-xlarge" type="text" ng-model="editedCropObject.chemicalPestIFT" placeholder="ex: 1.5" ag-float2dec pattern="^\d+(?:[\.,]\d{1,2})?$"/>
          </span>
        </div>

        <div class="wwgrp">
          <span class="wwlbl wide-label"><label for="arboAdventicebioControlPestIFT">IFT-fongicide biocontrôle&nbsp;:</label></span>
          <span class="wwctrl">
            <input id="arboAdventicebioControlPestIFT"
                 class="column-xlarge" type="text" ng-model="editedCropObject.bioControlPestIFT" placeholder="ex: 1.5" ag-float2dec pattern="^\d+(?:[\.,]\d{1,2})?$"/>
          </span>
        </div>
      </div>
  </jqdialog>

  <jqdialog dialog-name="addArboDisease" auto-open="false" width="'55%'" class="dialog-form" modal="true"
      buttons="{'OK': onPestDialogOk, 'Annuler': onPestDialogCancel}"
      button-classes="{'OK': 'btn-primary', 'Annuler': 'float-left btn-secondary'}"
      title="'Maladie ciblée'">

    <div class="horizontal-separator">Pression avant intervention</div>

    <div class="oneFieldOutOfTwoRequired">
      <span class="required">*</span>&nbsp;<em>au moins un des deux</em>
    </div>

    <div class="wwgrp">
      <span class="wwlbl wide-label">
        <label for="codeGroupeCibleMaa" class="label">Groupe cible&nbsp;:</label>
      </span>
      <span class="wwctrl">
        <span class='contextual-help'>
          <span class='help-hover'>
            <s:text name="help.report.groupeCibleMaa" />
          </span>
        </span>
        <select ng-model="editedPestMaster.codeGroupeCibleMaa"
                class="column-xlarge"
                ng-options="groupeCible.codeGroupeCibleMaa as groupeCible.groupeCibleMaa for groupeCible in groupesCibles | filter: isGroupeCibleInCategory('MALADIE')">
          <option label="" value="" />
        </select>
      </span>
    </div>
    <div class="wwgrp">
      <span class="wwlbl wide-label">
        <label for="arboDiseaseAgressor" class="label">Maladie&nbsp;:</label>
      </span>
      <span class="wwctrl">
        <select id="arboAdventiceAgressor"
                ng-model="editedPestMaster.agressor"
                ng-if="bioAgressors && bioAgressors.length > 0"
                ng-options="(bioAgressor.adventice ? bioAgressor.adventice : bioAgressor.reference_label) disable when bioAgressor.main for bioAgressor in bioAgressors | filter: inGroupeCibleBioAgressor(editedPestMaster)"
                class="column-xlarge">
          <option value=""></option>
        </select>
      </span>
    </div>
    <div class="wwgrp">
      <span class="wwlbl wide-label"><label for="arboDiseasePreviousYearInoculum">Inoculum année(s) précédente(s)&nbsp;:</label></span>
      <span class="wwctrl">
        <select id="arboDiseasePreviousYearInoculum" ng-options="key as value for (key, value) in i18n.InoculumLevel"
            ng-model="editedPestMaster.previousYearInoculum" class="column-xlarge">
          <option value=""></option>
        </select>
      </span>
    </div>
    <div class="wwgrp">
      <span class="wwlbl wide-label"><label for="arboDiseasePressureEvolution">Evolution par rapport à l’année précédente&nbsp;:</label></span>
      <span class="wwctrl">
        <select id="arboDiseasePressureEvolution" ng-options="key as value for (key, value) in i18n.PressureEvolution"
            ng-model="editedPestMaster.pressureEvolution" class="column-xlarge">
          <option value=""></option>
        </select>
      </span>
    </div>
    <div class="wwgrp">
      <span class="wwlbl wide-label"><label for="arboDiseasePressureScale">Echelle de pression&nbsp;:</label></span>
      <span class="wwctrl">
        <select id="arboDiseasePressureScale" ng-options="key as value for (key, value) in i18n.PressureScale"
            ng-model="editedPestMaster.pressureScale" class="column-xlarge">
          <option value=""></option>
        </select>
      </span>
    </div>

    <div class="horizontal-separator">Résultats obtenus, niveau de maîtrise finale</div>

    <div class="wwgrp">
        <span class="wwlbl wide-label"><label for="arboDiseasePressureEvolution"><span class="required">*&nbsp;</span>Échelle de maîtrise&nbsp;:</label></span>
        <span class="wwctrl">
          <select id="arboDiseasePressureEvolution" ng-options="key as value for (key, value) in i18n['MasterScale']"
              ng-model="editedPestMaster.masterScale" class="column-xlarge" ng-required="editedPestMaster">
            <option value=""></option>
          </select>
        </span>
    </div>
    <div class="wwgrp">
      <span class="wwlbl wide-label"><label for="arboDiseasePercentAffectedPlots">% parcelles touchées&nbsp;:</label></span>
      <span class="wwctrl">
        <select id="arboDiseasePercentAffectedPlots" ng-options="key as value for (key, value) in i18n.DamageLevel"
            ng-model="editedPestMaster.percentAffectedPlots" class="column-xlarge">
          <option value=""></option>
        </select>
      </span>
    </div>
    <div class="wwgrp">
      <span class="wwlbl wide-label"><label for="arboDiseasePercentAffectedTrees">% arbres touchés&nbsp;:</label></span>
      <span class="wwctrl">
        <select id="arboDiseasePercentAffectedTrees" ng-options="key as value for (key, value) in i18n.DamageLevel"
            ng-model="editedPestMaster.percentAffectedTrees" class="column-xlarge">
          <option value=""></option>
        </select>
      </span>
    </div>
    <div class="wwgrp">
      <span class="wwlbl wide-label"><label for="arboDiseasePercentDamageFruits">% dommages sur fruits&nbsp;:</label></span>
      <span class="wwctrl">
        <select id="arboDiseasePercentDamageFruits" ng-options="key as value for (key, value) in i18n.DamageLevel"
            ng-model="editedPestMaster.percentDamageFruits" class="column-xlarge">
          <option value=""></option>
        </select>
      </span>
    </div>
    <div class="wwgrp">
      <span class="wwlbl wide-label"><label for="arboDiseasePercentDamageLeafs">% dommages sur pousses ou feuilles&nbsp;:</label></span>
      <span class="wwctrl">
        <select id="arboDiseasePercentDamageLeafs" ng-options="key as value for (key, value) in i18n.DamageLevel"
            ng-model="editedPestMaster.percentDamageLeafs" class="column-xlarge">
          <option value=""></option>
        </select>
      </span>
    </div>
    <div class="wwgrp">
        <span class="wwlbl wide-label"><label for="arboDiseaseNextYearInoculum">Inoculum pour les années suivantes&nbsp;:</label></span>
        <span class="wwctrl">
          <select id="arboDiseaseNextYearInoculum" ng-options="key as value for (key, value) in i18n.InoculumLevel"
              ng-model="editedPestMaster.nextYearInoculum" class="column-xlarge">
            <option value=""></option>
          </select>
        </span>
    </div>
    <div class="wwgrp">
      <span class="wwlbl wide-label"><label for="arboDiseaseQualifier"><span class="required">*&nbsp;</span>Qualification du niveau de maîtrise&nbsp;:</label></span>
      <span class="wwctrl">
        <select id="arboDiseaseQualifier" ng-options="key as value for (key, value) in (isDephyExpe ? i18n.GlobalMasterLevelQualifier : i18n['GlobalMasterLevelQualifier#ArboNotExpe'])"
            ng-model="editedPestMaster.qualifier" class="column-xlarge" ng-required="editedPestMaster">
          <option value=""></option>
        </select>
      </span>
    </div>
    <div class="wwgrp">
      <span class="wwlbl wide-label"><label for="arboDiseaseResultFarmerComment">Expression de l’agriculteur&nbsp;:</label></span>
      <span class="wwctrl">
        <textarea id="arboDiseaseResultFarmerComment" ng-model="editedPestMaster.resultFarmerComment" class="column-xlarge" column="20" rows="5"></textarea>
      </span>
    </div>
    <div class="wwgrp">
        <span class="wwlbl wide-label"><label for="arboDiseaseAdviserComments">Commentaire du conseiller/de l'expérimentateur&nbsp;:</label></span>
        <span class="wwctrl">
          <textarea id="arboDiseaseAdviserComments" ng-model="editedPestMaster.adviserComments" class="column-xlarge" column="20" rows="5"></textarea>
        </span>
    </div>
  </jqdialog>
</div>
</div>
</div>
