/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.rest.networks;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.Network;
import fr.inra.agrosyst.api.services.network.NetworkFilter;
import fr.inra.agrosyst.api.services.network.NetworkService;
import fr.inra.agrosyst.web.rest.CustomInject;
import fr.inra.agrosyst.web.rest.Secured;
import fr.inra.agrosyst.web.rest.common.PaginationResultDto;
import fr.inra.agrosyst.web.rest.networks.NetworkDto;
import fr.inra.agrosyst.web.rest.networks.NetworkRequestFilter;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.CookieParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.util.pagination.PaginationResult;

@Secured
@Path(value="/networks")
public class NetworksResource {
    @CustomInject
    private NetworkService networkService;

    private NetworkFilter buildFilter(NavigationContext navigationContext, String name, String manager, Boolean active, Set<String> selectedIds, Integer pageNumber, Integer pageSize) {
        NetworkFilter filter = new NetworkFilter();
        filter.setNavigationContext(navigationContext);
        filter.setNetworkName(name);
        filter.setNetworkManager(manager);
        filter.setActive(active);
        if (selectedIds != null && !selectedIds.isEmpty()) {
            filter.setSelectedIds(selectedIds);
        }
        if (pageNumber != null) {
            filter.setPage(pageNumber.intValue());
        }
        if (pageSize != null) {
            filter.setPageSize(pageSize.intValue());
        }
        return filter;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response readAll(@CookieParam(value="nav.context") Cookie jsonContext, NetworkRequestFilter requestFilter) throws JsonProcessingException {
        NavigationContext context = jsonContext != null ? (NavigationContext)new ObjectMapper().readValue(URLDecoder.decode(jsonContext.getValue(), StandardCharsets.UTF_8), NavigationContext.class) : new NavigationContext();
        NetworkFilter filter = this.buildFilter(context, requestFilter.getName(), requestFilter.getResponsable(), requestFilter.getActive(), requestFilter.getSelectedIds(), requestFilter.getPageNumber(), requestFilter.getPageSize());
        PaginationResult paginationResult = this.networkService.getFilteredNetworks(filter);
        List<NetworkDto> networks = paginationResult.getElements().stream().map(n -> {
            String managersAsStr = n.getManagers().stream().map(m -> m.getAgrosystUser().getFirstName() + " " + m.getAgrosystUser().getLastName()).collect(Collectors.joining(", "));
            return new NetworkDto(StringUtils.remove((String)n.getTopiaId(), (String)Network.class.getName()), n.getName(), managersAsStr, n.isActive());
        }).toList();
        Response response = Response.ok().entity((Object)new PaginationResultDto(networks, paginationResult.getCount(), paginationResult.getCurrentPage())).build();
        return response;
    }

    @GET
    @Path(value="/filtered-ids")
    @Produces(value={"application/json"})
    public Response readIds(@CookieParam(value="nav.context") Cookie jsonContext, NetworkRequestFilter requestFilter) throws JsonProcessingException {
        NavigationContext context = jsonContext != null ? (NavigationContext)new ObjectMapper().readValue(URLDecoder.decode(jsonContext.getValue(), StandardCharsets.UTF_8), NavigationContext.class) : new NavigationContext();
        NetworkFilter filter = this.buildFilter(context, requestFilter.getName(), requestFilter.getResponsable(), requestFilter.getActive(), null, null, null);
        Set ids = this.networkService.getFilteredNetworkIds(filter);
        Response response = Response.ok().entity((Object)ids).build();
        return response;
    }
}

