/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.rest;

import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.exceptions.SignatureVerificationException;
import com.auth0.jwt.exceptions.TokenExpiredException;
import fr.inra.agrosyst.api.services.users.AuthenticatedUser;
import fr.inra.agrosyst.web.AgrosystWebApplicationContext;
import fr.inra.agrosyst.web.AgrosystWebConfig;
import fr.inra.agrosyst.web.actions.security.JwtHelper;
import fr.inra.agrosyst.web.rest.Secured;
import java.io.IOException;
import java.util.Optional;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Secured
@Provider
@Priority(value=1000)
public class AgrosystRestAuthenticationFilter
implements ContainerRequestFilter {
    private static final Log LOGGER = LogFactory.getLog(AgrosystRestAuthenticationFilter.class);
    @Inject
    private ServletContext servletContext;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        Cookie cookie = (Cookie)requestContext.getCookies().get("X-Agrosyst-Token");
        Optional<String> jwtToken = Optional.ofNullable(cookie).map(Cookie::getValue);
        Optional authenticatedUser = this.validateToken(jwtToken);
        if (authenticatedUser.isEmpty()) {
            this.abortWithUnauthorized(requestContext);
        }
    }

    private Optional<AuthenticatedUser> validateToken(Optional<String> jwtToken) {
        AgrosystWebApplicationContext webApplicationContext = (AgrosystWebApplicationContext)this.servletContext.getAttribute(AgrosystWebApplicationContext.APPLICATION_CONTEXT_PARAMETER);
        AgrosystWebConfig webConfig = webApplicationContext.getWebConfig();
        JwtHelper jwtHelper = new JwtHelper(webConfig);
        try {
            return jwtToken.map(arg_0 -> ((JwtHelper)jwtHelper).verifyJwtToken(arg_0));
        }
        catch (TokenExpiredException tee) {
            LOGGER.warn((Object)("Token expir\u00e9 : " + tee.getMessage()));
        }
        catch (SignatureVerificationException sve) {
            LOGGER.warn((Object)("Signature du token invalide : " + sve.getMessage()));
        }
        catch (JWTDecodeException jde) {
            LOGGER.warn((Object)("Token invalide : " + jde.getMessage()));
        }
        return Optional.empty();
    }

    private void abortWithUnauthorized(ContainerRequestContext requestContext) {
        requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
    }
}

