/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.filters;

import com.opensymphony.sitemesh.webapp.SiteMeshFilter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SiteMeshMonitorFilter
extends SiteMeshFilter {
    private static final Log LOGGER = LogFactory.getLog(SiteMeshMonitorFilter.class);
    public static final String ACTION_MONITOR_TEXT = "Action %s %s took %d ms [%d]";

    public void doFilter(ServletRequest rq, ServletResponse rs, FilterChain chain) throws IOException, ServletException {
        long start = System.currentTimeMillis();
        super.doFilter(rq, rs, chain);
        if (LOGGER.isTraceEnabled()) {
            int status;
            String requested;
            HttpServletRequest httpServletRequest;
            long end;
            block3: {
                end = System.currentTimeMillis();
                httpServletRequest = (HttpServletRequest)rq;
                HttpServletResponse httpServletResponse = (HttpServletResponse)rs;
                requested = httpServletRequest.getRequestURI().substring(httpServletRequest.getContextPath().length());
                status = -1;
                try {
                    Method getStatus = httpServletResponse.getClass().getMethod("getStatus", new Class[0]);
                    status = (Integer)getStatus.invoke((Object)httpServletResponse, new Object[0]);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    if (!LOGGER.isErrorEnabled()) break block3;
                    LOGGER.error((Object)e);
                }
            }
            LOGGER.trace((Object)String.format(ACTION_MONITOR_TEXT, httpServletRequest.getMethod(), requested, end - start, status));
        }
    }
}

