/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.security;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import fr.inra.agrosyst.api.Language;
import fr.inra.agrosyst.api.entities.security.RoleType;
import fr.inra.agrosyst.api.services.users.AuthenticatedUser;
import fr.inra.agrosyst.api.services.users.ImmutableAuthenticatedUser;
import fr.inra.agrosyst.web.AgrosystWebConfig;
import java.time.Duration;
import java.time.Instant;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class JwtHelper {
    private static final int CACHE_EXPIRATION_MINUTES = 5;
    private static final Cache<String, AuthenticatedUser> CACHE = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build();
    protected final String jwtSecret;
    protected final int timeoutSeconds;

    public JwtHelper(AgrosystWebConfig config) {
        this(config.getJwtSecret(), config.getHttpSessionTimeout());
    }

    public JwtHelper(String jwtSecret, int timeoutSeconds) {
        Preconditions.checkArgument((jwtSecret != null ? 1 : 0) != 0, (Object)"La config est obligatoire");
        this.jwtSecret = jwtSecret;
        this.timeoutSeconds = timeoutSeconds;
    }

    private Algorithm getJwtSecretAlgorithm() {
        Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)this.jwtSecret), (Object)"La cl\u00e9 JWT est manquante");
        Algorithm result = Algorithm.HMAC512((String)this.jwtSecret);
        return result;
    }

    public String createJwtToken(AuthenticatedUser userDto) {
        Date now = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, this.timeoutSeconds);
        Date expiresAt = calendar.getTime();
        Algorithm algorithmHS = this.getJwtSecretAlgorithm();
        JWTCreator.Builder builder = JWT.create().withIssuer("agrosyst-web").withSubject(userDto.getTopiaId()).withIssuedAt(now).withExpiresAt(expiresAt).withJWTId(UUID.randomUUID().toString()).withClaim("firstName", userDto.getFirstName()).withClaim("lastName", userDto.getLastName()).withClaim("email", userDto.getEmail()).withClaim("userLang", userDto.getLanguage().getTrigram()).withArrayClaim("roles", (String[])userDto.getRoles().stream().map(Enum::name).toArray(String[]::new)).withClaim("acceptedCharter", Boolean.valueOf(userDto.isAcceptedCharter())).withClaim("sid", userDto.getSid());
        userDto.getBanner().ifPresent(v -> builder.withClaim("banner", v));
        userDto.getItEmail().ifPresent(v -> builder.withClaim("itEmail", v));
        String jwtToken = builder.sign(algorithmHS);
        return jwtToken;
    }

    public AuthenticatedUser verifyJwtToken(String jwtToken) {
        AuthenticatedUser result = (AuthenticatedUser)CACHE.getIfPresent((Object)jwtToken);
        if (result == null) {
            Algorithm algorithmHS = this.getJwtSecretAlgorithm();
            DecodedJWT verify = JWT.require((Algorithm)algorithmHS).withIssuer("agrosyst-web").build().verify(jwtToken);
            List roles = verify.getClaim("roles").asList(String.class).stream().map(RoleType::valueOf).collect(Collectors.toList());
            Language language = verify.getClaim("userLang").isNull() ? Language.FRENCH : Language.fromTrigram((String)verify.getClaim("userLang").asString());
            result = ImmutableAuthenticatedUser.builder().topiaId(verify.getSubject()).firstName(verify.getClaim("firstName").asString()).lastName(verify.getClaim("lastName").asString()).email(verify.getClaim("email").asString()).roles(roles).isAcceptedCharter(verify.getClaim("acceptedCharter").asBoolean().booleanValue()).language(language).banner(Optional.ofNullable(verify.getClaim("banner").asString())).itEmail(Optional.ofNullable(verify.getClaim("itEmail").asString())).sid(verify.getClaim("sid").asString()).build();
            Date expiresAt = verify.getExpiresAt();
            Duration expiresIn = Duration.between(Instant.now(), expiresAt.toInstant());
            long expiresInMinutes = expiresIn.toMinutes();
            if (expiresInMinutes > 5L) {
                CACHE.put((Object)jwtToken, (Object)result);
            }
        }
        return result;
    }

    public Date getTokenIssuedAt(String jwtToken) {
        Algorithm algorithmHS = this.getJwtSecretAlgorithm();
        DecodedJWT verify = JWT.require((Algorithm)algorithmHS).withIssuer("agrosyst-web").build().verify(jwtToken);
        Date result = verify.getIssuedAt();
        return result;
    }
}

