/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.referential;

import fr.inra.agrosyst.api.exceptions.AgrosystTechnicalException;
import fr.inra.agrosyst.api.services.referential.ReferentialService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

public class CiblesGroupesCiblesMaaReferentialDownload
extends AbstractAgrosystAction {
    private static final Log LOGGER = LogFactory.getLog(CiblesGroupesCiblesMaaReferentialDownload.class);
    private static final long serialVersionUID = 2516653646753715542L;
    protected transient ReferentialService referentialService;

    public void setReferentialService(ReferentialService referentialService) {
        this.referentialService = referentialService;
    }

    @Action(results={@Result(type="stream", params={"contentType", "text/csv", "inputName", "inputStream", "contentDisposition", "attachment; filename=\"${filename}\"; filename*=UTF-8''${urifilename}"})})
    public String execute() throws Exception {
        return "success";
    }

    public InputStream getInputStream() {
        InputStream inputStream;
        try {
            inputStream = this.referentialService.exportCiblesGroupesCiblesMaaCSV();
        }
        catch (Exception ex) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Can't generate csv", (Throwable)ex);
            }
            throw new AgrosystTechnicalException("Can't create input stream", (Throwable)ex);
        }
        return inputStream;
    }

    public String getUrifilename() throws UnsupportedEncodingException {
        return URLEncoder.encode(this.getFilename(), StandardCharsets.UTF_8).replace("+", "%20");
    }

    public String getFilename() {
        Object filename = "Cibles r\u00e9f\u00e9renc\u00e9s dans Agrosyst au ";
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd-MM-yyyy");
        String formattedString = LocalDate.now().format(formatter);
        filename = (String)filename + formattedString + ".csv";
        return filename;
    }
}

