/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.practiced;

import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.api.services.practiced.ReferenceDoseDTO;
import fr.inra.agrosyst.api.services.referential.ReferentialService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;
import java.util.HashMap;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoadReferenceDoseJson
extends AbstractJsonAction {
    private static final Log LOGGER = LogFactory.getLog(LoadReferenceDoseJson.class);
    private static final long serialVersionUID = -3566232755453160692L;
    protected transient ReferentialService referentialService;
    protected transient DomainService domainService;
    protected transient String refInputId;
    protected transient Set<String> speciesIds;
    protected Integer campaign;
    protected transient Set<String> targetIds;
    protected transient Set<String> groupesCibles;

    public void setSpeciesIds(String speciesIds) {
        this.speciesIds = (Set)this.getGson().fromJson(speciesIds, new /* Unavailable Anonymous Inner Class!! */.getType());
    }

    public void setTargetIds(String targetIds) {
        this.targetIds = (Set)this.getGson().fromJson(targetIds, new /* Unavailable Anonymous Inner Class!! */.getType());
    }

    public void setGroupesCibles(String groupesCibles) {
        this.groupesCibles = (Set)this.getGson().fromJson(groupesCibles, new /* Unavailable Anonymous Inner Class!! */.getType());
    }

    public String execute() throws Exception {
        try {
            ReferenceDoseDTO referenceDoseIFTLegacy = this.referentialService.computeLocalizedReferenceDoseForIFTLegacy(this.refInputId, this.speciesIds);
            ReferenceDoseDTO referenceDoseIFTCibleNonMillesime = this.referentialService.computeLocalizedReferenceDoseForIFCCibleNonMillesime(this.refInputId, this.speciesIds, this.targetIds, this.groupesCibles);
            ReferenceDoseDTO referenceDoseIFTCibleMillesime = this.referentialService.computeReferenceDoseForIFCCibleMillesime(this.refInputId, this.speciesIds, this.targetIds, this.groupesCibles, this.campaign);
            HashMap<String, ReferenceDoseDTO> result = new HashMap<String, ReferenceDoseDTO>();
            result.put("IFT_Ancienne", referenceDoseIFTLegacy);
            result.put("IFT_Cible_NonMillesime", referenceDoseIFTCibleNonMillesime);
            result.put("IFT_Cible_Millesime", referenceDoseIFTCibleMillesime);
            this.jsonData = result;
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)String.format("Failed to load acta Product for refInputId '%s' and refEspeceIds '%s':", this.refInputId, this.speciesIds), (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    @Generated
    public void setReferentialService(ReferentialService referentialService) {
        this.referentialService = referentialService;
    }

    @Generated
    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }

    @Generated
    public void setRefInputId(String refInputId) {
        this.refInputId = refInputId;
    }

    @Generated
    public void setCampaign(Integer campaign) {
        this.campaign = campaign;
    }
}

