/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.performances.api;

import fr.inra.agrosyst.api.services.performance.PerformanceDto;
import fr.inra.agrosyst.api.services.performance.PerformanceFilter;
import fr.inra.agrosyst.api.services.performance.PerformanceService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PerformancesListJson
extends AbstractJsonAction {
    private static final Log LOGGER = LogFactory.getLog(PerformancesListJson.class);
    private static final long serialVersionUID = -1180723133330637375L;
    protected transient PerformanceService performanceService;
    protected transient String filter;
    protected transient boolean practiced;

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public void setPerformanceService(PerformanceService performanceService) {
        this.performanceService = performanceService;
    }

    public void setPracticed(boolean practiced) {
        this.practiced = practiced;
    }

    public String execute() {
        try {
            PerformanceFilter performanceFilter = (PerformanceFilter)this.getGson().fromJson(this.filter, PerformanceFilter.class);
            performanceFilter.setPracticed(this.practiced);
            this.writeListNbElementByPage(PerformanceDto.class, String.valueOf(this.practiced), performanceFilter.getPageSize());
            performanceFilter.setActive(Boolean.TRUE);
            this.jsonData = this.performanceService.getFilteredPerformances(performanceFilter, 10);
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Failed to load performances", (Throwable)e);
            }
            return "error";
        }
        return "success";
    }
}

