/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.managementmodes;

import com.google.common.collect.Lists;
import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.BioAgressorType;
import fr.inra.agrosyst.api.entities.GrowingPlan;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.Sector;
import fr.inra.agrosyst.api.entities.managementmode.ManagementModeCategory;
import fr.inra.agrosyst.api.entities.managementmode.SectionType;
import fr.inra.agrosyst.api.entities.managementmode.StrategyType;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemService;
import fr.inra.agrosyst.api.services.managementmode.ManagementModeService;
import fr.inra.agrosyst.api.services.referential.ReferentialService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;

public class ManagementModesEditJson
extends AbstractJsonAction {
    private static final Log LOGGER = LogFactory.getLog(ManagementModesEditJson.class);
    private static final long serialVersionUID = 3260095596557765111L;
    protected transient GrowingSystemService growingSystemService;
    protected transient ManagementModeService managementModeService;
    protected transient ReferentialService referentialService;
    protected String growingSystemTopiaId;
    protected BioAgressorType bioAgressorType;
    protected ManagementModeCategory category;
    protected Sector sector;
    protected SectionType sectionType;
    protected StrategyType strategyType;
    protected String term;
    protected String growingSystemIds;

    public void setManagementModeService(ManagementModeService managementModeService) {
        this.managementModeService = managementModeService;
    }

    public void setReferentialService(ReferentialService referentialService) {
        this.referentialService = referentialService;
    }

    public void setGrowingSystemService(GrowingSystemService growingSystemService) {
        this.growingSystemService = growingSystemService;
    }

    public void setBioAgressorType(BioAgressorType bioAgressorType) {
        this.bioAgressorType = bioAgressorType;
    }

    @Action(value="management-modes-edit-growing-system-data-json")
    public String listCroppingPlanEntries() {
        try {
            GrowingSystem growingSystem = this.growingSystemService.getGrowingSystem(this.growingSystemTopiaId);
            GrowingPlan growingPlan = growingSystem.getGrowingPlan();
            String domainTopiaId = growingPlan.getDomain().getTopiaId();
            List croppingPlanEntries = this.managementModeService.getGrowingSystemCroppingPlanEntries(this.growingSystemTopiaId);
            Collection decisionRules = this.managementModeService.getGrowingSystemDecisionRules(this.growingSystemTopiaId);
            List availableManagementModeCategories = this.managementModeService.getAvailableManagementModeCategories(this.growingSystemTopiaId);
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("croppingPlanEntries", croppingPlanEntries);
            result.put("decisionRules", decisionRules);
            result.put("managementModeCategories", availableManagementModeCategories);
            result.put("domainTopiaId", domainTopiaId);
            result.put("typeDEPHY", growingPlan.getType());
            this.jsonData = result;
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)("management-modes-edit-growing-system-data-json failed for growingSystemId '" + this.growingSystemTopiaId + "' "), (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    @Action(value="available-growing-system-for-duplication-json")
    public String availableGrowingSystemsForDuplication() {
        try {
            NavigationContext navigationContext = this.getNavigationContext();
            this.jsonData = this.managementModeService.getAvailableGsForDuplication(this.growingSystemTopiaId, navigationContext);
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)("available-growing-system-for-duplication-json failed for growingSystemTopiaId '" + this.growingSystemTopiaId + "' "), (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    @Action(value="management-modes-edit-load-ref-strategy-levers-json")
    public String loadRefStrategyLevers() {
        try {
            this.jsonData = this.managementModeService.loadRefStrategyLevers(this.sector, this.growingSystemTopiaId, this.sectionType, this.strategyType);
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)String.format("management-modes-edit-load-ref-strategy-levers-json failed for sector '%s', growingSystemId '%s', sectionType '%s', strategyType '%s", this.sector, this.growingSystemTopiaId, this.sectionType, this.strategyType), (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    @Action(value="management-modes-edit-load-ref-strategy-levers-for-term-json")
    public String loadRefStrategyLeversForTerm() {
        try {
            this.jsonData = this.managementModeService.loadRefStrategyLeversForTerm(this.sector, this.growingSystemTopiaId, this.sectionType, this.strategyType, this.term);
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)String.format("management-modes-edit-load-ref-strategy-levers-json failed for sector '%s', growingSystemId '%s', sectionType '%s', strategyType '%s", this.sector, this.growingSystemTopiaId, this.sectionType, this.strategyType), (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    @Action(value="management-modes-edit-load-writable-management-modes-For-growing-system-ids-json")
    public String loadWritableManagementModesForGrowingSystemIds() {
        try {
            ArrayList growingSystemIds0 = Lists.newArrayList((Iterable)this.getGrowingSystemIds(this.growingSystemIds));
            this.jsonData = this.managementModeService.loadWritableManagementModesForGrowingSystemIds((List)growingSystemIds0);
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)String.format("management-modes-edit-load-writable-management-modes-For-growing-system-ids-json failed for growingSystemIds '%s'", this.growingSystemIds), (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    public void setGrowingSystemTopiaId(String growingSystemTopiaId) {
        this.growingSystemTopiaId = growingSystemTopiaId;
    }

    public void setCategory(ManagementModeCategory category) {
        this.category = category;
    }

    public void setSector(Sector sector) {
        this.sector = sector;
    }

    public void setSectionType(SectionType sectionType) {
        this.sectionType = sectionType;
    }

    public void setStrategyType(StrategyType strategyType) {
        this.strategyType = strategyType;
    }

    public void setGrowingSystemIds(String growingSystemIds) {
        this.growingSystemIds = growingSystemIds;
    }

    private Set<String> getGrowingSystemIds(String growingSystemIds) {
        return this.getSelectedGrowingSystemIds(growingSystemIds);
    }

    public void setTerm(String term) {
        this.term = term;
    }
}

