/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.growingsystems;

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.Sector;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemFilter;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;
import lombok.Generated;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;

public class GrowingSystemEditJson
extends AbstractJsonAction {
    private static final long serialVersionUID = 1L;
    private static final Log LOGGER = LogFactory.getLog(GrowingSystemEditJson.class);
    protected transient GrowingSystemService growingSystemService;
    protected String practicedSystemId;
    protected Sector sector;
    protected String term;

    @Action(value="available-growing-system-for-duplication-json")
    public String availableGrowingSystemsForDuplication() {
        try {
            NavigationContext navigationContext = this.getNavigationContext();
            this.jsonData = this.growingSystemService.getAvailableGsForDuplication(this.practicedSystemId, navigationContext);
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)String.format("Failed to load Growing Systems list for duplication for practicedSystemId '%s':", this.practicedSystemId), (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    @Action(value="load-marketing-destination-objectives-for-sector-json")
    public String loadMarketingDestinationObjectivesForSector() {
        try {
            this.jsonData = this.growingSystemService.loadMarketingDestinationObjectivesForSector(this.sector);
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)String.format("Failed to load Marketing Destination Objectives For Sector '%s':", this.sector.name()), (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    @Action(value="load-growing-system-complete-json")
    public String loadGrowingSystemComplete() {
        try {
            GrowingSystemFilter growingSystemFilter = new GrowingSystemFilter();
            growingSystemFilter.setNavigationContext(this.getNavigationContext());
            growingSystemFilter.setPageSize(50);
            growingSystemFilter.setActive(Boolean.TRUE);
            growingSystemFilter.setGrowingSystemName(this.term);
            this.jsonData = this.growingSystemService.getFilteredGrowingSystemsDto(growingSystemFilter).getElements();
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)String.format("Failed to load Marketing Destination Objectives For Sector '%s':", this.sector.name()), (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    @Generated
    public void setGrowingSystemService(GrowingSystemService growingSystemService) {
        this.growingSystemService = growingSystemService;
    }

    @Generated
    public void setPracticedSystemId(String practicedSystemId) {
        this.practicedSystemId = practicedSystemId;
    }

    @Generated
    public void setSector(Sector sector) {
        this.sector = sector;
    }

    @Generated
    public void setTerm(String term) {
        this.term = term;
    }
}

