/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.domains;

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.services.domain.DomainFilter;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DomainsSearchJson
extends AbstractJsonAction {
    private static final Log LOGGER = LogFactory.getLog(DomainsSearchJson.class);
    private static final long serialVersionUID = -8998970986135363653L;
    protected transient DomainService domainService;
    protected int pageIndex = 0;
    protected int pageSize = 50;
    protected String term;

    public String execute() {
        try {
            NavigationContext navigationContext = this.getNavigationContext();
            DomainFilter domainFilter = new DomainFilter();
            domainFilter.setNavigationContext(navigationContext);
            domainFilter.setActive(Boolean.valueOf(true));
            if (StringUtils.isNotEmpty((CharSequence)this.term)) {
                domainFilter.setDomainName(this.term);
            }
            domainFilter.setPage(this.pageIndex);
            domainFilter.setPageSize(this.pageSize);
            this.jsonData = this.domainService.getFilteredDomainsDto(domainFilter);
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Failed to load domains list", (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    @Generated
    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }

    @Generated
    public void setPageIndex(int pageIndex) {
        this.pageIndex = pageIndex;
    }

    @Generated
    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    @Generated
    public void setTerm(String term) {
        this.term = term;
    }
}

