/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.domains;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import fr.inra.agrosyst.api.entities.AgrosystInterventionType;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.DomainImpl;
import fr.inra.agrosyst.api.entities.DomainType;
import fr.inra.agrosyst.api.entities.Entities;
import fr.inra.agrosyst.api.entities.Equipment;
import fr.inra.agrosyst.api.entities.GeoPoint;
import fr.inra.agrosyst.api.entities.Ground;
import fr.inra.agrosyst.api.entities.LivestockUnit;
import fr.inra.agrosyst.api.entities.MaterielTransportUnit;
import fr.inra.agrosyst.api.entities.MaterielWorkRateUnit;
import fr.inra.agrosyst.api.entities.PriceUnit;
import fr.inra.agrosyst.api.entities.ToolsCoupling;
import fr.inra.agrosyst.api.entities.WeatherStation;
import fr.inra.agrosyst.api.entities.Zoning;
import fr.inra.agrosyst.api.entities.referential.RefInterventionAgrosystTravailEDI;
import fr.inra.agrosyst.api.entities.referential.RefLegalStatus;
import fr.inra.agrosyst.api.entities.referential.RefLocation;
import fr.inra.agrosyst.api.entities.referential.RefMaterielAutomoteur;
import fr.inra.agrosyst.api.entities.referential.RefMaterielIrrigation;
import fr.inra.agrosyst.api.entities.referential.RefMaterielOutil;
import fr.inra.agrosyst.api.entities.referential.RefStationMeteo;
import fr.inra.agrosyst.api.services.action.HarvestingPriceDto;
import fr.inra.agrosyst.api.services.common.PricesService;
import fr.inra.agrosyst.api.services.common.UsageList;
import fr.inra.agrosyst.api.services.domain.CroppingPlanEntryDto;
import fr.inra.agrosyst.api.services.domain.CroppingPlanSpeciesDto;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.api.services.domain.inputStock.DomainInputDto;
import fr.inra.agrosyst.api.services.domain.inputStock.DomainInputStockUnitService;
import fr.inra.agrosyst.api.services.domain.inputStock.DomainMineralProductInputDto;
import fr.inra.agrosyst.api.services.domain.inputStock.DomainOrganicProductInputDto;
import fr.inra.agrosyst.api.services.domain.inputStock.DomainOtherProductInputDto;
import fr.inra.agrosyst.api.services.plot.PlotService;
import fr.inra.agrosyst.api.services.referential.ReferentialService;
import fr.inra.agrosyst.api.utils.DataValidator;
import fr.inra.agrosyst.services.common.CommonService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;
import fr.inra.agrosyst.web.actions.domains.WeatherStationDto;
import fr.inra.agrosyst.web.actions.domains.WeatherStations;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.Preparable;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.nuiton.topia.persistence.TopiaEntity;

public class DomainsEdit
extends AbstractAgrosystAction
implements Preparable {
    protected static final Predicate<CroppingPlanSpeciesDto> HAS_NO_SPECIES = speciesDto -> speciesDto.getSpeciesId() == null;
    private static final Log LOGGER = LogFactory.getLog(DomainsEdit.class);
    private static final long serialVersionUID = 1686182182420156247L;
    protected transient ReferentialService referentialService;
    protected transient DomainService domainService;
    protected transient PlotService plotService;
    protected transient PricesService pricesService;
    protected transient DomainInputStockUnitService domainInputStockUnitService;
    protected Integer campaign;
    protected Domain domain;
    protected String speciesToArea = "";
    protected LinkedHashMap<Integer, String> relatedDomains = new LinkedHashMap();
    protected List<GeoPoint> geoPoints;
    protected String geoPointsJson;
    protected String domainTopiaId;
    protected String commune;
    protected String legalStatusId;
    protected List<RefLegalStatus> allRefLegalStatus;
    protected RefLocation location;
    protected String departement;
    protected String petiteRegionAgricole;
    protected String petiteRegionAgricoleName;
    protected String countryTopiaId;
    protected String locationTopiaId;
    protected List<Equipment> equipments;
    protected String equipmentsJson;
    protected List<ToolsCoupling> toolsCouplings;
    protected String toolsCouplingsJson;
    protected Map<Integer, String> solArvalisRegions;
    protected List<Ground> grounds;
    protected String groundsJson;
    protected List<CroppingPlanEntryDto> croppingPlans;
    protected String croppingPlansJson;
    protected UsageList<CroppingPlanEntryDto> croppingPlansUsageList;
    protected Map<String, Boolean> croppingPlanSpeciesUsageMap;
    protected Integer otex18;
    protected Integer otex70;
    protected Map<Integer, String> otex18s;
    protected Map<Integer, String> otex70s = new HashMap();
    protected Collection<WeatherStationDto> weatherStations = new ArrayList();
    protected String weatherStationsJson;
    protected Map<String, String> allRefStationMeteoIdsAndNames;
    protected List<RefInterventionAgrosystTravailEDI> agrosystActionsFullList;
    protected boolean canEditPlots;
    protected List<LivestockUnit> livestockUnits;
    protected String livestockUnitsJson;
    protected List<DomainInputDto> inputStockUnits;
    protected String inputStockUnitsJson;
    protected String domainSiret;
    protected int plotExportAsyncThreshold;
    protected Map<String, String> countries;
    protected List<HarvestingPriceDto> harvestingPriceDtos;
    protected String allRegularPricesJson;

    public Domain getDomain() {
        return Objects.requireNonNullElseGet(this.domain, DomainImpl::new);
    }

    public void prepare() {
        if (StringUtils.isEmpty((CharSequence)this.domainTopiaId)) {
            this.domain = this.domainService.newDomain();
            if (this.campaign != null) {
                this.domain.setCampaign(this.campaign.intValue());
            }
        } else {
            this.authorizationService.checkDomainReadable(this.domainTopiaId);
            boolean bl = this.readOnly = !this.authorizationService.isDomainWritable(this.domainTopiaId);
            if (this.readOnly) {
                this.notificationSupport.domainNotWritable();
            }
            this.domain = this.domainService.getDomain(this.domainTopiaId);
            this.activated = this.domain.isActive();
            this.speciesToArea = this.sanitizeSpeciesToAreaJson(this.domain.getSpeciesToArea());
            if (StringUtils.isBlank((CharSequence)this.locationTopiaId)) {
                this.locationTopiaId = this.domain.getLocation().getTopiaId();
            }
        }
        if (!StringUtils.isBlank((CharSequence)this.locationTopiaId)) {
            this.location = this.referentialService.getRefLocation(this.locationTopiaId);
            this.domain.setLocation(this.location);
            this.departement = this.location.getDepartement();
            this.petiteRegionAgricole = this.location.getPetiteRegionAgricoleCode();
            this.petiteRegionAgricoleName = this.location.getPetiteRegionAgricoleNom();
            this.countryTopiaId = this.location.getRefCountry().getTopiaId();
        } else {
            this.countryTopiaId = this.getDefaultCountryTopiaId();
        }
        this.campaign = this.domain.getCampaign() == 0 ? null : Integer.valueOf(this.domain.getCampaign());
        this.plotExportAsyncThreshold = this.config.getPlotsExportAsyncThreshold();
        if (this.domainInputStockUnitService.hasUnauthorizedUsageUnit(this.domain.getTopiaId())) {
            this.notificationSupport.unauthorizedSeedPlantUnit();
        }
    }

    public void validate() {
        this.validateActiveDomain();
        this.validDomainMainCharacteristics();
        this.validWeatherStations();
        this.validEquipments();
        this.validToolsCouplings();
        this.validGeoPoints();
        this.validLiveStock();
        this.validDomainInputStockUnits();
        this.validGrounds();
        this.validCroppingPlans();
        this.validHarvestingPrices();
        if (this.hasErrors()) {
            if (LOGGER.isErrorEnabled()) {
                String domainId = this.getLogEntityId((TopiaEntity)this.domain);
                LOGGER.error((Object)String.format("For user email:" + this.getAuthenticatedUser().getEmail() + ":validate, action errors : domain:'%s' -> %s", domainId, this.getActionErrors().toString()));
                LOGGER.error((Object)String.format("For user email:" + this.getAuthenticatedUser().getEmail() + ":validate, fields errors : domain:'%s' -> %s", domainId, this.getFieldErrors().toString()));
            }
            this.initForInput();
        }
    }

    protected void validateActiveDomain() {
        if (!this.domain.isActive()) {
            this.addActionError(this.getText("domain-validation-inactive"));
        }
    }

    protected void initForInput() {
        this.allRefLegalStatus = this.referentialService.getAllRefActiveLegalStatus();
        this.allRefStationMeteoIdsAndNames = this.referentialService.getAllRefStationMeteoMap();
        this.solArvalisRegions = this.referentialService.getSolArvalisRegions();
        this.otex18s = this.referentialService.getAllActiveOtex18Code();
        if (this.domain.getOtex18() != null) {
            this.otex70s = this.referentialService.getAllActiveCodeOtex70ByOtex18code(Integer.valueOf(this.domain.getOtex18().getCode_OTEX_18_postes()));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.domainTopiaId)) {
            this.relatedDomains = this.domainService.getRelatedDomains(this.domain.getCode());
            this.canEditPlots = this.authorizationService.areDomainPlotsEditable(this.domainTopiaId);
        } else {
            this.canEditPlots = true;
        }
    }

    @Action(value="domains-edit-input")
    public String input() {
        this.initForInput();
        if (StringUtils.isNotEmpty((CharSequence)this.domainTopiaId)) {
            this.geoPoints = this.domainService.getGeoPoints(this.domainTopiaId);
            this.grounds = this.domainService.getGrounds(this.domainTopiaId);
            this.weatherStations = this.getWeatherStations(this.domain);
        } else {
            this.geoPoints = Collections.emptyList();
            this.grounds = Collections.emptyList();
        }
        return "input";
    }

    protected Collection<WeatherStationDto> getWeatherStations(Domain domain) {
        Collection weatherStations = domain.getWeatherStations();
        String defaultWeatherStationId = null;
        if (domain.getDefaultWeatherStation() != null) {
            defaultWeatherStationId = domain.getDefaultWeatherStation().getTopiaId();
        }
        return Collections2.transform((Collection)weatherStations, (Function)WeatherStations.getFunctionWeatherStationToDto(defaultWeatherStationId));
    }

    protected void validDomainMainCharacteristics() {
        Double areaAroundHQ;
        Double furthestPlotDistance;
        Integer nbPlot;
        Double nonSeasonalWorkForce;
        Double seasonalWorkForce;
        Double temporaryEmployeesWorkForce;
        Double permanentEmployeesWorkForce;
        Double volunteerWorkForce;
        Double cropsWorkForce;
        Double otherWorkForce;
        Double operatorWorkForce;
        Integer partnersNumber;
        if (this.campaign == null || this.campaign == 0) {
            this.addFieldError("campaign", this.getText(this.getText("common.filedValue.required")));
            this.addActionError(this.getText("domain-validation-noCampaign"));
        } else if (!CommonService.getInstance().areCampaignsValids(Integer.toString(this.campaign))) {
            this.addFieldError("campaign", String.format(this.getText("domain-validation-invalidCampaign"), this.campaign));
            this.addActionError(String.format(this.getText("domain-validation-invalidCampaign"), this.campaign));
        }
        if (StringUtils.isBlank((CharSequence)this.domain.getName())) {
            this.addFieldError("domain.name", this.getText(this.getText("common.filedValue.required")));
            this.addActionError(this.getText("domain-validation-requiredName"));
        }
        if (StringUtils.isBlank((CharSequence)this.domain.getMainContact())) {
            this.addFieldError("domain.mainContact", this.getText(this.getText("common.filedValue.required")));
            this.addActionError(this.getText("domain-validation-requiredMainContact"));
        }
        if (StringUtils.isBlank((CharSequence)this.locationTopiaId)) {
            this.addFieldError("commune", this.getText(this.getText("common.filedValue.required")));
            this.addActionError(this.getText("domain-validation-requiredLocation"));
        }
        if (this.domain.getType() == null) {
            this.domain.setType(DomainType.DOMAINE_EXPERIMENTAL);
            this.addFieldError("domain.type", this.getText(this.getText("common.filedValue.required")));
            this.addActionError(this.getText("domain-validation-requiredType"));
        }
        if (StringUtils.isNotBlank((CharSequence)this.domainSiret) && !DataValidator.isSiretValid((String)this.domainSiret)) {
            this.addActionError(this.getText("domain-validation-invalidSiret"));
        }
        Double meadowArea = this.domain.getMeadowArea();
        double sum1 = Optional.ofNullable(this.domain.getMeadowAlwaysWithGrassArea()).orElse(0.0) + Optional.ofNullable(this.domain.getMeadowOtherArea()).orElse(0.0);
        double sum2 = Optional.ofNullable(this.domain.getMeadowOnlyMowedArea()).orElse(0.0) + Optional.ofNullable(this.domain.getMeadowOnlyPasturedArea()).orElse(0.0) + Optional.ofNullable(this.domain.getMeadowPasturedAndMowedArea()).orElse(0.0);
        if (meadowArea != null && (sum1 > 0.0 && meadowArea != sum1 || sum2 > 0.0 && meadowArea != sum2)) {
            String errorMessage = this.getText("domain-validation-invalidMeaowArea");
            this.addFieldError("domain.meadowArea", errorMessage);
            this.addActionError(errorMessage);
        }
        if ((partnersNumber = this.domain.getPartnersNumber()) != null && partnersNumber < 0) {
            this.addError("domain-validation-partnersNumber", "domain.partnersNumber");
        }
        if ((operatorWorkForce = this.domain.getOperatorWorkForce()) != null && operatorWorkForce < 0.0) {
            this.addError("domain-validation-operatorWorkForce", "domain.operatorWorkForce");
        }
        if ((otherWorkForce = this.domain.getOtherWorkForce()) != null && otherWorkForce < 0.0) {
            this.addError("domain-validation-otherWorkForce", "domain.otherWorkForce");
        }
        if ((cropsWorkForce = this.domain.getCropsWorkForce()) != null && cropsWorkForce < 0.0) {
            this.addError("domain-validation-cropsWorkForce", "domain.cropsWorkForce");
        }
        if ((volunteerWorkForce = this.domain.getVolunteerWorkForce()) != null && volunteerWorkForce < 0.0) {
            this.addError("domain-validation-volunteerWorkForce", "domain.volunteerWorkForce");
        }
        if ((permanentEmployeesWorkForce = this.domain.getPermanentEmployeesWorkForce()) != null && permanentEmployeesWorkForce < 0.0) {
            this.addError("domain-validation-permanentEmployeesWorkForce", "domain.permanentEmployeesWorkForce");
        }
        if ((temporaryEmployeesWorkForce = this.domain.getTemporaryEmployeesWorkForce()) != null && temporaryEmployeesWorkForce < 0.0) {
            this.addError("domain-validation-temporaryEmployeesWorkForce", "domain.temporaryEmployeesWorkForce");
        }
        if ((seasonalWorkForce = this.domain.getSeasonalWorkForce()) != null && seasonalWorkForce < 0.0) {
            this.addError("domain-validation-seasonalWorkForce", "domain.seasonalWorkForce");
        }
        if ((nonSeasonalWorkForce = this.domain.getNonSeasonalWorkForce()) != null && nonSeasonalWorkForce < 0.0) {
            this.addError("domain-validation-nonSeasonalWorkForce", "domain.nonSeasonalWorkForce");
        }
        if ((nbPlot = this.domain.getNbPlot()) != null && nbPlot < 0) {
            this.addActionError(this.getText("domain-validation-nbPlotNegative"));
        }
        if ((furthestPlotDistance = this.domain.getFurthestPlotDistance()) != null && furthestPlotDistance < 0.0) {
            this.addActionError(this.getText("domain-validation-furthestPlotDistanceNegative"));
        }
        if ((areaAroundHQ = this.domain.getAreaAroundHQ()) != null && areaAroundHQ < 0.0) {
            this.addActionError(this.getText("domain-validation-areaAroundHQ"));
        }
    }

    private void addError(String errorMessageKey, String fieldName) {
        String errorMessage = this.getText(errorMessageKey);
        this.addFieldError(fieldName, errorMessage);
        this.addActionError(errorMessage);
    }

    protected void validWeatherStations() {
        try {
            this.weatherStations = this.convertWeatherStationsJson(this.weatherStationsJson);
        }
        catch (Exception ex) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)("for domain '" + this.domain.getTopiaId() + "'"), (Throwable)ex);
            }
            this.addActionError(String.format(this.getText("domain-validation-loadingWeatherStationsFailed"), ex));
            this.weatherStations = this.getWeatherStations(this.domain);
        }
        if (this.weatherStations != null) {
            ArrayList<WeatherStationDto> emptyWeatherStationDtos = new ArrayList<WeatherStationDto>();
            this.weatherStations.removeAll(Collections.singleton(null));
            for (WeatherStationDto weatherStationDto : this.weatherStations) {
                if (!StringUtils.isBlank((CharSequence)weatherStationDto.getRefStationMeteoTopiaId())) continue;
                if (StringUtils.isNotBlank((CharSequence)weatherStationDto.getComment()) || StringUtils.isNotBlank((CharSequence)weatherStationDto.getData())) {
                    this.addActionError(this.getText("domain-validation-requiredWeatherStationName"));
                    continue;
                }
                emptyWeatherStationDtos.add(weatherStationDto);
            }
            this.weatherStations.removeAll(emptyWeatherStationDtos);
        }
    }

    protected void validEquipments() {
        try {
            this.equipments = this.convertEquipmentsJson(this.equipmentsJson);
            if (this.equipments != null) {
                this.equipments.removeAll(Collections.singleton(null));
                for (Equipment equipment : this.equipments) {
                    Double realUsage;
                    if (StringUtils.isBlank((CharSequence)equipment.getName())) {
                        this.addActionError(this.getText("domain-validation-requiredEquipmentName"));
                    }
                    if ((realUsage = equipment.getRealUsage()) == null || !(realUsage < 0.0)) continue;
                    this.addActionError(this.getText("domain-validation-realUsageNegative"));
                }
            }
        }
        catch (Exception ex) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)("for domain '" + this.domainTopiaId + "'"), (Throwable)ex);
            }
            this.addActionError(String.format(this.getText("domain-validation-loadingEquipmentsFailed"), ex));
            this.equipments = StringUtils.isBlank((CharSequence)this.domainTopiaId) ? null : this.domainService.getEquipments(this.domainTopiaId);
        }
    }

    protected void validToolsCouplings() {
        if (StringUtils.isNotBlank((CharSequence)this.toolsCouplingsJson)) {
            try {
                this.toolsCouplings = this.convertToolsCouplingsJson(this.toolsCouplingsJson);
                this.toolsCouplings.removeAll(Collections.singleton(null));
                for (ToolsCoupling toolsCoupling : this.toolsCouplings) {
                    Double workforce;
                    Collection tcEquipments = toolsCoupling.getEquipments();
                    String toolsCouplingName = this.getText("domain-validation-toolsCouplingNameNotSet");
                    if (StringUtils.isBlank((CharSequence)toolsCoupling.getToolsCouplingName())) {
                        this.addActionError(this.getText("domain-validation-requiredToolsCouplingName"));
                    } else {
                        toolsCouplingName = toolsCoupling.getToolsCouplingName();
                    }
                    Double workRate = toolsCoupling.getWorkRate();
                    if (workRate != null && workRate < 0.0) {
                        this.addActionError(this.getText("domain-validation-toolsCouplingWorkRateNegative"));
                    }
                    if ((workforce = toolsCoupling.getWorkforce()) != null && workforce < 0.0) {
                        this.addActionError(this.getText("domain-validation-toolsCouplingWorkforceNegative"));
                    }
                    if (toolsCoupling.getMainsActions() == null || toolsCoupling.getMainsActions().isEmpty()) {
                        String errorMessage = String.format(this.getText("domain-validation-requiredActionForToolsCoupling"), toolsCouplingName);
                        this.addFieldError("editedToolsCoupling-mainsActions", errorMessage);
                        this.addActionError(errorMessage);
                    }
                    if (!toolsCoupling.isManualIntervention()) {
                        Equipment tractor;
                        boolean isIrrigationEquipments = false;
                        boolean isNonIrrigationEquipments = false;
                        if (CollectionUtils.isNotEmpty((Collection)tcEquipments)) {
                            for (Equipment tcEquipment : tcEquipments) {
                                boolean isIrrigationEquipment = tcEquipment.getRefMateriel() instanceof RefMaterielIrrigation;
                                if (isIrrigationEquipment) {
                                    isIrrigationEquipments = true;
                                    continue;
                                }
                                isNonIrrigationEquipments = true;
                            }
                        }
                        if ((tractor = toolsCoupling.getTractor()) == null) {
                            if (!isIrrigationEquipments) {
                                errorMessage = String.format(this.getText("domain-validation-requiredIrrigationForToolsCoupling"), toolsCouplingName);
                                this.addFieldError("editedToolsCoupling-mainsActions", errorMessage);
                                this.addActionError(errorMessage);
                            } else if (CollectionUtils.isNotEmpty((Collection)tcEquipments) && isNonIrrigationEquipments) {
                                errorMessage = String.format(this.getText("domain-validation-invalidIrrigationAssociationForToolsCoupling"), toolsCouplingName);
                                this.addFieldError("editedToolsCoupling-mainsActions", errorMessage);
                                this.addActionError(errorMessage);
                            }
                        } else {
                            if ((tractor.getRefMateriel() == null || !(tractor.getRefMateriel() instanceof RefMaterielAutomoteur)) && CollectionUtils.isEmpty((Collection)tcEquipments)) {
                                this.addActionError(String.format(this.getText("domain-validation-missingTractorOnToolsCoupling"), toolsCouplingName));
                            }
                            if (CollectionUtils.isNotEmpty((Collection)tcEquipments) && isIrrigationEquipments && isNonIrrigationEquipments) {
                                errorMessage = String.format(this.getText("domain-validation-invalidIrrigationAssociationForToolsCoupling"), toolsCouplingName);
                                this.addFieldError("editedToolsCoupling-mainsActions", errorMessage);
                                this.addActionError(errorMessage);
                            }
                            if (tractor.getRefMateriel() instanceof RefMaterielOutil) {
                                errorMessage = String.format(this.getText("domain-validation-invalidEquipmentTypeOnToolsCoupling"), toolsCouplingName);
                                this.addFieldError("editedToolsCoupling-mainsActions", errorMessage);
                                this.addActionError(errorMessage);
                            }
                        }
                    }
                    if (!CollectionUtils.isNotEmpty((Collection)tcEquipments)) continue;
                    HashSet uniqueEquipments = new HashSet(tcEquipments);
                    toolsCoupling.setEquipments(uniqueEquipments);
                }
            }
            catch (Exception ex) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error((Object)("for domain '" + this.domainTopiaId + "'"), (Throwable)ex);
                }
                this.addActionError(String.format(this.getText("domain-validation-loadingToolsCouplingsFailed"), ex));
            }
        }
    }

    protected void validGeoPoints() {
        try {
            this.geoPoints = this.convertGeoPointsJson(this.geoPointsJson);
        }
        catch (Exception ex) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)("for domain '" + this.domainTopiaId + "'"), (Throwable)ex);
            }
            this.addActionError(String.format(this.getText("domain-validation-loadingGeopointsFailed"), ex));
        }
        if (this.geoPoints == null) {
            this.geoPoints = StringUtils.isBlank((CharSequence)this.domainTopiaId) ? null : this.domainService.getGeoPoints(this.domainTopiaId);
        } else {
            this.geoPoints.removeAll(Collections.singleton(null));
            ArrayList<GeoPoint> emptyGeoPoints = new ArrayList<GeoPoint>();
            for (GeoPoint geoPoint : this.geoPoints) {
                if (!Strings.isNullOrEmpty((String)geoPoint.getName())) continue;
                if (geoPoint.getLatitude() != 0.0 || geoPoint.getLongitude() != 0.0 || StringUtils.isNotBlank((CharSequence)geoPoint.getDescription())) {
                    this.addActionError(this.getText("domain-validation-requiredGeopointName"));
                    continue;
                }
                emptyGeoPoints.add(geoPoint);
            }
            this.geoPoints.removeAll(emptyGeoPoints);
        }
    }

    protected void validLiveStock() {
        this.livestockUnits = this.computeLiveStockUnits();
        if (CollectionUtils.isNotEmpty((Collection)this.livestockUnits) && this.livestockUnits.stream().filter(Objects::nonNull).anyMatch(livestockUnit -> livestockUnit.getRefAnimalType() == null)) {
            this.addActionError(this.getText("domain-validation-requiredLivestockAnimalType"));
        }
    }

    protected void validDomainInputStockUnits() {
        try {
            this.inputStockUnits = this.convertDomainInputStockUnitsJson(this.inputStockUnitsJson);
            if (this.inputStockUnits == null) {
                return;
            }
            for (DomainInputDto domainInput : this.inputStockUnits) {
                DomainOtherProductInputDto otherInput;
                Double lifetime;
                domainInput.getPrice().ifPresent(inputPriceDto -> {
                    Double price = inputPriceDto.getPrice();
                    if (price != null && price < 0.0) {
                        this.addActionError(this.getText("domain-validation-inputPriceNegative").formatted(domainInput.getInputName()));
                    }
                });
                if (domainInput instanceof DomainMineralProductInputDto) {
                    DomainMineralProductInputDto mineralInput = (DomainMineralProductInputDto)domainInput;
                    if (mineralInput.getBore() < 0.0) {
                        this.addActionErrorForMineralInput("common-element-B");
                    }
                    if (mineralInput.getCalcium() < 0.0) {
                        this.addActionErrorForMineralInput("common-element-Ca");
                    }
                    if (mineralInput.getCuivre() < 0.0) {
                        this.addActionErrorForMineralInput("common-element-Cu");
                    }
                    if (mineralInput.getFer() < 0.0) {
                        this.addActionErrorForMineralInput("common-element-Fe");
                    }
                    if (mineralInput.getManganese() < 0.0) {
                        this.addActionErrorForMineralInput("common-element-Mn");
                    }
                    if (mineralInput.getN() < 0.0) {
                        this.addActionErrorForMineralInput("common-element-N");
                    }
                    if (mineralInput.getK2o() < 0.0) {
                        this.addActionErrorForMineralInput("common-element-K2O");
                    }
                    if (mineralInput.getMgo() < 0.0) {
                        this.addActionErrorForMineralInput("common-element-MgO");
                    }
                    if (mineralInput.getMolybdene() < 0.0) {
                        this.addActionErrorForMineralInput("common-element-Mo");
                    }
                    if (mineralInput.getOxyde_de_sodium() < 0.0) {
                        this.addActionErrorForMineralInput("common-element-Na2O");
                    }
                    if (mineralInput.getP2o5() < 0.0) {
                        this.addActionErrorForMineralInput("common-element-P2O5");
                    }
                    if (mineralInput.getSo3() < 0.0) {
                        this.addActionErrorForMineralInput("common-element-SO3");
                    }
                    if (!(mineralInput.getZinc() < 0.0)) continue;
                    this.addActionErrorForMineralInput("common-element-Zn");
                    continue;
                }
                if (domainInput instanceof DomainOrganicProductInputDto) {
                    DomainOrganicProductInputDto organicInput = (DomainOrganicProductInputDto)domainInput;
                    if (organicInput.getCaO() != null && organicInput.getCaO() < 0.0) {
                        this.addActionErrorForOrganicInput("common-element-CaO");
                    }
                    if (organicInput.getK2O() < 0.0) {
                        this.addActionErrorForOrganicInput("common-element-K2O");
                    }
                    if (organicInput.getN() < 0.0) {
                        this.addActionErrorForOrganicInput("common-element-N");
                    }
                    if (organicInput.getMgO() != null && organicInput.getMgO() < 0.0) {
                        this.addActionErrorForOrganicInput("common-element-MgO");
                    }
                    if (organicInput.getP2O5() < 0.0) {
                        this.addActionErrorForOrganicInput("common-element-P2O5");
                    }
                    if (organicInput.getS() != null && organicInput.getS() < 0.0) {
                        this.addActionErrorForOrganicInput("common-element-S");
                    }
                    break;
                }
                if (!(domainInput instanceof DomainOtherProductInputDto) || (lifetime = (otherInput = (DomainOtherProductInputDto)domainInput).getLifetime()) == null || !(lifetime < 0.0)) continue;
                this.addActionError(this.getText("agrosyst-domain-validation-otherInputLifetimeNegative"));
            }
        }
        catch (Exception ex) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)("for domain '" + this.domainTopiaId + "'"), (Throwable)ex);
            }
            this.addActionError(String.format(this.getText("domain-validation-loadingInputsFailed"), ex));
        }
    }

    private void addActionErrorForMineralInput(String elementKey) {
        this.addActionError(this.getText("agrosyst-domain-validation-mineralInput").formatted(this.getText(elementKey)));
    }

    private void addActionErrorForOrganicInput(String elementKey) {
        this.addActionError(this.getText("agrosyst-domain-validation-organicInput").formatted(this.getText(elementKey)));
    }

    protected void validGrounds() {
        try {
            this.grounds = this.convertGroundsJson(this.groundsJson);
        }
        catch (Exception ex) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)("for domain '" + this.domainTopiaId + "'"), (Throwable)ex);
            }
            this.addActionError(String.format(this.getText("domain-validation-loadingGroundsFailed"), ex));
        }
        if (this.grounds == null) {
            this.grounds = StringUtils.isBlank((CharSequence)this.domainTopiaId) ? null : this.domainService.getGrounds(this.domainTopiaId);
        } else {
            this.grounds.removeAll(Collections.singleton(null));
            for (Ground ground : this.grounds) {
                double importance;
                if (ground.getRefSolArvalis() == null) {
                    this.addActionError(this.getText("domain-validation-groundRegionRequired"));
                }
                if (!((importance = ground.getImportance()) < 0.0) && !(importance > 100.0)) continue;
                this.addActionError(this.getText("domain-validation-groundImportanceNegative"));
            }
        }
    }

    protected void validCroppingPlans() {
        try {
            this.croppingPlans = this.convertCroppingPlansJson(this.croppingPlansJson);
        }
        catch (Exception ex) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)("for domain '" + this.domainTopiaId + "'"), (Throwable)ex);
            }
            this.addActionError(String.format(this.getText("domain-validation-loadingCropsFailed"), ex));
        }
        if (this.croppingPlans != null) {
            this.croppingPlans.removeAll(Collections.singleton(null));
            for (CroppingPlanEntryDto croppingPlanEntryDto : this.croppingPlans) {
                Double biocontrolIFT;
                Double averageIFT;
                String cropName;
                if (StringUtils.isBlank((CharSequence)croppingPlanEntryDto.getName())) {
                    this.addActionError(this.getText("domain-validation-cropNameRequired"));
                }
                Double yealdAverage = croppingPlanEntryDto.getYealdAverage();
                String string = cropName = croppingPlanEntryDto.getName() == null ? "?" : croppingPlanEntryDto.getName();
                if (yealdAverage != null && croppingPlanEntryDto.getYealdUnit() == null) {
                    this.addActionError(String.format(this.getText("domain-validation-missingCropYieldUnit"), cropName, df.format(yealdAverage)));
                }
                if (yealdAverage != null && yealdAverage < 0.0) {
                    this.addActionError(String.format(this.getText("domain-validation-cropYieldNegative"), cropName));
                }
                if ((averageIFT = croppingPlanEntryDto.getAverageIFT()) != null && averageIFT < 0.0) {
                    this.addActionError(String.format(this.getText("domain-validation-cropAverageIFTNegative"), cropName));
                }
                if ((biocontrolIFT = croppingPlanEntryDto.getBiocontrolIFT()) != null && biocontrolIFT < 0.0) {
                    this.addActionError(String.format(this.getText("domain-validation-cropBiocontrolIFTNegative"), cropName));
                }
                croppingPlanEntryDto.getSpecies().removeAll(Collections.singleton(null));
                Iterables.removeIf((Iterable)croppingPlanEntryDto.getSpecies(), HAS_NO_SPECIES::test);
            }
        }
        if (this.domain.getSpeciesToArea() != null) {
            String speciesToAreaMap = this.domainService.sanitizedDomainSpeciesToAreaJson(this.domain.getSpeciesToArea());
            this.domain.setSpeciesToArea(speciesToAreaMap);
        }
    }

    protected void validHarvestingPrices() {
        if (this.harvestingPriceDtos == null) {
            return;
        }
        for (HarvestingPriceDto harvestingPriceDto : this.harvestingPriceDtos) {
            Double price = harvestingPriceDto.getPrice();
            if (price == null || !(price < 0.0)) continue;
            this.addActionError(this.getText("domain-validation-harvestingPriceNegative").formatted(harvestingPriceDto.getDisplayName()));
        }
    }

    @Action(results={@Result(type="redirectAction", params={"actionName", "domains-edit-input", "domainTopiaId", "${domain.topiaId}"})})
    public String execute() throws Exception {
        this.propagateWeatherStationsChanges();
        this.domain.setCampaign(this.campaign.intValue());
        this.domain.setSiret(StringUtils.trimToNull((String)StringUtils.replace((String)this.domainSiret, (String)" ", (String)"")));
        this.createOrUpdateDomain();
        this.notificationSupport.domainSaved(this.domain);
        if (Strings.isNullOrEmpty((String)this.domainTopiaId)) {
            this.navigationContextEntityCreated((TopiaEntity)this.domain);
        }
        return "success";
    }

    protected void createOrUpdateDomain() {
        this.domain = this.domainService.createOrUpdateDomain(this.domain, this.locationTopiaId, this.legalStatusId, this.geoPoints, this.croppingPlans, this.otex18, this.otex70, this.grounds, this.equipments, this.toolsCouplings, this.livestockUnits, (Collection)this.inputStockUnits, this.harvestingPriceDtos);
        if (this.croppingPlans != null && this.croppingPlans.stream().anyMatch(croppingPlan -> CollectionUtils.isEmpty((Collection)croppingPlan.getSpecies()))) {
            this.notificationSupport.warning(this.notificationSupport.getTranslatedText("domain.save.warning.missingSpecies", new Object[0]), new Object[0]);
        }
    }

    private List<LivestockUnit> computeLiveStockUnits() {
        List livestockUnits;
        try {
            livestockUnits = this.convertLivestockUnitsJson(this.livestockUnitsJson);
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)("for domain '" + this.domainTopiaId + "'"), (Throwable)e);
            }
            livestockUnits = StringUtils.isBlank((CharSequence)this.domainTopiaId) ? null : this.domainService.loadLivestockUnitsForDomainId(this.domainTopiaId);
        }
        return livestockUnits;
    }

    protected void propagateWeatherStationsChanges() {
        ArrayList<WeatherStation> weatherStations = this.getDomain().getWeatherStations();
        ArrayList<WeatherStation> nonDeleted = new ArrayList<WeatherStation>();
        if (weatherStations == null) {
            weatherStations = new ArrayList<WeatherStation>();
            this.getDomain().setWeatherStations(weatherStations);
        }
        ImmutableMap indexWeatherStations = Maps.uniqueIndex(weatherStations, Entities.GET_TOPIA_ID::apply);
        this.getDomain().setDefaultWeatherStation(null);
        if (this.weatherStations != null) {
            for (WeatherStationDto weatherStationDto : this.weatherStations) {
                String topiaId = weatherStationDto.getTopiaId();
                WeatherStation weatherStation = Strings.isNullOrEmpty((String)topiaId) ? this.domainService.newWeatherStation() : (WeatherStation)indexWeatherStations.get(topiaId);
                if (weatherStation == null) continue;
                String refStationId = weatherStationDto.getRefStationMeteoTopiaId();
                RefStationMeteo refStation = this.referentialService.findRefStationMeteoByTopiaId(refStationId);
                WeatherStations.dtoToWeatherStation((WeatherStationDto)weatherStationDto, (WeatherStation)weatherStation, (RefStationMeteo)refStation);
                if (StringUtils.isBlank((CharSequence)topiaId)) {
                    weatherStations.add(weatherStation);
                }
                nonDeleted.add(weatherStation);
                if (LOGGER.isErrorEnabled()) {
                    String domainId = this.getLogEntityId((TopiaEntity)this.getDomain());
                    LOGGER.error((Object)String.format("on domain with id '%s', adding weatherStation : ID : %s, %s", domainId, weatherStation.getTopiaId(), ReflectionToStringBuilder.toString((Object)weatherStationDto)));
                }
                if (!weatherStationDto.isDefaultSelected()) continue;
                this.getDomain().setDefaultWeatherStation(weatherStation);
            }
        }
        weatherStations.retainAll(nonDeleted);
    }

    public Map<DomainType, String> getTypes() {
        return this.i18nService.getEnumTranslationMap(DomainType.class);
    }

    public Map<AgrosystInterventionType, String> getAgrosystInterventionTypes() {
        Map map = this.referentialService.getAgrosystInterventionTypeTranslationMap();
        return map;
    }

    public Map<Zoning, String> getZoningValues() {
        return this.getEnumAsMap((Object[])Zoning.values());
    }

    public String getFormatedDepartement() {
        if (StringUtils.isBlank((CharSequence)this.departement)) {
            return "";
        }
        String depNumber = Strings.padStart((String)this.departement, (int)2, (char)'0');
        String key = "departement." + depNumber;
        Object result = this.getText(key);
        result = (String)result + " (" + depNumber + ")";
        return result;
    }

    public String getFormatedPetiteRegionAgricoleName() {
        if (StringUtils.isBlank((CharSequence)this.petiteRegionAgricoleName)) {
            return "";
        }
        return this.petiteRegionAgricoleName + " (" + this.petiteRegionAgricole + ")";
    }

    public Map<String, Boolean> getCroppingPlansUsageMap() {
        if (this.croppingPlansUsageList != null) {
            return this.croppingPlansUsageList.getUsageMap();
        }
        return new HashMap<String, Boolean>();
    }

    public Map<AgrosystInterventionType, String> getAgrosystInterventionType() {
        return this.referentialService.getAgrosystInterventionTypeTranslationMap();
    }

    public Map<PriceUnit, String> getPriceUnits() {
        return this.getEnumAsMap((Object[])PriceUnit.values());
    }

    public Map<String, Boolean> getCroppingPlanSpeciesUsageMap() {
        if (this.croppingPlanSpeciesUsageMap == null) {
            this.croppingPlanSpeciesUsageMap = new HashMap();
        }
        return this.croppingPlanSpeciesUsageMap;
    }

    public Map<MaterielWorkRateUnit, String> getMaterielWorkRateUnits() {
        return this.getEnumAsMap((Object[])MaterielWorkRateUnit.values());
    }

    public Map<MaterielTransportUnit, String> getMaterielTransportUnits() {
        return this.getEnumAsMap((Object[])MaterielTransportUnit.values());
    }

    public List<GeoPoint> convertGeoPointsJson(String gpsDataDtos) {
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        return (List)this.getGson().fromJson(gpsDataDtos, type);
    }

    public Collection<WeatherStationDto> convertWeatherStationsJson(String json) {
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        return (Collection)this.getGson().fromJson(json, type);
    }

    public List<LivestockUnit> convertLivestockUnitsJson(String json) {
        List livestockUnits = null;
        if (StringUtils.isNotBlank((CharSequence)json)) {
            Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
            livestockUnits = (List)this.getGson().fromJson(json, type);
        }
        return livestockUnits;
    }

    public List<DomainInputDto> convertDomainInputStockUnitsJson(String json) {
        List domainInputStockUnits = null;
        if (StringUtils.isNotBlank((CharSequence)json)) {
            Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
            domainInputStockUnits = (List)this.getGson().fromJson(json, type);
        }
        return domainInputStockUnits;
    }

    public List<Ground> convertGroundsJson(String json) {
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        return (List)this.getGson().fromJson(json, type);
    }

    public List<Equipment> convertEquipmentsJson(String json) {
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        return (List)this.getGson().fromJson(json, type);
    }

    public List<ToolsCoupling> convertToolsCouplingsJson(String json) {
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        return (List)this.getGson().fromJson(json, type);
    }

    public List<CroppingPlanEntryDto> convertCroppingPlansJson(String json) {
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        return (List)this.getGson().fromJson(json, type);
    }

    public String getDomainSiret() {
        Object result = null;
        if (StringUtils.isNotBlank((CharSequence)this.getDomain().getSiret())) {
            String siret = StringUtils.replace((String)this.getDomain().getSiret(), (String)" ", (String)"");
            result = siret.substring(0, 3);
            result = (String)result + " " + siret.substring(3, 6);
            result = (String)result + " " + siret.substring(6, 9);
            result = (String)result + " " + siret.substring(9, 14);
        }
        return result;
    }

    public Map<String, String> getCountries() {
        if (this.countries == null) {
            this.countries = this.domainService.getCountries();
        }
        return this.countries;
    }

    public String getDefaultCountryTopiaId() {
        return this.domainService.getDefaultCountryTopiaId();
    }

    public String getFranceTopiaId() {
        return this.domainService.getFranceRefCountry().getTopiaId();
    }

    public String getDomainLocationCommune() {
        RefLocation location = this.domain.getLocation();
        if (location == null) {
            return "";
        }
        if (location.getCodePostal() != null) {
            return location.getCodePostal() + ", " + location.getCommune();
        }
        return location.getCommune();
    }

    public void setAllRegularPricesJson(String allRegularPricesJson) {
        this.allRegularPricesJson = allRegularPricesJson;
        this.harvestingPriceDtos = this.convertAllRegularPricesJson(allRegularPricesJson);
    }

    private List<HarvestingPriceDto> convertAllRegularPricesJson(String json) {
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        return (List)this.getGson().fromJson(json, type);
    }

    private String sanitizeSpeciesToAreaJson(String json) {
        return this.domainService.sanitizedDomainSpeciesToAreaJson(json);
    }

    @Generated
    public ReferentialService getReferentialService() {
        return this.referentialService;
    }

    @Generated
    public DomainService getDomainService() {
        return this.domainService;
    }

    @Generated
    public PlotService getPlotService() {
        return this.plotService;
    }

    @Generated
    public PricesService getPricesService() {
        return this.pricesService;
    }

    @Generated
    public DomainInputStockUnitService getDomainInputStockUnitService() {
        return this.domainInputStockUnitService;
    }

    @Generated
    public Integer getCampaign() {
        return this.campaign;
    }

    @Generated
    public String getSpeciesToArea() {
        return this.speciesToArea;
    }

    @Generated
    public LinkedHashMap<Integer, String> getRelatedDomains() {
        return this.relatedDomains;
    }

    @Generated
    public List<GeoPoint> getGeoPoints() {
        return this.geoPoints;
    }

    @Generated
    public String getGeoPointsJson() {
        return this.geoPointsJson;
    }

    @Generated
    public String getDomainTopiaId() {
        return this.domainTopiaId;
    }

    @Generated
    public String getCommune() {
        return this.commune;
    }

    @Generated
    public String getLegalStatusId() {
        return this.legalStatusId;
    }

    @Generated
    public List<RefLegalStatus> getAllRefLegalStatus() {
        return this.allRefLegalStatus;
    }

    @Generated
    public RefLocation getLocation() {
        return this.location;
    }

    @Generated
    public String getDepartement() {
        return this.departement;
    }

    @Generated
    public String getPetiteRegionAgricole() {
        return this.petiteRegionAgricole;
    }

    @Generated
    public String getPetiteRegionAgricoleName() {
        return this.petiteRegionAgricoleName;
    }

    @Generated
    public String getCountryTopiaId() {
        return this.countryTopiaId;
    }

    @Generated
    public String getLocationTopiaId() {
        return this.locationTopiaId;
    }

    @Generated
    public List<Equipment> getEquipments() {
        return this.equipments;
    }

    @Generated
    public String getEquipmentsJson() {
        return this.equipmentsJson;
    }

    @Generated
    public List<ToolsCoupling> getToolsCouplings() {
        return this.toolsCouplings;
    }

    @Generated
    public String getToolsCouplingsJson() {
        return this.toolsCouplingsJson;
    }

    @Generated
    public Map<Integer, String> getSolArvalisRegions() {
        return this.solArvalisRegions;
    }

    @Generated
    public List<Ground> getGrounds() {
        return this.grounds;
    }

    @Generated
    public String getGroundsJson() {
        return this.groundsJson;
    }

    @Generated
    public List<CroppingPlanEntryDto> getCroppingPlans() {
        return this.croppingPlans;
    }

    @Generated
    public String getCroppingPlansJson() {
        return this.croppingPlansJson;
    }

    @Generated
    public UsageList<CroppingPlanEntryDto> getCroppingPlansUsageList() {
        return this.croppingPlansUsageList;
    }

    @Generated
    public Integer getOtex18() {
        return this.otex18;
    }

    @Generated
    public Integer getOtex70() {
        return this.otex70;
    }

    @Generated
    public Map<Integer, String> getOtex18s() {
        return this.otex18s;
    }

    @Generated
    public Map<Integer, String> getOtex70s() {
        return this.otex70s;
    }

    @Generated
    public Collection<WeatherStationDto> getWeatherStations() {
        return this.weatherStations;
    }

    @Generated
    public String getWeatherStationsJson() {
        return this.weatherStationsJson;
    }

    @Generated
    public Map<String, String> getAllRefStationMeteoIdsAndNames() {
        return this.allRefStationMeteoIdsAndNames;
    }

    @Generated
    public List<RefInterventionAgrosystTravailEDI> getAgrosystActionsFullList() {
        return this.agrosystActionsFullList;
    }

    @Generated
    public boolean isCanEditPlots() {
        return this.canEditPlots;
    }

    @Generated
    public List<LivestockUnit> getLivestockUnits() {
        return this.livestockUnits;
    }

    @Generated
    public String getLivestockUnitsJson() {
        return this.livestockUnitsJson;
    }

    @Generated
    public List<DomainInputDto> getInputStockUnits() {
        return this.inputStockUnits;
    }

    @Generated
    public String getInputStockUnitsJson() {
        return this.inputStockUnitsJson;
    }

    @Generated
    public int getPlotExportAsyncThreshold() {
        return this.plotExportAsyncThreshold;
    }

    @Generated
    public List<HarvestingPriceDto> getHarvestingPriceDtos() {
        return this.harvestingPriceDtos;
    }

    @Generated
    public String getAllRegularPricesJson() {
        return this.allRegularPricesJson;
    }

    @Generated
    public void setReferentialService(ReferentialService referentialService) {
        this.referentialService = referentialService;
    }

    @Generated
    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }

    @Generated
    public void setPlotService(PlotService plotService) {
        this.plotService = plotService;
    }

    @Generated
    public void setPricesService(PricesService pricesService) {
        this.pricesService = pricesService;
    }

    @Generated
    public void setDomainInputStockUnitService(DomainInputStockUnitService domainInputStockUnitService) {
        this.domainInputStockUnitService = domainInputStockUnitService;
    }

    @Generated
    public void setCampaign(Integer campaign) {
        this.campaign = campaign;
    }

    @Generated
    public void setDomain(Domain domain) {
        this.domain = domain;
    }

    @Generated
    public void setSpeciesToArea(String speciesToArea) {
        this.speciesToArea = speciesToArea;
    }

    @Generated
    public void setRelatedDomains(LinkedHashMap<Integer, String> relatedDomains) {
        this.relatedDomains = relatedDomains;
    }

    @Generated
    public void setGeoPoints(List<GeoPoint> geoPoints) {
        this.geoPoints = geoPoints;
    }

    @Generated
    public void setGeoPointsJson(String geoPointsJson) {
        this.geoPointsJson = geoPointsJson;
    }

    @Generated
    public void setDomainTopiaId(String domainTopiaId) {
        this.domainTopiaId = domainTopiaId;
    }

    @Generated
    public void setCommune(String commune) {
        this.commune = commune;
    }

    @Generated
    public void setLegalStatusId(String legalStatusId) {
        this.legalStatusId = legalStatusId;
    }

    @Generated
    public void setAllRefLegalStatus(List<RefLegalStatus> allRefLegalStatus) {
        this.allRefLegalStatus = allRefLegalStatus;
    }

    @Generated
    public void setLocation(RefLocation location) {
        this.location = location;
    }

    @Generated
    public void setDepartement(String departement) {
        this.departement = departement;
    }

    @Generated
    public void setPetiteRegionAgricole(String petiteRegionAgricole) {
        this.petiteRegionAgricole = petiteRegionAgricole;
    }

    @Generated
    public void setPetiteRegionAgricoleName(String petiteRegionAgricoleName) {
        this.petiteRegionAgricoleName = petiteRegionAgricoleName;
    }

    @Generated
    public void setCountryTopiaId(String countryTopiaId) {
        this.countryTopiaId = countryTopiaId;
    }

    @Generated
    public void setLocationTopiaId(String locationTopiaId) {
        this.locationTopiaId = locationTopiaId;
    }

    @Generated
    public void setEquipments(List<Equipment> equipments) {
        this.equipments = equipments;
    }

    @Generated
    public void setEquipmentsJson(String equipmentsJson) {
        this.equipmentsJson = equipmentsJson;
    }

    @Generated
    public void setToolsCouplings(List<ToolsCoupling> toolsCouplings) {
        this.toolsCouplings = toolsCouplings;
    }

    @Generated
    public void setToolsCouplingsJson(String toolsCouplingsJson) {
        this.toolsCouplingsJson = toolsCouplingsJson;
    }

    @Generated
    public void setSolArvalisRegions(Map<Integer, String> solArvalisRegions) {
        this.solArvalisRegions = solArvalisRegions;
    }

    @Generated
    public void setGrounds(List<Ground> grounds) {
        this.grounds = grounds;
    }

    @Generated
    public void setGroundsJson(String groundsJson) {
        this.groundsJson = groundsJson;
    }

    @Generated
    public void setCroppingPlans(List<CroppingPlanEntryDto> croppingPlans) {
        this.croppingPlans = croppingPlans;
    }

    @Generated
    public void setCroppingPlansJson(String croppingPlansJson) {
        this.croppingPlansJson = croppingPlansJson;
    }

    @Generated
    public void setCroppingPlansUsageList(UsageList<CroppingPlanEntryDto> croppingPlansUsageList) {
        this.croppingPlansUsageList = croppingPlansUsageList;
    }

    @Generated
    public void setCroppingPlanSpeciesUsageMap(Map<String, Boolean> croppingPlanSpeciesUsageMap) {
        this.croppingPlanSpeciesUsageMap = croppingPlanSpeciesUsageMap;
    }

    @Generated
    public void setOtex18(Integer otex18) {
        this.otex18 = otex18;
    }

    @Generated
    public void setOtex70(Integer otex70) {
        this.otex70 = otex70;
    }

    @Generated
    public void setOtex18s(Map<Integer, String> otex18s) {
        this.otex18s = otex18s;
    }

    @Generated
    public void setOtex70s(Map<Integer, String> otex70s) {
        this.otex70s = otex70s;
    }

    @Generated
    public void setWeatherStations(Collection<WeatherStationDto> weatherStations) {
        this.weatherStations = weatherStations;
    }

    @Generated
    public void setWeatherStationsJson(String weatherStationsJson) {
        this.weatherStationsJson = weatherStationsJson;
    }

    @Generated
    public void setAllRefStationMeteoIdsAndNames(Map<String, String> allRefStationMeteoIdsAndNames) {
        this.allRefStationMeteoIdsAndNames = allRefStationMeteoIdsAndNames;
    }

    @Generated
    public void setAgrosystActionsFullList(List<RefInterventionAgrosystTravailEDI> agrosystActionsFullList) {
        this.agrosystActionsFullList = agrosystActionsFullList;
    }

    @Generated
    public void setCanEditPlots(boolean canEditPlots) {
        this.canEditPlots = canEditPlots;
    }

    @Generated
    public void setLivestockUnits(List<LivestockUnit> livestockUnits) {
        this.livestockUnits = livestockUnits;
    }

    @Generated
    public void setLivestockUnitsJson(String livestockUnitsJson) {
        this.livestockUnitsJson = livestockUnitsJson;
    }

    @Generated
    public void setInputStockUnits(List<DomainInputDto> inputStockUnits) {
        this.inputStockUnits = inputStockUnits;
    }

    @Generated
    public void setInputStockUnitsJson(String inputStockUnitsJson) {
        this.inputStockUnitsJson = inputStockUnitsJson;
    }

    @Generated
    public void setDomainSiret(String domainSiret) {
        this.domainSiret = domainSiret;
    }

    @Generated
    public void setPlotExportAsyncThreshold(int plotExportAsyncThreshold) {
        this.plotExportAsyncThreshold = plotExportAsyncThreshold;
    }

    @Generated
    public void setCountries(Map<String, String> countries) {
        this.countries = countries;
    }

    @Generated
    public void setHarvestingPriceDtos(List<HarvestingPriceDto> harvestingPriceDtos) {
        this.harvestingPriceDtos = harvestingPriceDtos;
    }
}

