/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.domains;

import fr.inra.agrosyst.api.services.domain.CroppingPlanEntryDto;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;
import java.lang.reflect.Type;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DomainCropsCopy
extends AbstractJsonAction {
    private static final long serialVersionUID = 1L;
    private static final Log LOGGER = LogFactory.getLog(DomainCropsCopy.class);
    protected transient String fromDomain;
    protected transient String toDomains;
    protected String croppingPlansJson;
    protected transient DomainService domainService;

    public String execute() throws Exception {
        try {
            List targetedDomainIds = this.getTargetedDomainIds(this.toDomains);
            List croppingPlans = this.convertCroppingPlansJson(this.croppingPlansJson);
            this.jsonData = this.domainService.pasteCrops(this.fromDomain, targetedDomainIds, croppingPlans);
            return "success";
        }
        catch (IllegalArgumentException e) {
            this.jsonData = e.getClass().getSimpleName();
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)String.format("copy crops from domain '%s' to domains '%s' failed", this.fromDomain, this.toDomains), (Throwable)e);
            }
            return "error";
        }
        catch (Exception e) {
            return "error";
        }
    }

    public void setFromDomain(String fromDomain) {
        this.fromDomain = fromDomain;
    }

    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }

    public void setToDomains(String json) {
        this.toDomains = json;
    }

    public void setCroppingPlansJson(String croppingPlansJson) {
        this.croppingPlansJson = croppingPlansJson;
    }

    protected List<String> getTargetedDomainIds(String json) {
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        List targetedDomains = (List)this.getGson().fromJson(json, type);
        return targetedDomains;
    }

    public List<CroppingPlanEntryDto> convertCroppingPlansJson(String json) {
        try {
            Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
            return (List)this.getGson().fromJson(json, type);
        }
        catch (Exception ex) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)("\u00c9chec de d\u00e9serialisation des cultures: '" + json + "' :" + ex.getMessage()));
            }
            return null;
        }
    }
}

