/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.commons;

import com.google.common.base.Preconditions;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EnumsJson
extends AbstractJsonAction {
    private static final Log LOGGER = LogFactory.getLog(EnumsJson.class);
    private static final long serialVersionUID = -2070861344150517877L;
    protected String enumType;

    public void setEnumType(String enumType) {
        this.enumType = enumType;
    }

    public String execute() throws Exception {
        try {
            Class<?> enumClass = Class.forName("fr.inra.agrosyst.api.entities." + this.enumType);
            Preconditions.checkArgument((boolean)enumClass.isEnum());
            this.jsonData = this.getEnumAsMap((Object[])enumClass.getEnumConstants());
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)("Failed to load referential list for class " + this.enumType), (Throwable)e);
            }
            this.jsonData = "Failed to load referential list for class " + this.enumType;
            return "error";
        }
        return "success";
    }
}

