/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.commons;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;
import java.lang.reflect.Modifier;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.components.URL;
import org.apache.struts2.dispatcher.mapper.ActionMapper;
import org.apache.struts2.dispatcher.mapper.DefaultActionMapper;
import org.apache.struts2.url.QueryStringBuilder;
import org.apache.struts2.url.StrutsQueryStringBuilder;
import org.apache.struts2.url.StrutsUrlEncoder;
import org.apache.struts2.url.UrlEncoder;
import org.apache.struts2.views.util.DefaultUrlHelper;
import org.apache.struts2.views.util.UrlHelper;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class EndpointsAction
extends AbstractAgrosystAction {
    private static final long serialVersionUID = 5425103883346009788L;
    private final SortedMap<String, String> endpoints = new TreeMap();

    public String execute() {
        Reflections reflections = new Reflections("fr.inra.agrosyst.web.actions", new Scanner[0]);
        Set actions = reflections.getSubTypesOf(AbstractAgrosystAction.class);
        actions.stream().filter(action -> !Modifier.isAbstract(action.getModifiers())).forEach(action -> {
            String ipmPref = action.getName().contains("ipmworks") ? "ipmworks_" : "";
            Object actionName = StringUtils.removeEnd((String)action.getSimpleName(), (String)"Action");
            actionName = StringUtils.uncapitalize((String)actionName);
            Object actionNameUrl = ((String)actionName).replaceAll("([a-z])([A-Z]+)", "$1-$2").toLowerCase();
            String packageName = action.getPackage().getName();
            String namespace = String.join((CharSequence)"/", StringUtils.substringAfter((String)packageName, (String)"actions.").split("\\."));
            namespace = StringUtils.prependIfMissing((String)namespace, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
            String result = this.computeStrutsUrl((String)actionNameUrl, namespace);
            this.endpoints.put(ipmPref + (String)actionName, result);
            if (action.getSimpleName().endsWith("Edit")) {
                actionName = (String)actionName + "Input";
                actionNameUrl = (String)actionNameUrl + "-input";
                result = this.computeStrutsUrl((String)actionNameUrl, namespace);
                this.endpoints.put(ipmPref + (String)actionName, result);
            }
        });
        return "success";
    }

    protected String computeStrutsUrl(String simpleName, String namespace) {
        ActionContext context = ActionContext.getContext();
        ActionInvocation invocation = context.getActionInvocation();
        URL url = new URL(invocation.getStack(), this.servletRequest, null);
        url.setActionMapper((ActionMapper)new DefaultActionMapper());
        DefaultUrlHelper helper = new DefaultUrlHelper();
        helper.setQueryStringBuilder((QueryStringBuilder)new StrutsQueryStringBuilder((UrlEncoder)new StrutsUrlEncoder()));
        url.setUrlHelper((UrlHelper)helper);
        return url.getUrlProvider().determineActionURL(simpleName, namespace, null, this.servletRequest, null, null, this.servletRequest.getScheme(), true, true, false, false);
    }

    public SortedMap<String, String> getEndpoints() {
        return this.endpoints;
    }
}

