/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.commons;

import fr.inra.agrosyst.api.exceptions.AgrosystTechnicalException;
import fr.inra.agrosyst.api.services.common.ExportResult;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

public abstract class AbstractExportAction
extends AbstractAgrosystAction {
    private static final Log LOGGER = LogFactory.getLog(AbstractExportAction.class);
    private static final long serialVersionUID = -4823105448951987123L;
    protected transient ExportResult exportResult;

    protected abstract ExportResult computeExportResult();

    @Action(results={@Result(type="stream", params={"contentType", "${contentType}", "inputName", "inputStream", "contentDisposition", "attachment; filename=\"${fileName}\"; filename*=UTF-8''${uriFileName}"})})
    public String execute() throws Exception {
        this.exportResult = this.computeExportResult();
        return "success";
    }

    public String getContentType() {
        return this.exportResult.content().type().toString();
    }

    public InputStream getInputStream() {
        try {
            InputStream inputStream = this.exportResult.content().toInputStream();
            return inputStream;
        }
        catch (Exception ex) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Can't generate xsl", (Throwable)ex);
            }
            throw new AgrosystTechnicalException("Can't create input stream", (Throwable)ex);
        }
    }

    public String getFileName() {
        return this.exportResult.getFileName();
    }

    public String getUriFileName() throws UnsupportedEncodingException {
        String uriFilename = URLEncoder.encode(this.getFileName(), StandardCharsets.UTF_8).replace("+", "%20");
        return uriFilename;
    }
}

