/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.auth;

import fr.inra.agrosyst.api.services.users.AuthenticatedUser;
import fr.inra.agrosyst.api.services.users.UserService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuthenticatedUserJson
extends AbstractJsonAction {
    private static final Log LOGGER = LogFactory.getLog(AuthenticatedUserJson.class);
    private static final long serialVersionUID = 4566376502470233663L;
    protected transient UserService userService;

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public String execute() throws Exception {
        try {
            AuthenticatedUser loginResult = this.authenticationService.reloadAuthenticatedUser();
            if (this.authorizationService.isInMaintenanceMode() && !this.authorizationService.isAdminFromUserId(loginResult.getTopiaId())) {
                this.jsonData = this.authorizationService.getMaintenanceModeMessage();
                this.httpCode = 401;
                return "error";
            }
            this.applicationContext.writeAuthenticationCookie(loginResult, this.getCookieHelper());
            this.jsonData = loginResult;
            return "success";
        }
        catch (Exception e) {
            this.jsonData = "L'utilisateur n'est pas actif";
            this.httpCode = 401;
            return "error";
        }
    }
}

