/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web;

import com.opensymphony.xwork2.ActionContext;
import fr.inra.agrosyst.web.AgrosystWebApplicationContext;
import fr.inra.agrosyst.web.AgrosystWebConfig;
import fr.inra.agrosyst.web.actions.admin.RunImport;
import fr.inra.agrosyst.web.actions.commons.AttachmentsUploadJson;
import fr.inra.agrosyst.web.actions.domains.DomainsImportEdaplos;
import fr.inra.agrosyst.web.actions.domains.DomainsPreImportEdaplos;
import fr.inra.agrosyst.web.actions.security.UsersAndRolesImport;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.dispatcher.multipart.UploadedFile;
import org.apache.struts2.interceptor.ActionFileUploadInterceptor;

public class AgrosystWebFileUploadInterceptor
extends ActionFileUploadInterceptor {
    private static final long serialVersionUID = 1L;
    private static final Log LOGGER = LogFactory.getLog(AgrosystWebFileUploadInterceptor.class);

    protected boolean acceptFile(Object action, UploadedFile file, String filename, String contentType, String inputName) {
        Map application = ActionContext.getContext().getApplication();
        AgrosystWebApplicationContext applicationContext = (AgrosystWebApplicationContext)application.get(AgrosystWebApplicationContext.APPLICATION_CONTEXT_PARAMETER);
        AgrosystWebConfig config = applicationContext.getWebConfig();
        this.setMaximumSize(Long.valueOf(config.getUploadGlobalMaxSize()));
        if (action instanceof AttachmentsUploadJson) {
            this.setAllowedExtensions(config.getUploadAllowedExtensions());
            this.setMaximumSize(Long.valueOf(config.getUploadAttachmentsMaxSize()));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"AttachmentsUpload Upload, allowedTypesSet:");
            }
        } else if (action instanceof UsersAndRolesImport || action instanceof RunImport) {
            this.setAllowedExtensions("csv");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"UsersAndRolesImport,RunImport Upload");
            }
        } else if (action instanceof DomainsImportEdaplos || action instanceof DomainsPreImportEdaplos) {
            this.setAllowedExtensions("xml,zip");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"DomainsImportEdaplos Upload");
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Other Upload, allowedTypesSet");
        }
        boolean result = super.acceptFile(action, file, filename, contentType, inputName);
        return result;
    }
}

