/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web;

import fr.inra.agrosyst.web.AgrosystWebConfig;
import fr.inra.agrosyst.web.AgrosystWebDistributedCacheSupport;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AgrosystWebDistributedCacheSupport {
    private static final Log log = LogFactory.getLog(AgrosystWebDistributedCacheSupport.class);
    private static final int MAX_CACHE_EXPIRATION = 43200;
    private final CacheProvider instance;

    public AgrosystWebDistributedCacheSupport(AgrosystWebConfig webConfig) {
        if (webConfig.getHazelcastMembers().isPresent()) {
            log.info((Object)"D\u00e9marrage du cache distribu\u00e9");
            this.instance = new HazelcastCacheProvider(webConfig);
        } else {
            log.info((Object)"Pas de cache distribu\u00e9, on utilise une simple Map in-memory");
            this.instance = new InMemoryCacheProvider();
        }
    }

    public void shutdown() {
        this.instance.shutdown();
    }

    public <K, V> Map<K, V> getCache(String name) {
        Map result = this.instance.getCache(name);
        return result;
    }

    public <K, V> Map<K, V> getCacheWithExpiration(String name, int seconds) {
        Map result = this.instance.getCacheWithExpiration(name, seconds);
        return result;
    }
}

