/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.rest.attachments;

import fr.inra.agrosyst.api.services.common.AttachmentService;
import fr.inra.agrosyst.web.rest.CustomInject;
import fr.inra.agrosyst.web.rest.Secured;
import fr.inra.agrosyst.web.rest.attachments.AttachmentDto;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Secured
@Path(value="/attachments")
public class AttachmentsResource {
    @CustomInject
    private AttachmentService attachmentService;

    @GET
    @Produces(value={"application/json"})
    public Response readAll(@QueryParam(value="objectId") String objectId) {
        List<AttachmentDto> attachments = this.attachmentService.getAttachmentMetadatas(objectId).stream().map(a -> new AttachmentDto(a.getTopiaId(), a.getName(), a.getSize(), a.getAuthor().getFirstName() + " " + a.getAuthor().getLastName(), a.getTopiaCreateDate())).toList();
        return Response.ok().entity(attachments).build();
    }
}

