/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.practiced;

import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import fr.inra.agrosyst.api.entities.AbstractDomainInputStockUnit;
import fr.inra.agrosyst.api.entities.AgrosystInterventionType;
import fr.inra.agrosyst.api.entities.CropCyclePhaseType;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.Sector;
import fr.inra.agrosyst.api.entities.action.HarvestingAction;
import fr.inra.agrosyst.api.entities.action.HarvestingActionValorisation;
import fr.inra.agrosyst.api.entities.practiced.PracticedPerennialCropCycle;
import fr.inra.agrosyst.api.entities.practiced.PracticedSystem;
import fr.inra.agrosyst.api.entities.practiced.PracticedSystemImpl;
import fr.inra.agrosyst.api.entities.practiced.PracticedSystemSource;
import fr.inra.agrosyst.api.entities.referential.RefDestination;
import fr.inra.agrosyst.api.entities.referential.RefOrientationEDI;
import fr.inra.agrosyst.api.services.domain.CattleDto;
import fr.inra.agrosyst.api.services.domain.CroppingPlanSpeciesDto;
import fr.inra.agrosyst.api.services.domain.CroppingPlans;
import fr.inra.agrosyst.api.services.domain.inputStock.DomainInputStockUnitService;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemService;
import fr.inra.agrosyst.api.services.practiced.CropCycleModelDto;
import fr.inra.agrosyst.api.services.practiced.PracticedCropCycleConnectionDto;
import fr.inra.agrosyst.api.services.practiced.PracticedCropCycleNodeDto;
import fr.inra.agrosyst.api.services.practiced.PracticedCropCyclePhaseDto;
import fr.inra.agrosyst.api.services.practiced.PracticedInterventionDto;
import fr.inra.agrosyst.api.services.practiced.PracticedPerennialCropCycleDto;
import fr.inra.agrosyst.api.services.practiced.PracticedSeasonalCropCycleDto;
import fr.inra.agrosyst.api.services.practiced.PracticedSystemService;
import fr.inra.agrosyst.services.common.AgrosystI18nService;
import fr.inra.agrosyst.services.common.CommonService;
import fr.inra.agrosyst.web.actions.itk.AbstractItkAction;
import fr.inra.agrosyst.web.actions.practiced.PracticedSystemsEdit;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.Preparable;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;

@Results(value={@Result(name={"success"}, type="redirectAction", params={"namespace", "/practiced", "actionName", "practiced-systems-edit-input", "practicedSystemTopiaId", "${practicedSystemTopiaId}"}), @Result(name={"error"}, type="redirectAction", params={"namespace", "/practiced", "actionName", "practiced-systems-edit-input", "practicedSystemTopiaId", "${practicedSystemTopiaId}"})})
public class PracticedSystemsEdit
extends AbstractItkAction
implements Preparable {
    private static final Log LOGGER = LogFactory.getLog(PracticedSystemsEdit.class);
    private static final long serialVersionUID = -5696853256365484417L;
    public static final String UNKNOWN = "?";
    protected transient DomainInputStockUnitService domainInputStockUnitService;
    protected transient PracticedSystemService practicedSystemService;
    protected transient GrowingSystemService growingSystemService;
    protected String practicedSystemTopiaId;
    protected PracticedSystem practicedSystem;
    protected String domainId;
    protected String domainCode;
    protected Integer domainCampaign;
    protected Sector growingSystemSector;
    protected Boolean organic = null;
    protected String growingSystemTopiaId;
    private String defaultGrowingSystemId;
    protected String campaigns;
    private List<Integer> gsCampaigns;
    private List<PracticedPerennialCropCycleDto> practicedPerennialCropCycleDtos;
    private String practicedPerennialCropCycleDtosJson;
    private List<RefOrientationEDI> refOrientationEDIs;
    protected List<PracticedSeasonalCropCycleDto> practicedSeasonalCropCycleDtos;
    protected String practicedSeasonalCropCycleDtosJson;
    protected Map<String, List<CroppingPlanSpeciesDto>> practicedSystemCroppingPlanEntryCodesToSpecies;
    protected List<CropCycleModelDto> practicedSystemMainCropCycleModels;
    protected List<CropCycleModelDto> practicedSystemIntermediateCropCycleModels;
    protected Collection<CattleDto> cattles = new ArrayList();
    protected ImmutableSet<Integer> campaignsBeforeModification;

    public PracticedSystem getPracticedSystem() {
        return Objects.requireNonNullElseGet(this.practicedSystem, PracticedSystemImpl::new);
    }

    public void prepare() {
        if (StringUtils.isNotBlank((CharSequence)this.practicedSystemTopiaId)) {
            this.authorizationService.checkPracticedSystemReadable(this.practicedSystemTopiaId);
            this.practicedSystem = this.practicedSystemService.getPracticedSystem(this.practicedSystemTopiaId);
            String psGrowingSystemTopiaId = this.practicedSystem.getGrowingSystem().getTopiaId();
            if (StringUtils.isNotBlank((CharSequence)this.growingSystemTopiaId) && !psGrowingSystemTopiaId.contentEquals(this.growingSystemTopiaId)) {
                if ("NOT_FOUND".contentEquals(this.growingSystemTopiaId)) {
                    this.growingSystemTopiaId = psGrowingSystemTopiaId;
                }
                GrowingSystem growingSystem = this.growingSystemService.getGrowingSystem(this.growingSystemTopiaId);
                this.practicedSystem.setGrowingSystem(growingSystem);
                this.domainCampaign = growingSystem.getGrowingPlan().getDomain().getCampaign();
            }
            this.gsCampaigns = this.practicedSystemService.getGrowingSystemCampaignsFromId(this.practicedSystemTopiaId, this.getNavigationContext());
            String campaignsString = this.practicedSystem.getCampaigns();
            if (CommonService.getInstance().areCampaignsValids(campaignsString)) {
                this.campaignsBeforeModification = ImmutableSet.copyOf((Collection)((Collection)CommonService.GET_CAMPAIGNS_SET.apply(campaignsString)));
            }
            this.activated = this.practicedSystemService.isActivated(this.practicedSystem);
        } else {
            this.practicedSystem = new PracticedSystemImpl();
        }
    }

    @Action(value="practiced-systems-edit-input")
    public String input() {
        this.initForInput();
        this.loadPersistedCycles();
        return "input";
    }

    protected void loadPersistedCycles() {
        if (this.practicedSystem != null && this.practicedSystem.isPersisted()) {
            this.authorizationService.checkPracticedSystemReadable(this.practicedSystemTopiaId);
            boolean bl = this.readOnly = !this.authorizationService.isPracticedSystemWritable(this.practicedSystemTopiaId);
            if (this.readOnly) {
                this.notificationSupport.practicedSystemNotWritable();
            }
            this.practicedPerennialCropCycleDtos = this.practicedSystemService.getAllPracticedPerennialCropCycles(this.practicedSystemTopiaId);
            this.practicedSeasonalCropCycleDtos = this.practicedSystemService.getAllPracticedSeasonalCropCycles(this.practicedSystemTopiaId);
            this.warnEdaplosDestinationUsage();
            this.populateSeasonalCropCycles(this.practicedSeasonalCropCycleDtos);
        } else {
            this.practicedSeasonalCropCycleDtos = new ArrayList();
            this.practicedPerennialCropCycleDtos = new ArrayList();
        }
    }

    private void warnEdaplosDestinationUsage() {
        List nodeDtos = this.practicedSeasonalCropCycleDtos.stream().map(PracticedSeasonalCropCycleDto::getCropCycleNodeDtos).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
        List cropCycleConnectionDtos = this.practicedSeasonalCropCycleDtos.stream().map(PracticedSeasonalCropCycleDto::getCropCycleConnectionDtos).flatMap(Collection::stream).toList();
        Optional<String> eDaplosDefaultDestination = cropCycleConnectionDtos.stream().map(PracticedCropCycleConnectionDto::getInterventions).filter(Objects::nonNull).flatMap(Collection::stream).map(PracticedInterventionDto::getActionDtos).flatMap(Collection::stream).filter(action -> action instanceof HarvestingAction).filter(Objects::nonNull).map(action -> ((HarvestingAction)action).getValorisations()).flatMap(Collection::stream).filter(Objects::nonNull).map(HarvestingActionValorisation::getDestination).map(RefDestination::getDestination).filter("A compl\u00e9ter"::equals).findAny();
        ArrayList cropLabels = new ArrayList();
        if (eDaplosDefaultDestination.isPresent()) {
            ImmutableMap nodeDtoById = Maps.uniqueIndex(nodeDtos, PracticedCropCycleNodeDto::getNodeId);
            HashMap<Integer, ArrayList> cropNameByRank = new HashMap<Integer, ArrayList>();
            for (Object cropCycleConnectionDto : cropCycleConnectionDtos) {
                Optional<String> defaultDestination;
                if (CollectionUtils.isEmpty((Collection)cropCycleConnectionDto.getInterventions()) || !(defaultDestination = cropCycleConnectionDto.getInterventions().stream().filter(Objects::nonNull).map(PracticedInterventionDto::getActionDtos).flatMap(Collection::stream).filter(action -> action instanceof HarvestingAction).filter(Objects::nonNull).map(action -> ((HarvestingAction)action).getValorisations()).flatMap(Collection::stream).filter(Objects::nonNull).map(HarvestingActionValorisation::getDestination).map(RefDestination::getDestination).filter("A compl\u00e9ter"::equals).findAny()).isPresent()) continue;
                PracticedCropCycleNodeDto nodeDto = (PracticedCropCycleNodeDto)nodeDtoById.get(cropCycleConnectionDto.getTargetId());
                int rank = nodeDto.getX() + 1;
                ArrayList cropNamesForRank = cropNameByRank.computeIfAbsent(rank, k -> new ArrayList());
                String cropLabel = StringUtils.isNotBlank((CharSequence)cropCycleConnectionDto.getIntermediateCroppingPlanEntryCode()) ? String.format(cropCycleConnectionDto.getIntermediateCropName() + " (CI Rang %d) ", rank) : String.format(nodeDto.getLabel() + " (Rang %d) ", rank);
                cropNamesForRank.add(cropLabel);
            }
            if (!cropNameByRank.isEmpty()) {
                List odoredRank = cropNameByRank.keySet().stream().sorted(Integer::compareTo).toList();
                for (Integer rank : odoredRank) {
                    List cropNames = (List)cropNameByRank.get(rank);
                    cropNames.sort(String::compareTo);
                    cropLabels.addAll(cropNames);
                }
            }
        }
        ArrayList<String> perennialCropNames = new ArrayList<String>();
        for (PracticedPerennialCropCycleDto practicedPerennialCropCycleDto : this.practicedPerennialCropCycleDtos) {
            Optional<String> defaultDestination;
            if (CollectionUtils.isEmpty((Collection)practicedPerennialCropCycleDto.getCropCyclePhaseDtos()) || !(defaultDestination = practicedPerennialCropCycleDto.getCropCyclePhaseDtos().stream().map(PracticedCropCyclePhaseDto::getInterventions).filter(Objects::nonNull).flatMap(Collection::stream).map(PracticedInterventionDto::getActionDtos).flatMap(Collection::stream).filter(action -> action instanceof HarvestingAction).filter(Objects::nonNull).map(action -> ((HarvestingAction)action).getValorisations()).flatMap(Collection::stream).filter(Objects::nonNull).map(HarvestingActionValorisation::getDestination).map(RefDestination::getDestination).filter("A compl\u00e9ter"::equals).findAny()).isPresent()) continue;
            perennialCropNames.add(practicedPerennialCropCycleDto.getCroppingPlanEntryName());
        }
        if (!perennialCropNames.isEmpty()) {
            perennialCropNames.sort(String::compareTo);
            cropLabels.addAll(perennialCropNames);
        }
        if (!cropLabels.isEmpty()) {
            this.notificationSupport.warning(String.format("Vous avez une destination de r\u00e9colte import\u00e9e par d\u00e9faut depuis eDaplos, pour la culture %s. Merci de corriger cette destination ainsi que le rendement correspondant (valeur et unit\u00e9).", String.join((CharSequence)", ", cropLabels)), new Object[0]);
        }
    }

    protected void checkRights() {
        this.authorizationService.checkPracticedSystemReadable(this.practicedSystemTopiaId);
        boolean bl = this.readOnly = !this.authorizationService.isPracticedSystemWritable(this.practicedSystemTopiaId);
        if (this.readOnly) {
            this.notificationSupport.practicedSystemNotWritable();
        }
    }

    protected List<PracticedSeasonalCropCycleDto> loadPersistedSeasonalCycles(String practicedSystemTopiaId) {
        List<Object> practicedSeasonalCropCycleDtos;
        if (StringUtils.isNotBlank((CharSequence)practicedSystemTopiaId)) {
            this.checkRights();
            practicedSeasonalCropCycleDtos = this.practicedSystemService.getAllPracticedSeasonalCropCycles(practicedSystemTopiaId);
            this.populateSeasonalCropCycles(practicedSeasonalCropCycleDtos);
        } else {
            practicedSeasonalCropCycleDtos = new ArrayList<PracticedSeasonalCropCycleDto>();
        }
        return practicedSeasonalCropCycleDtos;
    }

    protected List<PracticedPerennialCropCycleDto> loadPersistedPerennialCycles(String practicedSystemTopiaId) {
        List<Object> practicedPerennialCropCycleDtos;
        if (StringUtils.isNotBlank((CharSequence)practicedSystemTopiaId)) {
            this.checkRights();
            practicedPerennialCropCycleDtos = this.practicedSystemService.getAllPracticedPerennialCropCycles(practicedSystemTopiaId);
        } else {
            practicedPerennialCropCycleDtos = new ArrayList<PracticedPerennialCropCycleDto>();
        }
        return practicedPerennialCropCycleDtos;
    }

    protected void populateSeasonalCropCycles(List<PracticedSeasonalCropCycleDto> practicedSeasonalCropCycleDtos) {
        if (this.practicedSystemIntermediateCropCycleModels != null && practicedSeasonalCropCycleDtos != null) {
            for (PracticedSeasonalCropCycleDto practicedSeasonalCropCycleDto : practicedSeasonalCropCycleDtos) {
                List connections = practicedSeasonalCropCycleDto.getCropCycleConnectionDtos();
                if (connections == null) continue;
                for (PracticedCropCycleConnectionDto connection : connections) {
                    String intermediateExpectedCode = connection.getIntermediateCroppingPlanEntryCode();
                    Object label = "";
                    if (StringUtils.isNotBlank((CharSequence)intermediateExpectedCode)) {
                        Optional<CropCycleModelDto> optional = this.practicedSystemIntermediateCropCycleModels.stream().filter(cropCycleVueModelDto -> intermediateExpectedCode.equals(cropCycleVueModelDto.getCroppingPlanEntryCode())).findAny();
                        if (optional.isPresent()) {
                            label = connection.getCroppingPlanEntryFrequency() != null ? connection.getCroppingPlanEntryFrequency().intValue() + "%<br/><span class='hover-infos'>" + optional.get().getLabel() + "</span>" : "<span class='hover-infos'>" + optional.get().getLabel() + "</span>";
                        }
                    } else if (connection.getCroppingPlanEntryFrequency() != null) {
                        label = (String)label + connection.getCroppingPlanEntryFrequency().intValue() + "%";
                    }
                    connection.setLabel((String)label);
                }
            }
        }
    }

    protected void initForInput() {
        PracticedSystem practicedSystem = this.getPracticedSystem();
        GrowingSystem growingSystem = null;
        if (practicedSystem.isPersisted()) {
            growingSystem = practicedSystem.getGrowingSystem();
        } else if (StringUtils.isNotBlank((CharSequence)this.growingSystemTopiaId)) {
            growingSystem = this.growingSystemService.getGrowingSystem(this.growingSystemTopiaId);
        }
        if (growingSystem != null) {
            this.growingSystemTopiaId = growingSystem.getTopiaId();
            this.growingSystemSector = growingSystem.getSector();
            this.organic = growingSystem.getTypeAgriculture() == null ? null : Boolean.valueOf(growingSystem.getTypeAgriculture().getReference_id() == 19948);
            Domain domain = growingSystem.getGrowingPlan().getDomain();
            this.domainCode = domain.getCode();
            this.domainCampaign = domain.getCampaign();
            this.domainId = domain.getTopiaId();
            this.campaigns = practicedSystem.getCampaigns() == null ? this.domainCampaign.toString() : practicedSystem.getCampaigns();
            this.cattles = this.practicedSystemService.getAllCampaignsPracticedSystemRelatedCattles(practicedSystem.getTopiaId(), (LinkedHashSet)CommonService.GET_CAMPAIGNS_SET.apply(this.campaigns));
        }
        this.refOrientationEDIs = this.referentialService.getAllReferentielEDI();
        if (!Strings.isNullOrEmpty((String)this.growingSystemTopiaId)) {
            Map modelToSpecies = this.practicedSystemService.getCropCycleModelMap(this.growingSystemTopiaId, true);
            Set croppingPlanEntryDtos = modelToSpecies.keySet();
            this.practicedSystemMainCropCycleModels = croppingPlanEntryDtos.stream().filter(CroppingPlans.IS_NOT_INTERMEDIATE).collect(Collectors.toList());
            this.practicedSystemIntermediateCropCycleModels = croppingPlanEntryDtos.stream().filter(CroppingPlans.IS_INTERMEDIATE).collect(Collectors.toList());
            this.practicedSystemCroppingPlanEntryCodesToSpecies = new HashMap();
            for (Map.Entry entry : modelToSpecies.entrySet()) {
                this.practicedSystemCroppingPlanEntryCodesToSpecies.put(((CropCycleModelDto)entry.getKey()).getCroppingPlanEntryCode(), (List)entry.getValue());
            }
        }
        super.initForInput();
    }

    public void validate() {
        Map domainInputStockUnitByIds;
        if (StringUtils.isBlank((CharSequence)this.getPracticedSystem().getTopiaId())) {
            this.validateGrowingSystemForNewPracticedSystem();
        } else {
            this.growingSystemTopiaId = this.getPracticedSystem().getGrowingSystem().getTopiaId();
        }
        Domain domain = null;
        if (StringUtils.isNotBlank((CharSequence)this.growingSystemTopiaId)) {
            GrowingSystem growingSystem = this.growingSystemService.getGrowingSystem(this.growingSystemTopiaId);
            domain = growingSystem.getGrowingPlan().getDomain();
            domainInputStockUnitByIds = this.domainInputStockUnitService.loadDomainInputStockByIds(domain);
        } else {
            domainInputStockUnitByIds = new HashMap();
        }
        if (this.practicedSystem.isPersisted() && !this.activated) {
            this.addActionError(this.getText("practicedSystem-error-inactive-action-message"));
        }
        if (StringUtils.isBlank((CharSequence)this.practicedSystem.getName())) {
            this.addFieldError("practicedSystem.name", this.getText("common.filedValue.required"));
            this.addActionError(this.getText("practicedSystem-error-name-action-message"));
        }
        boolean areValidcampaigns = this.validateCampaigns(this.practicedSystem);
        ArrayList requiredCropcycleCode = new ArrayList();
        Map allCodeEspeceBotaniqueCodeQualifantBySpeciesCode = null;
        Map allsectorByCodeEspceBotaniqueCodeQualifiant = null;
        if (areValidcampaigns) {
            allCodeEspeceBotaniqueCodeQualifantBySpeciesCode = this.getAllCodeEspeceBotaniqueCodeQualifantBySpeciesCode();
            allsectorByCodeEspceBotaniqueCodeQualifiant = this.getSectorByCodeEspceBotaniqueCodeQualifiant();
        }
        this.practicedPerennialCropCycleDtos = this.validatePerennialCropCycles(this.practicedSystemTopiaId, requiredCropcycleCode, this.practicedPerennialCropCycleDtosJson, allCodeEspeceBotaniqueCodeQualifantBySpeciesCode, allsectorByCodeEspceBotaniqueCodeQualifiant, domainInputStockUnitByIds);
        this.practicedSeasonalCropCycleDtos = this.validateSeasonalCropCycles(this.practicedSystemTopiaId, requiredCropcycleCode, this.practicedSeasonalCropCycleDtosJson, allCodeEspeceBotaniqueCodeQualifantBySpeciesCode, allsectorByCodeEspceBotaniqueCodeQualifiant, domainInputStockUnitByIds);
        this.validateSeriesOfCampaigns(areValidcampaigns, requiredCropcycleCode);
        this.validToolCouplingsOnInterventions();
        if (this.hasErrors()) {
            if (LOGGER.isErrorEnabled()) {
                String email = this.getAuthenticatedUser().getEmail();
                LOGGER.error((Object)String.format("For user email:" + email + " Pour le synth\u00e9tis\u00e9: %s", this.practicedSystemTopiaId == null ? "Nouveau" : this.practicedSystemTopiaId));
                LOGGER.error((Object)String.format("For user email:" + email + ":validate, action errors : growingSystemTopiaId:'%s', campaigns '%s' -> %s", this.growingSystemTopiaId, this.practicedSystem.getCampaigns(), this.getActionErrors().toString()));
                LOGGER.error((Object)String.format("For user email:" + email + ":validate, fields errors : growingSystemTopiaId:'%s', campaigns '%s' -> %s", this.growingSystemTopiaId, this.practicedSystem.getCampaigns(), this.getFieldErrors().toString()));
            }
            if (!(areValidcampaigns || domain == null && this.practicedSystem.getGrowingSystem() == null)) {
                int campaign = domain != null ? domain.getCampaign() : this.practicedSystem.getGrowingSystem().getGrowingPlan().getDomain().getCampaign();
                this.practicedSystem.setCampaigns(String.valueOf(campaign));
            }
            this.initForInput();
        }
    }

    protected Map<String, List<Sector>> getSectorByCodeEspceBotaniqueCodeQualifiant() {
        return this.practicedSystemService.getSectorByCodeEspceBotaniqueCodeQualifiant(this.growingSystemTopiaId, this.practicedSystem.getCampaigns());
    }

    protected Map<String, List<Pair<String, String>>> getAllCodeEspeceBotaniqueCodeQualifantBySpeciesCode() {
        return this.practicedSystemService.getAllCodeEspeceBotaniqueCodeQualifantBySpeciesCodeForDomainIds(this.growingSystemTopiaId, this.practicedSystem.getCampaigns());
    }

    protected void validateGrowingSystemForNewPracticedSystem() {
        if (StringUtils.isBlank((CharSequence)this.growingSystemTopiaId)) {
            this.addFieldError("growingSystemTopiaId", "Le syst\u00e8me de culture est requis !");
        }
    }

    private void validToolCouplingsOnInterventions() {
        List pInterventions;
        List sInterventions = this.practicedPerennialCropCycleDtos.stream().map(PracticedPerennialCropCycleDto::getCropCyclePhaseDtos).filter(Objects::nonNull).flatMap(Collection::stream).map(PracticedCropCyclePhaseDto::getInterventions).filter(Objects::nonNull).flatMap(Collection::stream).toList();
        if (CollectionUtils.union(sInterventions, pInterventions = this.practicedSeasonalCropCycleDtos.stream().map(PracticedSeasonalCropCycleDto::getCropCycleConnectionDtos).filter(Objects::nonNull).flatMap(Collection::stream).map(PracticedCropCycleConnectionDto::getInterventions).filter(Objects::nonNull).flatMap(Collection::stream).toList()).stream().anyMatch(intervention -> intervention.getToolsCouplingCodes().isEmpty())) {
            String text = this.getText("practicedSystem.itks.itk.intervention.missingToolsCouplings");
            this.notificationSupport.warning(text, new Object[0]);
        }
    }

    protected boolean validateCampaigns(PracticedSystem practicedSystem) {
        String campaigns = practicedSystem.getCampaigns();
        if (StringUtils.isBlank((CharSequence)campaigns)) {
            this.addFieldError("practicedSystem.campaigns", "La s\u00e9rie de campagne est obligatoire");
        }
        boolean validcampaigns = false;
        if (StringUtils.isNotBlank((CharSequence)campaigns) && !(validcampaigns = CommonService.getInstance().areCampaignsValids(campaigns))) {
            String format = "La s\u00e9rie de campagne doit \u00eatre compos\u00e9e d'ann\u00e9es s\u00e9par\u00e9es par des virgules (,), espaces ( ) ou point-virgules (;). Les campagnes doivent \u00eatre contenues entre %d et %d.";
            Pair bounds = CommonService.getInstance().getCampaignsBounds();
            this.addFieldError("practicedSystem.campaigns", String.format(format, bounds.getLeft(), bounds.getRight()));
        }
        return validcampaigns;
    }

    protected List<PracticedPerennialCropCycleDto> validatePerennialCropCycles(String practicedSystemTopiaId, List<String> requiredCropcycleCode, String practicedPerennialCropCycleDtosJson, Map<String, List<Pair<String, String>>> speciesCodeToCodeEspeceBotaniqueCodeQualifiantAee, Map<String, List<Sector>> sectorByCodeEspeceBotaniqueCodeQualifiant, Map<String, AbstractDomainInputStockUnit> domainInputStockUnitByIds) {
        List practicedPerennialCropCycleDtos = null;
        try {
            practicedPerennialCropCycleDtos = this.convertPracticedPerennialCropCycleDtosJson(practicedPerennialCropCycleDtosJson);
        }
        catch (Exception ex) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"failed to load json values for practicedPerennialCropCycleDtosJson", (Throwable)ex);
            }
            this.addActionError("Exception:" + String.valueOf(ex) + "\n/!\\ D\u00e9sol\u00e9 les donn\u00e9es saisies depuis votre dernier enregistrement concernant vos cycles de cultures p\u00e9rennes n'ont pu \u00eatre r\u00e9cup\u00e9r\u00e9es !");
        }
        if (practicedPerennialCropCycleDtos == null) {
            practicedPerennialCropCycleDtos = this.loadPersistedPerennialCycles(practicedSystemTopiaId);
        } else if (!practicedPerennialCropCycleDtos.isEmpty()) {
            double solOccupationPercent = 0.0;
            for (PracticedPerennialCropCycleDto practicedPerennialCropCycleDto : practicedPerennialCropCycleDtos) {
                String cropCycleCode;
                Double plantingDensity;
                PracticedPerennialCropCycle cropCycle = practicedPerennialCropCycleDto.getPracticedPerennialCropCycle();
                if (cropCycle.getSolOccupationPercent() < 0.0) {
                    this.addActionError("Le pourcentage dans la sole du SdC d'une culture p\u00e9renne ne peut \u00eatre n\u00e9gatif");
                }
                solOccupationPercent += cropCycle.getSolOccupationPercent();
                if (cropCycle.getWeedType() == null) {
                    this.addActionError("Un cycle de culture perenne doit avoir un type d'enherbement de s\u00e9lectionn\u00e9e");
                }
                if ((plantingDensity = cropCycle.getPlantingDensity()) != null && plantingDensity < 0.0) {
                    this.addActionError("Un cycle de culture p\u00e9renne doit avoir une densit\u00e9 de plantation positive");
                }
                if (Strings.isNullOrEmpty((String)(cropCycleCode = cropCycle.getCroppingPlanEntryCode()))) {
                    this.addActionError("Un cycle de culture p\u00e9renne doit avoir une culture de s\u00e9lectionn\u00e9e");
                    this.addFieldError("croppingPlanEntry", "Champ obligatoire");
                } else {
                    requiredCropcycleCode.add(cropCycleCode);
                }
                this.validatePhases(practicedPerennialCropCycleDto, speciesCodeToCodeEspeceBotaniqueCodeQualifiantAee, sectorByCodeEspeceBotaniqueCodeQualifiant, domainInputStockUnitByIds);
            }
            if (solOccupationPercent > 100.0) {
                this.addActionError("Le pourcentage dans la sole du SdC d'une culture p\u00e9renne ne peut \u00eatre > 100");
            }
            if (solOccupationPercent == 0.0) {
                this.addActionError("Le pourcentage dans la sole du SdC d'une culture p\u00e9renne ne peut \u00eatre \u00e9gal \u00e0 0");
            }
        }
        return practicedPerennialCropCycleDtos;
    }

    private void validatePhases(PracticedPerennialCropCycleDto practicedPerennialCropCycleDto, Map<String, List<Pair<String, String>>> speciesCodeToCodeEspeceBotaniqueCodeQualifiantAee, Map<String, List<Sector>> sectorByCodeEspceBotaniqueCodeQualifiant, Map<String, AbstractDomainInputStockUnit> domainInputStockUnitByIds) {
        List cropCyclePhaseDtos = practicedPerennialCropCycleDto.getCropCyclePhaseDtos();
        if (CollectionUtils.isEmpty((Collection)cropCyclePhaseDtos)) {
            this.addActionError("Un cycle de culture p\u00e9renne doit avoir une phase de pleine production");
        } else {
            this.validatePhasesTypes(cropCyclePhaseDtos);
            this.validatePhasesInterventions(practicedPerennialCropCycleDto, cropCyclePhaseDtos, speciesCodeToCodeEspeceBotaniqueCodeQualifiantAee, sectorByCodeEspceBotaniqueCodeQualifiant, domainInputStockUnitByIds);
        }
    }

    private void validatePhasesTypes(List<PracticedCropCyclePhaseDto> cropCyclePhaseDtos) {
        int instCount = 0;
        int montCount = 0;
        int pleiCount = 0;
        int declCount = 0;
        for (PracticedCropCyclePhaseDto cropCyclePhaseDto : cropCyclePhaseDtos) {
            if (cropCyclePhaseDto.getType() == null) continue;
            switch (3.$SwitchMap$fr$inra$agrosyst$api$entities$CropCyclePhaseType[cropCyclePhaseDto.getType().ordinal()]) {
                case 1: {
                    ++instCount;
                    break;
                }
                case 2: {
                    ++montCount;
                    break;
                }
                case 3: {
                    ++pleiCount;
                    break;
                }
                case 4: {
                    ++declCount;
                    break;
                }
            }
        }
        if (instCount > 1) {
            this.addActionError("Un cycle de culture p\u00e9renne ne peut avoir qu'une seule phase d'installation");
        }
        if (montCount > 1) {
            this.addActionError("Un cycle de culture p\u00e9renne ne peut avoir qu'une seule phase de mont\u00e9e en production");
        }
        if (pleiCount == 0) {
            this.addActionError("Un cycle de culture p\u00e9renne doit avoir une phase de pleine production");
        } else if (pleiCount > 1) {
            this.addActionError("Un cycle de culture p\u00e9renne ne peut avoir qu'une seule phase de pleine production");
        }
        if (declCount > 1) {
            this.addActionError("Un cycle de culture p\u00e9renne ne peut avoir qu'une seule phase de d\u00e9clin de production");
        }
    }

    private void validatePhasesInterventions(PracticedPerennialCropCycleDto practicedPerennialCropCycleDto, List<PracticedCropCyclePhaseDto> cropCyclePhaseDtos, Map<String, List<Pair<String, String>>> speciesCodeToCodeEspeceBotaniqueCodeQualifiantAee, Map<String, List<Sector>> sectorByCodeEspceBotaniqueCodeQualifiant, Map<String, AbstractDomainInputStockUnit> domainInputStockUnitByIds) {
        for (PracticedCropCyclePhaseDto cropCyclePhaseDto : cropCyclePhaseDtos) {
            this.validatePerennialInterventions(cropCyclePhaseDto, practicedPerennialCropCycleDto.getCroppingPlanEntryName(), cropCyclePhaseDto.getType(), speciesCodeToCodeEspeceBotaniqueCodeQualifiantAee, sectorByCodeEspceBotaniqueCodeQualifiant, domainInputStockUnitByIds);
        }
    }

    protected List<PracticedSeasonalCropCycleDto> validateSeasonalCropCycles(String practicedSystemTopiaId, List<String> requiredCropcycleCode, String practicedSeasonalCropCycleDtosJson, Map<String, List<Pair<String, String>>> speciesCodeToCodeEspeceBotaniqueCodeQualifiantAee, Map<String, List<Sector>> sectorByCodeEspceBotaniqueCodeQualifiant, Map<String, AbstractDomainInputStockUnit> domainInputStockUnitByIds) {
        List practicedSeasonalCropCycleDtos = null;
        try {
            practicedSeasonalCropCycleDtos = this.convertPracticedSeasonalCropCycleDtosJson(practicedSeasonalCropCycleDtosJson);
        }
        catch (Exception ex) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"failed to load json values for practicedSeasonalCropCycleDtosJson", (Throwable)ex);
            }
            this.addActionError("Exception:" + String.valueOf(ex) + "\n/!\\ D\u00e9sol\u00e9 les donn\u00e9es saisies depuis votre dernier enregistrement concernant vos cycles de cultures saisonniers n'ont pu \u00eatre r\u00e9cup\u00e9r\u00e9es !");
        }
        if (practicedSeasonalCropCycleDtos == null) {
            practicedSeasonalCropCycleDtos = this.loadPersistedSeasonalCycles(practicedSystemTopiaId);
        } else if (!practicedSeasonalCropCycleDtos.isEmpty()) {
            PracticedSeasonalCropCycleDto practicedSeasonalCropCycleDto;
            Map nodesById;
            Iterator iterator = practicedSeasonalCropCycleDtos.iterator();
            while (iterator.hasNext() && (nodesById = this.validateNodes(requiredCropcycleCode, practicedSeasonalCropCycleDto = (PracticedSeasonalCropCycleDto)iterator.next())) != null) {
                this.validateConnections(practicedSeasonalCropCycleDto, nodesById, speciesCodeToCodeEspeceBotaniqueCodeQualifiantAee, sectorByCodeEspceBotaniqueCodeQualifiant, domainInputStockUnitByIds);
            }
        }
        return practicedSeasonalCropCycleDtos;
    }

    private Map<String, PracticedCropCycleNodeDto> validateNodes(List<String> requiredCropcycleCode, PracticedSeasonalCropCycleDto practicedSeasonalCropCycleDto) {
        HashMap<String, PracticedCropCycleNodeDto> nodesById = new HashMap<String, PracticedCropCycleNodeDto>();
        Integer firstRank = null;
        List cropCycleNodeDtos = practicedSeasonalCropCycleDto.getCropCycleNodeDtos();
        if (CollectionUtils.isNotEmpty((Collection)cropCycleNodeDtos)) {
            ArrayList<PracticedCropCycleNodeDto> nullFrequencyNodes = new ArrayList<PracticedCropCycleNodeDto>();
            double sum = 0.0;
            for (PracticedCropCycleNodeDto cropCycleNodeDto : cropCycleNodeDtos) {
                nodesById.put(cropCycleNodeDto.getNodeId(), cropCycleNodeDto);
                firstRank = firstRank == null ? cropCycleNodeDto.getX() : (firstRank < cropCycleNodeDto.getX() ? firstRank.intValue() : cropCycleNodeDto.getX());
                if (cropCycleNodeDto.getX() == 0) {
                    if (cropCycleNodeDto.getInitNodeFrequency() == null) {
                        nullFrequencyNodes.add(cropCycleNodeDto);
                    } else {
                        sum += cropCycleNodeDto.getInitNodeFrequency().doubleValue();
                    }
                }
                requiredCropcycleCode.add(cropCycleNodeDto.getCroppingPlanEntryCode());
            }
            if (firstRank == null || firstRank != 0) {
                this.addActionError("Le premier noeud doit se situer sur le premier rang");
            }
            if (sum > 100.0) {
                this.addActionError("La somme des fr\u00e9quences initiales des cultures de rang 1 d\u00e9passent 100%");
                return null;
            }
            double remaining = 100.0 - sum;
            if (!nullFrequencyNodes.isEmpty() && remaining > 0.0) {
                int size = nullFrequencyNodes.size();
                for (PracticedCropCycleNodeDto connection : nullFrequencyNodes) {
                    double value = remaining / (double)size;
                    value = Math.floor(value * 100.0) / 100.0;
                    connection.setInitNodeFrequency(Double.valueOf(value));
                }
            }
        }
        return nodesById;
    }

    private void validateConnections(PracticedSeasonalCropCycleDto practicedSeasonalCropCycleDto, Map<String, PracticedCropCycleNodeDto> nodesById, Map<String, List<Pair<String, String>>> speciesCodeToCodeEspeceBotaniqueCodeQualifiantAee, Map<String, List<Sector>> sectorByCodeEspceBotaniqueCodeQualifiant, Map<String, AbstractDomainInputStockUnit> domainInputStockUnitByIds) {
        List cropCycleConnectionDtos = practicedSeasonalCropCycleDto.getCropCycleConnectionDtos();
        if (CollectionUtils.isNotEmpty((Collection)cropCycleConnectionDtos)) {
            HashMultimap connectionsBySource = HashMultimap.create();
            for (PracticedCropCycleConnectionDto cropCycleConnectionDto : cropCycleConnectionDtos) {
                PracticedCropCycleNodeDto source = nodesById.get(cropCycleConnectionDto.getSourceId());
                PracticedCropCycleNodeDto target = nodesById.get(cropCycleConnectionDto.getTargetId());
                this.validateNodeSourceTarget(source, target);
                this.validateSeasonalInterventions(cropCycleConnectionDto, target.getLabel(), source.getLabel(), target.getX() + 1, speciesCodeToCodeEspeceBotaniqueCodeQualifiantAee, sectorByCodeEspceBotaniqueCodeQualifiant, domainInputStockUnitByIds);
                connectionsBySource.put((Object)cropCycleConnectionDto.getSourceId(), (Object)cropCycleConnectionDto);
            }
            this.validateConnectionFrequencies((Multimap)connectionsBySource, nodesById);
        }
    }

    private void validateNodeSourceTarget(PracticedCropCycleNodeDto source, PracticedCropCycleNodeDto target) {
        if (source.getX() == target.getX()) {
            this.addActionError("Deux noeuds reli\u00e9s entre eux ne peuvent \u00eatre sur le m\u00eame rang");
        } else if (source.getX() > target.getX()) {
            if (!source.isEndCycle()) {
                this.addActionError("Un retour sur cycle ne peut-\u00eatre cr\u00e9\u00e9 qu'\u00e0 partir d'un noeud fin de cycle");
            }
            if (target.getX() != 0) {
                this.addActionError("Un retour sur cycle ne peut se faire que sur le premier noeud du cycle");
            }
        }
    }

    protected void validateSeriesOfCampaigns(boolean areCurrentCampaignsAreValid, List<String> requiredCropCycleCodes) {
        if (this.growingSystemTopiaId != null && areCurrentCampaignsAreValid) {
            String campaigns = this.practicedSystem.getCampaigns();
            List availableCroppingPlanCodes = this.getCropCodesForCampaigns();
            boolean allCropCycleFound = new HashSet(availableCroppingPlanCodes).containsAll(requiredCropCycleCodes);
            if (!allCropCycleFound) {
                if (StringUtils.isBlank((CharSequence)this.practicedSystemTopiaId)) {
                    this.addActionError("Cette s\u00e9rie de campagne n'est pas valide pour ce syst\u00e8me synth\u00e9tis\u00e9 car vous avez supprim\u00e9 une campagne dont vous utilisez des \u00e9l\u00e9ments (ex. : les cultures, les mat\u00e9riels) dans le dessin de la rotation, la description des cultures p\u00e9rennes ou les itin\u00e9raires techniques.");
                    this.addFieldError("practicedSystem.campaigns", "S\u00e9rie de campagnes agricoles %s non valide, pr\u00e9c\u00e9dente s\u00e9rie %s !");
                } else {
                    Set userSetCampaigns = (Set)CommonService.GET_CAMPAIGNS_SET.apply(campaigns);
                    String removedCampaigns = UNKNOWN;
                    int nbCampaignRemoved = 0;
                    if (this.campaignsBeforeModification != null) {
                        LinkedHashSet previousCampaigns = new LinkedHashSet(this.campaignsBeforeModification);
                        nbCampaignRemoved = previousCampaigns.size();
                        previousCampaigns.removeAll(userSetCampaigns);
                        removedCampaigns = (String)CommonService.ARRANGE_CAMPAIGNS_SET.apply(previousCampaigns);
                    }
                    String pluralise = nbCampaignRemoved > 1 ? "les campagnes" : "la campagne";
                    String pluralise1 = nbCampaignRemoved > 1 ? "les campagnes supprim\u00e9es sont :" : "la campagne supprim\u00e9e est :";
                    this.addActionError(String.format("Cette s\u00e9rie de campagne '%s' n'est pas valide pour ce syst\u00e8me synth\u00e9tis\u00e9 car vous avez supprim\u00e9 %s '%s' dont vous utilisez des \u00e9l\u00e9ments (ex. : les cultures, les mat\u00e9riels) dans le dessin de la rotation, la description des cultures p\u00e9rennes ou les itin\u00e9raires techniques.", campaigns, pluralise, removedCampaigns));
                    this.addFieldError("practicedSystem.campaigns", String.format("S\u00e9rie de campagnes agricoles '%s' non valide, %s '%s' !", campaigns, pluralise1, removedCampaigns));
                }
            }
        }
    }

    protected List<String> getCropCodesForCampaigns() {
        return this.practicedSystemService.getCropCodesFromGrowingSystemIdForCampaigns(this.growingSystemTopiaId, this.practicedSystem.getCampaigns());
    }

    protected void validateSeasonalInterventions(PracticedCropCycleConnectionDto cropCycleConnectionDto, String cropLabel, String previousCropLabel, int cropRank, Map<String, List<Pair<String, String>>> speciesCodeToCodeEspeceBotaniqueCodeQualifiantAee, Map<String, List<Sector>> sectorByCodeEspceBotaniqueCodeQualifiant, Map<String, AbstractDomainInputStockUnit> domainInputStockUnitByIds) {
        List interventionDtos = cropCycleConnectionDto.getInterventions();
        String interventionGeneralInfos = String.format("sur la culture assol\u00e9e '%s' pr\u00e9cedent '%s' (Rang %d)", Strings.nullToEmpty((String)cropLabel), Strings.nullToEmpty((String)previousCropLabel), cropRank);
        this.validateInterventions(interventionDtos, interventionGeneralInfos, speciesCodeToCodeEspeceBotaniqueCodeQualifiantAee, sectorByCodeEspceBotaniqueCodeQualifiant, domainInputStockUnitByIds);
    }

    protected void validatePerennialInterventions(PracticedCropCyclePhaseDto cropCyclePhaseDto, String cropLabel, CropCyclePhaseType phaseType, Map<String, List<Pair<String, String>>> speciesCodeToCodeEspeceBotaniqueCodeQualifiantAee, Map<String, List<Sector>> sectorByCodeEspceBotaniqueCodeQualifiant, Map<String, AbstractDomainInputStockUnit> domainInputStockUnitByIds) {
        List interventionDtos = cropCyclePhaseDto.getInterventions();
        String interventionGeneralInfos = String.format("sur la culture p\u00e9renne '%s' (%s)", Strings.nullToEmpty((String)cropLabel), phaseType != null ? AgrosystI18nService.getEnumTraductionWithDefaultLocale((Object)phaseType) : "");
        this.validateInterventions(interventionDtos, interventionGeneralInfos, speciesCodeToCodeEspeceBotaniqueCodeQualifiantAee, sectorByCodeEspceBotaniqueCodeQualifiant, domainInputStockUnitByIds);
    }

    protected void validateInterventions(List<PracticedInterventionDto> interventionDtos, String interventionContextInfo, Map<String, List<Pair<String, String>>> speciesCodeToCodeEspeceBotaniqueCodeQualifiantAee, Map<String, List<Sector>> sectorByCodeEsepceBotaniqueCodeQualifiant, Map<String, AbstractDomainInputStockUnit> domainInputStockUnitByIds) {
        if (CollectionUtils.isNotEmpty(interventionDtos)) {
            boolean validCampaigns;
            String campaigns = this.practicedSystem.getCampaigns();
            boolean isToolsCouplingsCodeLoadable = false;
            if (StringUtils.isNotBlank((CharSequence)this.growingSystemTopiaId) && StringUtils.isNotBlank((CharSequence)campaigns) && (validCampaigns = CommonService.getInstance().areCampaignsValids(campaigns))) {
                isToolsCouplingsCodeLoadable = true;
            }
            List availableToolsCouplingCodes = isToolsCouplingsCodeLoadable ? this.practicedSystemService.getToolsCouplingsFromGrowingSystemAndCampaigns(this.growingSystemTopiaId, campaigns) : Lists.newArrayListWithCapacity((int)0);
            for (PracticedInterventionDto interventionDto : interventionDtos) {
                ArrayList<String> interventionErrorMessages = new ArrayList<String>();
                if (interventionDto.getToolsCouplingCodes() != null && !new HashSet(availableToolsCouplingCodes).containsAll(interventionDto.getToolsCouplingCodes())) {
                    interventionErrorMessages.add(String.format("- Les combinaisons d'outils s\u00e9lectionn\u00e9es n'existent pas pour la s\u00e9rie de campagnes agricoles '%s' ", campaigns));
                }
                if (Strings.isNullOrEmpty((String)interventionDto.getName())) {
                    interventionErrorMessages.add("- Renseigner le nom de l'intervention");
                }
                if (interventionDto.getType() == null) {
                    interventionErrorMessages.add("- Renseigner le type de l'intervention");
                }
                if (Strings.isNullOrEmpty((String)interventionDto.getStartingPeriodDate())) {
                    interventionErrorMessages.add("- Renseigner la date de d\u00e9but de l'intervention");
                }
                if (Strings.isNullOrEmpty((String)interventionDto.getEndingPeriodDate())) {
                    interventionErrorMessages.add("- Renseigner la date de fin de l'intervention");
                }
                Collection actionDtos = interventionDto.getActionDtos();
                List actionDtoValidationResult = this.actionService.validActionDtosAndUsages(actionDtos, domainInputStockUnitByIds, speciesCodeToCodeEspeceBotaniqueCodeQualifiantAee, sectorByCodeEsepceBotaniqueCodeQualifiant, interventionDto.getSpeciesStadesDtos(), interventionDto.isIntermediateCrop());
                interventionErrorMessages.addAll(actionDtoValidationResult);
                if (CollectionUtils.isNotEmpty((Collection)actionDtoValidationResult)) {
                    String interventionName = StringUtils.isBlank((CharSequence)interventionDto.getName()) ? UNKNOWN : interventionDto.getName();
                    String interventionGeneralInfos = String.format("Intervention '%s' %s&nbsp:<br>", interventionName, interventionContextInfo);
                    String messages = StringUtils.join(interventionErrorMessages, (String)"<br>");
                    this.addActionError(interventionGeneralInfos + messages);
                    continue;
                }
                if (interventionErrorMessages.isEmpty()) continue;
                String messages = StringUtils.join(interventionErrorMessages, (String)"<br>");
                this.addActionError(messages);
            }
        }
    }

    private void validateConnectionFrequencies(Multimap<String, PracticedCropCycleConnectionDto> connectionsBySource, Map<String, PracticedCropCycleNodeDto> nodesById) {
        for (String source : connectionsBySource.keySet()) {
            Collection connections = connectionsBySource.get((Object)source);
            List<PracticedCropCycleConnectionDto> noFrequencyConnections = connections.stream().filter(practicedCropCycleConnectionDto -> practicedCropCycleConnectionDto.getCroppingPlanEntryFrequency() == null).toList();
            double sum = 0.0;
            for (PracticedCropCycleConnectionDto connection : connections) {
                Double freq = connection.getCroppingPlanEntryFrequency();
                if (freq == null) continue;
                sum += freq.doubleValue();
            }
            double remaining = 100.0 - sum;
            if (!noFrequencyConnections.isEmpty() && remaining > 0.0) {
                int size = noFrequencyConnections.size();
                double totalValue = 0.0;
                double value = remaining / (double)size;
                value = Math.floor(value * 100.0) / 100.0;
                for (int i = 0; i <= size - 2; ++i) {
                    PracticedCropCycleConnectionDto connection = noFrequencyConnections.get(i);
                    connection.setCroppingPlanEntryFrequency(Double.valueOf(value));
                    totalValue += value;
                }
                PracticedCropCycleConnectionDto lastConnection = noFrequencyConnections.get(size - 1);
                lastConnection.setCroppingPlanEntryFrequency(Double.valueOf(100.0 - totalValue));
                remaining = 0.0;
            }
            if (!(remaining > 1.0) && !(remaining < -1.0)) continue;
            PracticedCropCycleNodeDto sourceNode = nodesById.get(source);
            this.addActionError("La somme des fr\u00e9quences des connexions sortantes pour la culture '" + sourceNode.getLabel() + "' doit \u00eatre \u00e9gale \u00e0 100%");
        }
    }

    public String execute() throws Exception {
        PracticedSystem practicedSystem = this.getPracticedSystem();
        if (StringUtils.isBlank((CharSequence)practicedSystem.getTopiaId())) {
            GrowingSystem growingSystem = this.getGrowingSystemForNewPracticedSystem();
            this.getPracticedSystem().setGrowingSystem(growingSystem);
        }
        this.removeEmptySeasonalCropCycle();
        if (this.practicedSystemService.isConnectionMissingInCropCycles((Collection)this.practicedSeasonalCropCycleDtos)) {
            this.notificationSupport.warning("Une ou plusieurs connexions ont \u00e9t\u00e9 cr\u00e9\u00e9es \u00e0 l'enregistrement pour boucler votre rotation.", new Object[0]);
        }
        practicedSystem = this.practicedSystemService.createOrUpdatePracticedSystem(practicedSystem, this.practicedPerennialCropCycleDtos, this.practicedSeasonalCropCycleDtos);
        this.setPracticedSystemTopiaId(practicedSystem.getTopiaId());
        this.notificationSupport.practicedSystemSaved(practicedSystem);
        return "success";
    }

    protected GrowingSystem getGrowingSystemForNewPracticedSystem() {
        return this.growingSystemService.getGrowingSystem(this.growingSystemTopiaId);
    }

    protected void removeEmptySeasonalCropCycle() {
        if (this.practicedSeasonalCropCycleDtos != null && !this.practicedSeasonalCropCycleDtos.isEmpty()) {
            ArrayList pseccCopy = Lists.newArrayList((Iterable)this.practicedSeasonalCropCycleDtos);
            for (PracticedSeasonalCropCycleDto practicedSeasonalCropCycleDto : pseccCopy) {
                if (practicedSeasonalCropCycleDto.getCropCycleNodeDtos() != null && !practicedSeasonalCropCycleDto.getCropCycleNodeDtos().isEmpty()) continue;
                this.practicedSeasonalCropCycleDtos.remove(practicedSeasonalCropCycleDto);
            }
        }
    }

    protected List<PracticedPerennialCropCycleDto> convertPracticedPerennialCropCycleDtosJson(String json) {
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        return (List)this.getGson().fromJson(json, type);
    }

    protected List<PracticedSeasonalCropCycleDto> convertPracticedSeasonalCropCycleDtosJson(String json) {
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        return (List)this.getGson().fromJson(json, type);
    }

    public Map<PracticedSystemSource, String> getSources() {
        return this.getEnumAsMap((Object[])PracticedSystemSource.values());
    }

    public String getCampaigns() {
        String result = "";
        if (this.practicedSystem != null) {
            result = this.practicedSystem.getCampaigns();
        }
        return this.getGson().toJson((Object)result);
    }

    public Map<AgrosystInterventionType, String> getAgrosystInterventionTypes() {
        return this.referentialService.getAgrosystInterventionTypeTranslationMap();
    }

    @Generated
    public DomainInputStockUnitService getDomainInputStockUnitService() {
        return this.domainInputStockUnitService;
    }

    @Generated
    public PracticedSystemService getPracticedSystemService() {
        return this.practicedSystemService;
    }

    @Generated
    public GrowingSystemService getGrowingSystemService() {
        return this.growingSystemService;
    }

    @Generated
    public String getPracticedSystemTopiaId() {
        return this.practicedSystemTopiaId;
    }

    @Generated
    public String getDomainId() {
        return this.domainId;
    }

    @Generated
    public String getDomainCode() {
        return this.domainCode;
    }

    @Generated
    public Integer getDomainCampaign() {
        return this.domainCampaign;
    }

    @Generated
    public Sector getGrowingSystemSector() {
        return this.growingSystemSector;
    }

    @Generated
    public Boolean getOrganic() {
        return this.organic;
    }

    @Generated
    public String getGrowingSystemTopiaId() {
        return this.growingSystemTopiaId;
    }

    @Generated
    public String getDefaultGrowingSystemId() {
        return this.defaultGrowingSystemId;
    }

    @Generated
    public List<Integer> getGsCampaigns() {
        return this.gsCampaigns;
    }

    @Generated
    public List<PracticedPerennialCropCycleDto> getPracticedPerennialCropCycleDtos() {
        return this.practicedPerennialCropCycleDtos;
    }

    @Generated
    public String getPracticedPerennialCropCycleDtosJson() {
        return this.practicedPerennialCropCycleDtosJson;
    }

    @Generated
    public List<RefOrientationEDI> getRefOrientationEDIs() {
        return this.refOrientationEDIs;
    }

    @Generated
    public List<PracticedSeasonalCropCycleDto> getPracticedSeasonalCropCycleDtos() {
        return this.practicedSeasonalCropCycleDtos;
    }

    @Generated
    public String getPracticedSeasonalCropCycleDtosJson() {
        return this.practicedSeasonalCropCycleDtosJson;
    }

    @Generated
    public Map<String, List<CroppingPlanSpeciesDto>> getPracticedSystemCroppingPlanEntryCodesToSpecies() {
        return this.practicedSystemCroppingPlanEntryCodesToSpecies;
    }

    @Generated
    public List<CropCycleModelDto> getPracticedSystemMainCropCycleModels() {
        return this.practicedSystemMainCropCycleModels;
    }

    @Generated
    public List<CropCycleModelDto> getPracticedSystemIntermediateCropCycleModels() {
        return this.practicedSystemIntermediateCropCycleModels;
    }

    @Generated
    public Collection<CattleDto> getCattles() {
        return this.cattles;
    }

    @Generated
    public ImmutableSet<Integer> getCampaignsBeforeModification() {
        return this.campaignsBeforeModification;
    }

    @Generated
    public void setDomainInputStockUnitService(DomainInputStockUnitService domainInputStockUnitService) {
        this.domainInputStockUnitService = domainInputStockUnitService;
    }

    @Generated
    public void setPracticedSystemService(PracticedSystemService practicedSystemService) {
        this.practicedSystemService = practicedSystemService;
    }

    @Generated
    public void setGrowingSystemService(GrowingSystemService growingSystemService) {
        this.growingSystemService = growingSystemService;
    }

    @Generated
    public void setPracticedSystemTopiaId(String practicedSystemTopiaId) {
        this.practicedSystemTopiaId = practicedSystemTopiaId;
    }

    @Generated
    public void setPracticedSystem(PracticedSystem practicedSystem) {
        this.practicedSystem = practicedSystem;
    }

    @Generated
    public void setDomainId(String domainId) {
        this.domainId = domainId;
    }

    @Generated
    public void setDomainCode(String domainCode) {
        this.domainCode = domainCode;
    }

    @Generated
    public void setDomainCampaign(Integer domainCampaign) {
        this.domainCampaign = domainCampaign;
    }

    @Generated
    public void setGrowingSystemSector(Sector growingSystemSector) {
        this.growingSystemSector = growingSystemSector;
    }

    @Generated
    public void setOrganic(Boolean organic) {
        this.organic = organic;
    }

    @Generated
    public void setGrowingSystemTopiaId(String growingSystemTopiaId) {
        this.growingSystemTopiaId = growingSystemTopiaId;
    }

    @Generated
    public void setDefaultGrowingSystemId(String defaultGrowingSystemId) {
        this.defaultGrowingSystemId = defaultGrowingSystemId;
    }

    @Generated
    public void setCampaigns(String campaigns) {
        this.campaigns = campaigns;
    }

    @Generated
    public void setGsCampaigns(List<Integer> gsCampaigns) {
        this.gsCampaigns = gsCampaigns;
    }

    @Generated
    public void setPracticedPerennialCropCycleDtos(List<PracticedPerennialCropCycleDto> practicedPerennialCropCycleDtos) {
        this.practicedPerennialCropCycleDtos = practicedPerennialCropCycleDtos;
    }

    @Generated
    public void setPracticedPerennialCropCycleDtosJson(String practicedPerennialCropCycleDtosJson) {
        this.practicedPerennialCropCycleDtosJson = practicedPerennialCropCycleDtosJson;
    }

    @Generated
    public void setRefOrientationEDIs(List<RefOrientationEDI> refOrientationEDIs) {
        this.refOrientationEDIs = refOrientationEDIs;
    }

    @Generated
    public void setPracticedSeasonalCropCycleDtos(List<PracticedSeasonalCropCycleDto> practicedSeasonalCropCycleDtos) {
        this.practicedSeasonalCropCycleDtos = practicedSeasonalCropCycleDtos;
    }

    @Generated
    public void setPracticedSeasonalCropCycleDtosJson(String practicedSeasonalCropCycleDtosJson) {
        this.practicedSeasonalCropCycleDtosJson = practicedSeasonalCropCycleDtosJson;
    }

    @Generated
    public void setPracticedSystemCroppingPlanEntryCodesToSpecies(Map<String, List<CroppingPlanSpeciesDto>> practicedSystemCroppingPlanEntryCodesToSpecies) {
        this.practicedSystemCroppingPlanEntryCodesToSpecies = practicedSystemCroppingPlanEntryCodesToSpecies;
    }

    @Generated
    public void setPracticedSystemMainCropCycleModels(List<CropCycleModelDto> practicedSystemMainCropCycleModels) {
        this.practicedSystemMainCropCycleModels = practicedSystemMainCropCycleModels;
    }

    @Generated
    public void setPracticedSystemIntermediateCropCycleModels(List<CropCycleModelDto> practicedSystemIntermediateCropCycleModels) {
        this.practicedSystemIntermediateCropCycleModels = practicedSystemIntermediateCropCycleModels;
    }

    @Generated
    public void setCattles(Collection<CattleDto> cattles) {
        this.cattles = cattles;
    }

    @Generated
    public void setCampaignsBeforeModification(ImmutableSet<Integer> campaignsBeforeModification) {
        this.campaignsBeforeModification = campaignsBeforeModification;
    }
}

