/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.managementmodes;

import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.BioAgressorType;
import fr.inra.agrosyst.api.entities.CroppingPlanEntry;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.Sector;
import fr.inra.agrosyst.api.entities.TypeDEPHY;
import fr.inra.agrosyst.api.entities.managementmode.DecisionRule;
import fr.inra.agrosyst.api.entities.managementmode.ManagementMode;
import fr.inra.agrosyst.api.entities.managementmode.ManagementModeCategory;
import fr.inra.agrosyst.api.entities.managementmode.ManagementModeImpl;
import fr.inra.agrosyst.api.entities.managementmode.SectionType;
import fr.inra.agrosyst.api.entities.referential.RefStrategyLever;
import fr.inra.agrosyst.api.services.common.HistoryItem;
import fr.inra.agrosyst.api.services.common.HistoryType;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemFilter;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemService;
import fr.inra.agrosyst.api.services.managementmode.ManagementModeService;
import fr.inra.agrosyst.api.services.managementmode.ManagementModes;
import fr.inra.agrosyst.api.services.managementmode.SectionDto;
import fr.inra.agrosyst.api.services.managementmode.StrategyDto;
import fr.inra.agrosyst.api.services.referential.GroupeCibleDTO;
import fr.inra.agrosyst.api.services.referential.ReferentialService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;
import fr.inra.agrosyst.web.actions.managementmodes.ManagementModesEdit;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.Preparable;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.nuiton.i18n.I18n;

public class ManagementModesEdit
extends AbstractAgrosystAction
implements Preparable {
    private static final long serialVersionUID = -2688592598121764478L;
    private static final Log LOGGER = LogFactory.getLog(ManagementModesEdit.class);
    protected static final String DATE_FORMAT = "dd/MM/yyyy";
    protected static final int HISTORY_SIZE_LIMIT = 100;
    protected transient ManagementModeService managementModeService;
    protected transient GrowingSystemService growingSystemService;
    protected transient ReferentialService referentialService;
    protected String managementModeTopiaId;
    protected ManagementMode managementMode;
    protected List<GrowingSystem> growingSystems;
    protected Sector growingSystemsSector;
    protected String domainTopiaId;
    protected String growingSystemTopiaId;
    protected List<SectionDto> sections;
    protected String sectionsJson;
    protected List<GroupeCibleDTO> groupesCibles;
    protected List<CroppingPlanEntry> croppingPlanEntries;
    protected Collection<DecisionRule> decisionRules;
    protected List<ManagementMode> relatedManagementModes;
    protected List<ManagementModeCategory> availableManagementModeCategories;
    protected List<String> histories = new ArrayList();
    protected ManagementModeCategory managementModeCategory;
    protected TypeDEPHY typeDEPHY;

    public void setManagementModeService(ManagementModeService managementModeService) {
        this.managementModeService = managementModeService;
    }

    public void setGrowingSystemService(GrowingSystemService growingSystemService) {
        this.growingSystemService = growingSystemService;
    }

    public void setReferentialService(ReferentialService referentialService) {
        this.referentialService = referentialService;
    }

    public ManagementMode getManagementMode() {
        return Objects.requireNonNullElseGet(this.managementMode, ManagementModeImpl::new);
    }

    public void prepare() {
        this.managementMode = StringUtils.isEmpty((CharSequence)this.managementModeTopiaId) ? this.managementModeService.newManagementMode() : this.managementModeService.getManagementMode(this.managementModeTopiaId);
        if (this.managementMode.isPersisted()) {
            GrowingSystem growingSystem = this.managementMode.getGrowingSystem();
            this.activated = this.managementMode.isActive() && growingSystem.isActive() && growingSystem.getGrowingPlan().isActive() && growingSystem.getGrowingPlan().getDomain().isActive();
            this.typeDEPHY = growingSystem.getGrowingPlan().getType();
        }
    }

    @Action(value="management-modes-edit-input")
    public String input() {
        if (!Strings.isNullOrEmpty((String)this.managementModeTopiaId)) {
            this.authorizationService.checkManagementModeReadable(this.managementModeTopiaId);
            boolean bl = this.readOnly = !this.authorizationService.isManagementModeWritable(this.managementModeTopiaId);
        }
        if (this.readOnly) {
            this.notificationSupport.managementModeNotWritable();
        }
        if (this.getManagementMode().getGrowingSystem() != null) {
            GrowingSystem growingSystem = this.managementMode.getGrowingSystem();
            this.growingSystemTopiaId = growingSystem.getTopiaId();
            this.typeDEPHY = growingSystem.getGrowingPlan().getType();
        }
        this.managementModeCategory = this.managementMode.getCategory();
        this.sections = this.getManagementModeSections(this.managementMode);
        this.initForInput();
        return "input";
    }

    protected List<SectionDto> getManagementModeSections(ManagementMode managementMode) {
        ArrayList sections = null;
        if (managementMode.getSections() != null) {
            Collection mmSections = managementMode.getSections();
            sections = Lists.newArrayList((Iterable)Collections2.transform((Collection)mmSections, ManagementModes.SECTION_TO_DTO::apply));
        }
        return sections;
    }

    protected void initForInput() {
        if (!this.getManagementMode().isPersisted()) {
            GrowingSystemFilter growingSystemFilter = new GrowingSystemFilter();
            NavigationContext navigationContext = this.getNavigationContext();
            growingSystemFilter.setNavigationContext(navigationContext);
            this.growingSystems = this.managementModeService.getGrowingSystemsForManagementMode(navigationContext);
            this.histories = new ArrayList();
        } else {
            this.translateHistorical();
        }
        if (StringUtils.isNotBlank((CharSequence)this.growingSystemTopiaId)) {
            GrowingSystem growingSystem = this.growingSystemService.getGrowingSystem(this.growingSystemTopiaId);
            this.growingSystemsSector = growingSystem.getSector();
            this.domainTopiaId = growingSystem.getGrowingPlan().getDomain().getTopiaId();
            this.croppingPlanEntries = this.managementModeService.getGrowingSystemCroppingPlanEntries(this.growingSystemTopiaId);
            this.decisionRules = this.managementModeService.getGrowingSystemDecisionRules(this.growingSystemTopiaId);
            this.availableManagementModeCategories = this.managementModeService.getAvailableManagementModeCategories(this.growingSystemTopiaId);
            this.relatedManagementModes = this.managementModeService.getRelatedManagementModes(this.managementMode.getGrowingSystem());
        } else {
            this.availableManagementModeCategories = Lists.newArrayList((Object[])ManagementModeCategory.values());
        }
        this.groupesCibles = this.referentialService.getGroupesCibles();
    }

    protected void translateHistorical() {
        String historical = this.managementMode.getHistorical();
        if (!Strings.isNullOrEmpty((String)historical)) {
            Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
            List items = (List)this.getGson().fromJson(historical, type);
            int limit = Math.min(items.size(), this.getHistorySizeLimit());
            this.histories = Lists.newArrayListWithCapacity((int)limit);
            DateTimeFormatter simpleFormat = DateTimeFormatter.ofPattern(DATE_FORMAT);
            for (HistoryItem item : Iterables.limit((Iterable)Lists.reverse((List)items), (int)limit)) {
                LocalDateTime date = item.getDate();
                String stDate = simpleFormat.format(date);
                List args = item.getArgs();
                String fromCategory = (String)args.getFirst();
                String toCategory = (String)args.getFirst();
                String translatedFromCategories = this.getText(ManagementModeCategory.class.getName() + "." + fromCategory);
                String translatedToCategories = this.getText(ManagementModeCategory.class.getName() + "." + toCategory);
                HistoryType historyType = item.getType();
                String format = this.getText(HistoryType.class.getName() + "." + historyType.name());
                switch (3.$SwitchMap$fr$inra$agrosyst$api$services$common$HistoryType[historyType.ordinal()]) {
                    case 1: {
                        this.histories.add(String.format(format, stDate, translatedToCategories));
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.histories.add(String.format(format, stDate, translatedToCategories, translatedFromCategories));
                        break;
                    }
                    case 4: {
                        String fromMMCampagne = (String)args.get(2);
                        String toMMCampagne = (String)args.get(3);
                        this.histories.add(String.format(format, stDate, translatedToCategories, toMMCampagne, translatedFromCategories, fromMMCampagne));
                        break;
                    }
                    case 5: 
                    case 6: {
                        String stSectionType = (String)args.getFirst();
                        String translatedSectionType = this.getText(SectionType.class.getName() + "." + stSectionType);
                        String stBioAgressorType = (String)args.get(1);
                        String translatedBioAgressorType = Strings.isNullOrEmpty((String)stBioAgressorType) ? "-" : this.getText(BioAgressorType.class.getName() + "." + stBioAgressorType);
                        String bioAgressorId = (String)args.get(2);
                        String bioAgressorName = Strings.isNullOrEmpty((String)bioAgressorId) ? "-" : this.referentialService.getBioAgressor(bioAgressorId).getLabel();
                        this.histories.add(String.format(format, stDate, translatedSectionType, translatedBioAgressorType, bioAgressorName));
                        break;
                    }
                    case 7: 
                    case 8: {
                        String strategyTypeName = (String)args.getFirst();
                        String croppingPlanEntryName = "-";
                        String croppingPlanEntryIds = (String)args.get(2);
                        if (StringUtils.isNotBlank((CharSequence)croppingPlanEntryIds)) {
                            Object[] cropIds = croppingPlanEntryIds.split(", ");
                            List cropsNames = this.managementModeService.loadCropsNames((Set)Sets.newHashSet((Object[])cropIds));
                            croppingPlanEntryName = StringUtils.join((Iterable)cropsNames, (String)" - ");
                        }
                        this.histories.add(String.format(format, stDate, strategyTypeName, croppingPlanEntryName));
                        break;
                    }
                    case 9: 
                    case 10: {
                        String ruleName = "-";
                        String ruleId = (String)args.getFirst();
                        if (StringUtils.isNotBlank((CharSequence)ruleId)) {
                            Optional optionalDecisionRule = this.managementModeService.getDecisionRule(ruleId);
                            ruleName = optionalDecisionRule.isEmpty() ? I18n.t((String)"warning.decisionRule.remove", (Object[])new Object[0]) : ((DecisionRule)optionalDecisionRule.get()).getName();
                        }
                        Integer ruleVersion = Integer.valueOf((String)args.get(1));
                        this.histories.add(String.format(format, stDate, ruleName, ruleVersion));
                        break;
                    }
                }
            }
        }
    }

    public void validate() {
        ManagementMode managementMode = this.getManagementMode();
        if (!managementMode.isPersisted() && StringUtils.isBlank((CharSequence)this.growingSystemTopiaId)) {
            this.addFieldError("growingSystemTopiaId", "Le syst\u00e8me de culture est obligatoire !");
        }
        if (managementMode.isPersisted() && !this.activated) {
            this.addActionError("Le mod\u00e8le d\u00e9cisionnel et/ou son syst\u00e8me de culture et/ou son dispositif et/ou son domain sont inactifs ");
        }
        String string = this.growingSystemTopiaId = managementMode.isPersisted() ? managementMode.getGrowingSystem().getTopiaId() : this.growingSystemTopiaId;
        if (managementMode.getCategory() == null) {
            this.addFieldError("managementMode.category", "La cat\u00e9gorie est obligatoire !");
        }
        try {
            this.convertSectionsJson(this.sectionsJson);
        }
        catch (Exception ex) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Failed to load decision management modes", (Throwable)ex);
            }
            this.addActionError("Exception:" + String.valueOf(ex) + "\n/!\\ D\u00e9sol\u00e9 les donn\u00e9es saisies depuis votre dernier enregistrement concernant les rubriques n'ont pu \u00eatre r\u00e9cup\u00e9r\u00e9es !");
        }
        if (this.sections == null) {
            this.sections = new ArrayList();
        }
        ArrayList cropIds = null;
        GrowingSystem growingSystem = this.growingSystemService.getGrowingSystem(this.growingSystemTopiaId);
        this.typeDEPHY = growingSystem.getGrowingPlan().getType();
        for (SectionDto section : this.sections) {
            List strategies;
            if (section.getSectionType() == null) {
                this.addFieldError("editedSection.sectionType", "Le type de rubrique est obligatoire !");
                this.addActionError("Le type de rubrique est obligatoire !");
                continue;
            }
            SectionType sectionType = section.getSectionType();
            if (TypeDEPHY.DEPHY_FERME.equals((Object)this.typeDEPHY) && section.getCategoryObjective() == null) {
                this.addFieldError("editedStrategy.categoryObjective", "Cette strat\u00e9gie doit avoir le champ 'Caract\u00e9risation des objectifs agronomiques' de d\u00e9fini !");
                this.addActionError("Les strat\u00e9gies doivent avoir le champ 'Caract\u00e9risation des objectifs agronomiques' de d\u00e9fini !");
            }
            if (TypeDEPHY.DEPHY_FERME.equals((Object)this.typeDEPHY) && (sectionType == SectionType.ADVENTICES || sectionType == SectionType.MALADIES || sectionType == SectionType.RAVAGEURS) && StringUtils.isEmpty((CharSequence)section.getBioAgressorTopiaId())) {
                this.addFieldError("editedStrategy.bioAgressorTopiaId", "Cette rubrique doit avoir un bio-agresseur consid\u00e9r\u00e9 de d\u00e9fini !");
                this.addActionError("Les rubriques de type 'Maitrise des maladies', 'Maitrise des adventices' et 'Maitrise des ravageurs' doivent avoir un bio-agresseur consid\u00e9r\u00e9 de d\u00e9fini !");
            }
            if ((strategies = section.getStrategiesDto()) == null) continue;
            if (cropIds == null) {
                cropIds = this.growingSystemTopiaId == null ? new ArrayList() : this.managementModeService.getCropIdsForGrowingSystemId(this.growingSystemTopiaId);
            }
            for (StrategyDto strategyDto : strategies) {
                RefStrategyLever refStrategyLever;
                if (TypeDEPHY.DEPHY_FERME.equals((Object)this.typeDEPHY) && CollectionUtils.isEmpty((Collection)strategyDto.getCropIds())) {
                    this.addActionError("Une culture est requise sur une strat\u00e9gie !");
                }
                if (CollectionUtils.isNotEmpty((Collection)strategyDto.getCropsTopiaIds()) && !new HashSet(cropIds).containsAll(strategyDto.getCropsTopiaIds())) {
                    this.addActionError("Des cultures non valides ont \u00e9t\u00e9 d\u00e9tect\u00e9es sur une strat\u00e9gie !");
                }
                if ((refStrategyLever = strategyDto.getRefStrategyLever()) != null) continue;
                this.addActionError("Le levier n'est pas renseign\u00e9 !");
                this.addFieldError("editedStrategy.refStrategyLever", "Le levier est obligatoire");
            }
        }
        if (this.hasErrors()) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)String.format("For user email:" + this.getAuthenticatedUser().getEmail() + ":validate, action errors : management mode:'%s' for gs '%s' -> %s", this.managementModeTopiaId, this.growingSystemTopiaId, this.getActionErrors().toString()));
                LOGGER.error((Object)String.format("For user email:" + this.getAuthenticatedUser().getEmail() + ":validate, fields errors : management mode:'%s' for gs '%s' -> %s", this.managementModeTopiaId, this.growingSystemTopiaId, this.getFieldErrors().toString()));
            }
            this.initForInput();
        }
    }

    @Action(results={@Result(type="redirectAction", params={"actionName", "management-modes-edit-input", "managementModeTopiaId", "${managementMode.topiaId}"})})
    public String execute() throws Exception {
        this.managementMode = this.managementModeService.createOrUpdateManagementMode(this.managementMode, this.growingSystemTopiaId, (Collection)this.sections);
        if (Strings.isNullOrEmpty((String)this.managementModeTopiaId)) {
            this.notificationSupport.newManagementModeCreated(this.managementMode);
        } else {
            this.notificationSupport.managementModeSaved(this.managementMode);
        }
        return "success";
    }

    public void convertSectionsJson(String json) {
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.sections = (List)this.getGson().fromJson(json, type);
    }

    public String getManagementModeTopiaId() {
        return this.managementModeTopiaId;
    }

    public void setManagementModeTopiaId(String managementModeTopiaId) {
        this.managementModeTopiaId = managementModeTopiaId;
    }

    public String getGrowingSystemTopiaId() {
        return this.growingSystemTopiaId;
    }

    public void setGrowingSystemTopiaId(String growingSystemTopiaId) {
        this.growingSystemTopiaId = growingSystemTopiaId;
    }

    public String getDomainTopiaId() {
        return this.domainTopiaId;
    }

    public List<GrowingSystem> getGrowingSystems() {
        return this.growingSystems;
    }

    public List<SectionDto> getSections() {
        return this.sections;
    }

    public void setSections(String json) {
        this.sectionsJson = json;
    }

    public List<CroppingPlanEntry> getCroppingPlanEntries() {
        return this.croppingPlanEntries;
    }

    public Collection<DecisionRule> getDecisionRules() {
        return this.decisionRules;
    }

    public List<ManagementModeCategory> getAvailableManagementModeCategories() {
        return this.availableManagementModeCategories;
    }

    public List<ManagementMode> getRelatedManagementModes() {
        return this.relatedManagementModes;
    }

    public ManagementModeCategory[] getCategories() {
        return ManagementModeCategory.values();
    }

    public List<String> getHistories() {
        return this.histories;
    }

    public int getHistorySizeLimit() {
        return 100;
    }

    public ManagementModeCategory getManagementModeCategory() {
        return this.managementModeCategory;
    }

    public Sector getGrowingSystemsSector() {
        return this.growingSystemsSector;
    }

    public Map<SectionType, BioAgressorType[]> getFilteredBioAgressorTypes() {
        return ManagementModeService.bioAgressorTypeBySectionType();
    }

    public List<GroupeCibleDTO> getGroupesCibles() {
        return this.groupesCibles;
    }

    public TypeDEPHY getTypeDEPHY() {
        return this.typeDEPHY;
    }
}

