/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.managementmodes;

import fr.inra.agrosyst.api.entities.AgrosystInterventionType;
import fr.inra.agrosyst.api.entities.BioAgressorType;
import fr.inra.agrosyst.api.services.managementmode.ManagementModeService;
import fr.inra.agrosyst.api.services.referential.ReferentialService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;

public class DecisionRulesEditJson
extends AbstractJsonAction {
    private static final Log LOGGER = LogFactory.getLog(DecisionRulesEditJson.class);
    private static final long serialVersionUID = 4109060690576341764L;
    protected transient ManagementModeService managementModeService;
    protected transient ReferentialService referentialService;
    protected String domainCode;
    protected String growingSystemTopiaId;
    protected BioAgressorType bioAgressorType;
    protected Collection<BioAgressorType> bioAgressorTypes;
    protected String codeGroupeCibleMaa;
    protected String bioAgressorTopiaId;
    protected String decisionRuleName;
    protected AgrosystInterventionType agrosystInterventionType;
    protected String cropIds;
    protected String requiredDecisionRulesIds;

    public void setManagementModeService(ManagementModeService managementModeService) {
        this.managementModeService = managementModeService;
    }

    public void setReferentialService(ReferentialService referentialService) {
        this.referentialService = referentialService;
    }

    public void setDomainCode(String domainCode) {
        this.domainCode = domainCode;
    }

    public void setGrowingSystemTopiaId(String growingSystemTopiaId) {
        this.growingSystemTopiaId = growingSystemTopiaId;
    }

    public void setBioAgressorType(BioAgressorType bioAgressorType) {
        this.bioAgressorType = bioAgressorType;
    }

    public void setBioAgressorTypes(String bioAgressorTypes) {
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.bioAgressorTypes = (Collection)this.getGson().fromJson(bioAgressorTypes, type);
    }

    public void setDecisionRuleName(String decisionRuleName) {
        this.decisionRuleName = decisionRuleName;
    }

    public void setAgrosystInterventionType(AgrosystInterventionType agrosystInterventionType) {
        this.agrosystInterventionType = agrosystInterventionType;
    }

    public void setCropIds(String cropIds) {
        this.cropIds = cropIds;
    }

    public void setRequiredDecisionRulesIds(String requiredDecisionRulesIds) {
        this.requiredDecisionRulesIds = requiredDecisionRulesIds;
    }

    private List<String> convertJsonIdsToStringList(String json) {
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        return (List)this.getGson().fromJson(json, type);
    }

    public void setCodeGroupeCibleMaa(String codeGroupeCibleMaa) {
        this.codeGroupeCibleMaa = codeGroupeCibleMaa;
    }

    public void setBioAgressorTopiaId(String bioAgressorTopiaId) {
        this.bioAgressorTopiaId = bioAgressorTopiaId;
    }

    @Action(value="decision-rules-edit-cropping-plan-entries-json")
    public String listCroppingPlanEntries() {
        try {
            this.jsonData = this.managementModeService.getDomainCodeCroppingPlanEntries(this.domainCode);
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)String.format("Failed to load crops for domain code '%s':", this.domainCode), (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    @Action(value="decision-rules-edit-bio-agressors-json")
    public String listBioAgressors() {
        try {
            this.jsonData = this.referentialService.getBioAgressors(this.bioAgressorTypes);
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)String.format("Failed to load bioagressors for bioAgressorTypes '%s':", this.bioAgressorTypes), (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    @Action(value="create-decision-rules-edit-json")
    public String createDecisionRules() {
        try {
            List cropIds = this.convertJsonIdsToStringList(this.cropIds);
            this.jsonData = this.managementModeService.createNewDecisionRule(this.agrosystInterventionType, this.growingSystemTopiaId, this.bioAgressorType, this.codeGroupeCibleMaa, this.bioAgressorTopiaId, cropIds, this.decisionRuleName);
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Failed to create new d\u00e9cision rules", (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    @Action(value="load-required-decision-rules-json")
    public String loadRequiredDecisionRules() {
        try {
            List requiredDecisionRules = this.convertJsonIdsToStringList(this.requiredDecisionRulesIds);
            this.jsonData = this.managementModeService.getAllDecisionRules(requiredDecisionRules);
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Failed to load decision rules", (Throwable)e);
            }
            return "error";
        }
        return "success";
    }
}

