/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.managementmodes;

import com.google.common.base.Strings;
import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.AgrosystInterventionType;
import fr.inra.agrosyst.api.entities.BioAgressorType;
import fr.inra.agrosyst.api.entities.CroppingPlanEntry;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.managementmode.DecisionRule;
import fr.inra.agrosyst.api.entities.managementmode.DecisionRuleCrop;
import fr.inra.agrosyst.api.entities.managementmode.DecisionRuleImpl;
import fr.inra.agrosyst.api.entities.referential.BioAgressorParentType;
import fr.inra.agrosyst.api.entities.referential.RefBioAgressor;
import fr.inra.agrosyst.api.entities.referential.Referentials;
import fr.inra.agrosyst.api.services.domain.DomainDto;
import fr.inra.agrosyst.api.services.domain.DomainFilter;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.api.services.managementmode.ManagementModeService;
import fr.inra.agrosyst.api.services.referential.GroupeCibleDTO;
import fr.inra.agrosyst.api.services.referential.ReferentialService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;
import fr.inra.agrosyst.web.actions.domains.MinimalDomainDto;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.Preparable;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.nuiton.topia.persistence.TopiaEntity;

public class DecisionRulesEdit
extends AbstractAgrosystAction
implements Preparable {
    private static final Log LOGGER = LogFactory.getLog(DecisionRulesEdit.class);
    private static final long serialVersionUID = -6937262808324248162L;
    protected transient ManagementModeService managementModeService;
    protected transient ReferentialService referentialService;
    protected transient DomainService domainService;
    protected String decisionRuleTopiaId;
    protected DecisionRule decisionRule;
    protected List<Domain> domains;
    protected String domainCode;
    protected String domainName;
    protected List<CroppingPlanEntry> croppingPlanEntries;
    protected List<String> croppingCodes;
    protected String decisionRuleCropsJson;
    protected List<GroupeCibleDTO> groupesCibles;
    protected List<RefBioAgressor> bioAgressors;
    protected String codeGroupeCibleMaa;
    protected String bioAgressorTopiaId;
    protected String decisionRuleCode;
    protected List<DecisionRule> relatedDecisionRules;

    public DecisionRule getDecisionRule() {
        return Objects.requireNonNullElseGet(this.decisionRule, DecisionRuleImpl::new);
    }

    public void prepare() {
        if (StringUtils.isBlank((CharSequence)this.decisionRuleTopiaId)) {
            if (StringUtils.isBlank((CharSequence)this.decisionRuleCode)) {
                this.decisionRule = this.managementModeService.newDecisionRule();
            } else {
                this.decisionRule = this.managementModeService.getLastDecisionRuleVersion(this.decisionRuleCode);
                this.decisionRuleTopiaId = this.decisionRule.getTopiaId();
            }
        } else {
            Optional optionalDecisionRule = this.managementModeService.getDecisionRule(this.decisionRuleTopiaId);
            this.decisionRule = optionalDecisionRule.orElse(this.managementModeService.newDecisionRule());
        }
        if (this.decisionRule.isPersisted()) {
            this.activated = this.managementModeService.isDecisionRuleActive(this.decisionRule);
        }
    }

    @Action(value="decision-rules-edit-input")
    public String input() throws Exception {
        if (!Strings.isNullOrEmpty((String)this.decisionRuleTopiaId)) {
            this.authorizationService.checkDecisionRuleReadable(this.decisionRuleTopiaId);
            boolean bl = this.readOnly = !this.authorizationService.isDecisionRuleWritable(this.decisionRuleTopiaId);
        }
        if (this.readOnly) {
            this.notificationSupport.decisionRuleNotWritable();
        }
        if (this.decisionRule.getBioAgressor() != null) {
            this.bioAgressorTopiaId = this.decisionRule.getBioAgressor().getTopiaId();
        }
        this.initForInput();
        return "input";
    }

    protected void initForInput() {
        if (this.getDecisionRule().isPersisted()) {
            DomainDto domain = this.domainService.getActiveOrUnactiveDomainForCode(this.getDecisionRule().getDomainCode());
            this.domainName = domain.getName();
            this.croppingPlanEntries = this.managementModeService.getDomainCodeCroppingPlanEntries(this.getDecisionRule().getDomainCode());
            this.relatedDecisionRules = this.managementModeService.getRelatedDecisionRules(this.getDecisionRule().getCode());
        } else {
            DomainFilter domainFilter = new DomainFilter();
            NavigationContext navigationContext = this.getNavigationContext();
            domainFilter.setNavigationContext(navigationContext);
            domainFilter.setActive(Boolean.TRUE);
            domainFilter.setAllPageSize();
            this.domains = this.domainService.getActiveWritableDomainsForDecisionRuleCreation(domainFilter);
            this.croppingPlanEntries = null;
        }
        BioAgressorType bioAgressorType = this.decisionRule.getBioAgressorType();
        if (bioAgressorType != null) {
            this.bioAgressors = this.referentialService.getBioAgressors(Collections.singleton(bioAgressorType));
        }
        this.groupesCibles = this.referentialService.getGroupesCibles();
    }

    public void validate() {
        if (this.decisionRule.isPersisted() && !this.activated) {
            this.addActionError("La r\u00e8gle de d\u00e9cision est innactive !");
        }
        if (StringUtils.isBlank((CharSequence)this.decisionRule.getName())) {
            this.addFieldError("decisionRule.name", "Le nom est obligatoire !");
        }
        if (this.decisionRule.getInterventionType() == null) {
            this.addFieldError("decisionRule.interventionType", "Le type d'intervention est obligatoire !");
        }
        if (this.hasErrors()) {
            if (LOGGER.isErrorEnabled()) {
                String decisionRuleId = this.getLogEntityId((TopiaEntity)this.decisionRule);
                LOGGER.error((Object)String.format("For user email:" + this.getAuthenticatedUser().getEmail() + ":validate, action errors : decisionRule:'%s' -> %s", decisionRuleId, this.getActionErrors().toString()));
                LOGGER.error((Object)String.format("For user email:" + this.getAuthenticatedUser().getEmail() + ":validate, fields errors : decisionRule:'%s' -> %s", decisionRuleId, this.getFieldErrors().toString()));
            }
            this.initForInput();
        }
    }

    @Action(results={@Result(type="redirectAction", params={"actionName", "decision-rules-edit-input", "decisionRuleTopiaId", "${decisionRule.topiaId}"})})
    public String execute() throws Exception {
        try {
            List decisionRuleCrops = this.convertSectionsJson(this.decisionRuleCropsJson);
            this.decisionRule = this.managementModeService.createOrUpdateDecisionRule(this.decisionRule, this.domainCode, this.bioAgressorTopiaId, decisionRuleCrops);
            this.decisionRuleTopiaId = this.decisionRule.getTopiaId();
            this.notificationSupport.decisionRuleSaved(this.decisionRule);
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)String.format("Rule creation exception decisionRule '%s', domainCode '%s', bioAgressorId '%s'", this.decisionRule, this.domainCode, this.bioAgressorTopiaId), (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    public Map<AgrosystInterventionType, String> getAgrosystInterventionTypes() {
        return this.referentialService.getAgrosystInterventionTypeTranslationMap();
    }

    public Collection<MinimalDomainDto> getDomains() {
        ArrayList<MinimalDomainDto> result = new ArrayList<MinimalDomainDto>();
        Collection domainToTransform = CollectionUtils.emptyIfNull((Collection)this.domains);
        domainToTransform.forEach(d -> result.add(new MinimalDomainDto(d.getTopiaId(), d.getCode(), d.getName())));
        return result;
    }

    public Map<BioAgressorType, String> getTranslatedBioAgressorType() {
        return this.referentialService.getTranslatedBioAgressorType();
    }

    public Map<BioAgressorType, BioAgressorParentType> getBioAgressorTypes() {
        return Referentials.getAllBioAgressorParentTypes().stream().collect(Collectors.toMap(BioAgressorParentType::getParent, Function.identity()));
    }

    public List<DecisionRuleCrop> convertSectionsJson(String json) {
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        return (List)this.getGson().fromJson(json, type);
    }

    @Generated
    public ManagementModeService getManagementModeService() {
        return this.managementModeService;
    }

    @Generated
    public ReferentialService getReferentialService() {
        return this.referentialService;
    }

    @Generated
    public DomainService getDomainService() {
        return this.domainService;
    }

    @Generated
    public String getDecisionRuleTopiaId() {
        return this.decisionRuleTopiaId;
    }

    @Generated
    public String getDomainCode() {
        return this.domainCode;
    }

    @Generated
    public String getDomainName() {
        return this.domainName;
    }

    @Generated
    public List<CroppingPlanEntry> getCroppingPlanEntries() {
        return this.croppingPlanEntries;
    }

    @Generated
    public List<String> getCroppingCodes() {
        return this.croppingCodes;
    }

    @Generated
    public String getDecisionRuleCropsJson() {
        return this.decisionRuleCropsJson;
    }

    @Generated
    public List<GroupeCibleDTO> getGroupesCibles() {
        return this.groupesCibles;
    }

    @Generated
    public List<RefBioAgressor> getBioAgressors() {
        return this.bioAgressors;
    }

    @Generated
    public String getCodeGroupeCibleMaa() {
        return this.codeGroupeCibleMaa;
    }

    @Generated
    public String getBioAgressorTopiaId() {
        return this.bioAgressorTopiaId;
    }

    @Generated
    public String getDecisionRuleCode() {
        return this.decisionRuleCode;
    }

    @Generated
    public List<DecisionRule> getRelatedDecisionRules() {
        return this.relatedDecisionRules;
    }

    @Generated
    public void setManagementModeService(ManagementModeService managementModeService) {
        this.managementModeService = managementModeService;
    }

    @Generated
    public void setReferentialService(ReferentialService referentialService) {
        this.referentialService = referentialService;
    }

    @Generated
    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }

    @Generated
    public void setDecisionRuleTopiaId(String decisionRuleTopiaId) {
        this.decisionRuleTopiaId = decisionRuleTopiaId;
    }

    @Generated
    public void setDecisionRule(DecisionRule decisionRule) {
        this.decisionRule = decisionRule;
    }

    @Generated
    public void setDomains(List<Domain> domains) {
        this.domains = domains;
    }

    @Generated
    public void setDomainCode(String domainCode) {
        this.domainCode = domainCode;
    }

    @Generated
    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    @Generated
    public void setCroppingPlanEntries(List<CroppingPlanEntry> croppingPlanEntries) {
        this.croppingPlanEntries = croppingPlanEntries;
    }

    @Generated
    public void setCroppingCodes(List<String> croppingCodes) {
        this.croppingCodes = croppingCodes;
    }

    @Generated
    public void setDecisionRuleCropsJson(String decisionRuleCropsJson) {
        this.decisionRuleCropsJson = decisionRuleCropsJson;
    }

    @Generated
    public void setGroupesCibles(List<GroupeCibleDTO> groupesCibles) {
        this.groupesCibles = groupesCibles;
    }

    @Generated
    public void setBioAgressors(List<RefBioAgressor> bioAgressors) {
        this.bioAgressors = bioAgressors;
    }

    @Generated
    public void setCodeGroupeCibleMaa(String codeGroupeCibleMaa) {
        this.codeGroupeCibleMaa = codeGroupeCibleMaa;
    }

    @Generated
    public void setBioAgressorTopiaId(String bioAgressorTopiaId) {
        this.bioAgressorTopiaId = bioAgressorTopiaId;
    }

    @Generated
    public void setDecisionRuleCode(String decisionRuleCode) {
        this.decisionRuleCode = decisionRuleCode;
    }

    @Generated
    public void setRelatedDecisionRules(List<DecisionRule> relatedDecisionRules) {
        this.relatedDecisionRules = relatedDecisionRules;
    }
}

