/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.generic;

import fr.inra.agrosyst.api.services.generic.GenericEntityService;
import fr.inra.agrosyst.api.services.generic.GenericFilter;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.pagination.PaginationResult;

public class GenericEntitiesListJson
extends AbstractJsonAction {
    private static final Log LOGGER = LogFactory.getLog(GenericEntitiesListJson.class);
    private static final long serialVersionUID = -4267342874222046159L;
    protected transient GenericEntityService service;
    protected transient String genericClassName;
    protected String filter;

    public void setService(GenericEntityService service) {
        this.service = service;
    }

    public void setGenericClassName(String genericClassName) {
        this.genericClassName = genericClassName;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String execute() {
        try {
            GenericFilter rawFilter = (GenericFilter)this.getGson().fromJson(this.filter, GenericFilter.class);
            Class<?> klass = Class.forName(this.genericClassName);
            this.writeListNbElementByPage(klass, rawFilter.getPageSize());
            PaginationResult paginatedResult = this.service.listEntitiesFromString(this.genericClassName, rawFilter);
            if (klass.isEnum()) {
                for (Object entity : paginatedResult.getElements()) {
                    Map entityMap = (Map)entity;
                    String name = (String)entityMap.get("Valeur");
                    String traduction = this.getText(klass.getName() + "." + name);
                    entityMap.put("Traduction", traduction);
                }
            }
            this.jsonData = paginatedResult;
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)String.format("Filed to load elements for '%s':", this.genericClassName), (Throwable)e);
            }
            return "error";
        }
        return "success";
    }
}

