/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.effective;

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.services.domain.ZoneDto;
import fr.inra.agrosyst.api.services.effective.EffectiveCropCycleService;
import fr.inra.agrosyst.api.services.effective.EffectiveZoneFilter;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;

public class EffectiveCropCyclesListJson
extends AbstractJsonAction {
    private static final long serialVersionUID = -4624926883335820728L;
    private static final Log LOGGER = LogFactory.getLog(EffectiveCropCyclesListJson.class);
    protected transient EffectiveCropCycleService effectiveCropCycleService;
    protected transient String filter;
    protected transient boolean measurement;

    public void setEffectiveCropCycleService(EffectiveCropCycleService effectiveCropCycleService) {
        this.effectiveCropCycleService = effectiveCropCycleService;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public void setMeasurement(boolean measurement) {
        this.measurement = measurement;
    }

    @Action(value="effective-crop-cycles-list-json")
    public String effectiveCropCyclesList() throws Exception {
        try {
            EffectiveZoneFilter zoneFilter = (EffectiveZoneFilter)this.getGson().fromJson(this.filter, EffectiveZoneFilter.class);
            this.writeListNbElementByPage(ZoneDto.class, String.valueOf(this.measurement), zoneFilter.getPageSize());
            NavigationContext navigationContext = this.getNavigationContext();
            zoneFilter.setNavigationContext(navigationContext);
            this.jsonData = this.effectiveCropCycleService.getFilteredZonesAndCroppingPlanInfosDto(zoneFilter);
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Failed to zones and cropping plan info", (Throwable)e);
            }
            return "error";
        }
        return "success";
    }
}

