/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.domains;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import fr.inra.agrosyst.api.entities.referential.RefLocation;
import fr.inra.agrosyst.api.services.referential.ReferentialService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GetRefLocationJson
extends AbstractJsonAction {
    private static final Log LOGGER = LogFactory.getLog(GetRefLocationJson.class);
    private static final long serialVersionUID = 1L;
    protected transient ReferentialService referentialService;
    protected transient String locationTopiaId;

    public void setReferentialService(ReferentialService referentialService) {
        this.referentialService = referentialService;
    }

    public void setLocationTopiaId(String locationTopiaId) {
        this.locationTopiaId = locationTopiaId;
    }

    protected String orNC(String text) {
        String result = (String)MoreObjects.firstNonNull((Object)text, (Object)"n/c");
        return result;
    }

    public String execute() throws Exception {
        try {
            RefLocation refLocation = this.referentialService.getRefLocation(this.locationTopiaId);
            String departement = refLocation.getDepartement();
            String key = "departement." + Strings.padStart((String)departement, (int)2, (char)'0');
            String departementName = this.getText(key, "n/c");
            String petiteRegionAgricole = this.orNC(refLocation.getPetiteRegionAgricoleCode());
            String petiteRegionAgricoleName = this.orNC(refLocation.getPetiteRegionAgricoleNom());
            int region = refLocation.getRegion();
            this.jsonData = ImmutableMap.of((Object)"departement", (Object)departement, (Object)"departementName", (Object)departementName, (Object)"petiteRegionAgricole", (Object)petiteRegionAgricole, (Object)"petiteRegionAgricoleName", (Object)petiteRegionAgricoleName, (Object)"region", (Object)String.valueOf(region));
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)String.format("Faild to load RefLocation for locationTopiaId '%s':", this.locationTopiaId), (Throwable)e);
            }
            return "error";
        }
        return "success";
    }
}

