/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.domains;

import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.services.domain.DomainDeletionException;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.web.actions.admin.AbstractAdminAction;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

public class DomainsDelete
extends AbstractAdminAction {
    private static final Log LOGGER = LogFactory.getLog(DomainsDelete.class);
    private static final long serialVersionUID = -5038859523630065675L;
    protected List<String> domainIds;
    protected transient DomainService domainService;

    public void setDomainIds(String domainIds) {
        this.domainIds = (List)this.getGson().fromJson(domainIds, List.class);
    }

    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }

    @Action(results={@Result(name={"success"}, type="redirectAction", params={"actionName", "domains-list"}), @Result(name={"error"}, type="redirectAction", params={"actionName", "domains-list"})})
    public String execute() throws Exception {
        this.checkIsAdmin();
        String domainId = (String)this.domainIds.getFirst();
        Domain domain = this.domainService.getDomain(domainId);
        String domainNameAndCampaign = domain.getName() + " (" + domain.getCampaign() + ")";
        try {
            this.domainService.deleteDomain(domainId);
            this.notificationSupport.domainDeleted(domainNameAndCampaign);
        }
        catch (DomainDeletionException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)("For user email:" + this.getAuthenticatedUser().getEmail() + ":failed to delete domain '" + domainId + "', the domain has practiced systems"), (Throwable)e);
            }
            this.notificationSupport.domainDeletionError("Ce domaine est associ\u00e9 \u00e0 au moins un syst\u00e8me synth\u00e9tis\u00e9 pluri-annuel, sa suppression n'est pour le moment pas possible.");
            return "error";
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)String.format("For user email:" + this.getAuthenticatedUser().getEmail() + ":\u00c9chec de suppression du domaine '%s' ", domainId), (Throwable)e);
            }
            this.notificationSupport.domainDeletionError("Erreur lors de la suppression du domaine : " + e.getMessage());
            return "error";
        }
        return "success";
    }
}

