/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.domains;

import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;
import java.lang.reflect.Type;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DomainInputsCopy
extends AbstractJsonAction {
    private static final long serialVersionUID = 5286218067644801016L;
    private static final Log LOGGER = LogFactory.getLog(DomainInputsCopy.class);
    protected transient String fromDomain;
    protected transient String toDomains;
    protected transient String inputs;
    protected transient DomainService domainService;
    protected transient boolean forceCopy;

    public String execute() throws Exception {
        try {
            List toDomainIds = this.getToDomainIds(this.toDomains);
            List inputIds = this.getInputIds(this.inputs);
            this.jsonData = this.domainService.copyInputs(this.fromDomain, inputIds, toDomainIds, this.forceCopy);
            return "success";
        }
        catch (IllegalArgumentException e) {
            this.jsonData = e.getClass().getSimpleName();
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)String.format("copy tools from domain '%s' to domains '%s' failed", this.fromDomain, this.toDomains), (Throwable)e);
            }
            return "error";
        }
        catch (Exception e) {
            return "error";
        }
    }

    public void setFromDomain(String fromDomain) {
        this.fromDomain = fromDomain;
    }

    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }

    public void setForceCopy(boolean forceCopy) {
        this.forceCopy = forceCopy;
    }

    public void setToDomains(String json) {
        this.toDomains = json;
    }

    public void setInputs(String json) {
        this.inputs = json;
    }

    protected List<String> getToDomainIds(String json) {
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        return (List)this.getGson().fromJson(json, type);
    }

    protected List<String> getInputIds(String json) {
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        return (List)this.getGson().fromJson(json, type);
    }
}

