/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.domains;

import com.google.common.collect.Sets;
import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.services.domain.DomainFilter;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DomainIdsJson
extends AbstractJsonAction {
    private static final Log LOGGER = LogFactory.getLog(DomainIdsJson.class);
    private static final long serialVersionUID = -639287019639333023L;
    protected transient DomainService domainService;
    protected boolean fromNavigationContextChoose = false;
    protected String filter;
    protected Set<Integer> selectedCampaigns = Sets.newHashSet();
    protected Set<String> selectedNetworks = Sets.newHashSet();

    public String execute() {
        try {
            DomainFilter domainFilter = (DomainFilter)this.getGson().fromJson(this.filter, DomainFilter.class);
            NavigationContext navigationContext = this.fromNavigationContextChoose ? new NavigationContext(this.selectedCampaigns, this.selectedNetworks, null, null, null) : this.getNavigationContext();
            domainFilter.setNavigationContext(navigationContext);
            this.jsonData = this.domainService.getFilteredDomainIds(domainFilter);
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Failed to load domains list", (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    @Generated
    public DomainService getDomainService() {
        return this.domainService;
    }

    @Generated
    public boolean isFromNavigationContextChoose() {
        return this.fromNavigationContextChoose;
    }

    @Generated
    public String getFilter() {
        return this.filter;
    }

    @Generated
    public Set<Integer> getSelectedCampaigns() {
        return this.selectedCampaigns;
    }

    @Generated
    public Set<String> getSelectedNetworks() {
        return this.selectedNetworks;
    }

    @Generated
    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }

    @Generated
    public void setFromNavigationContextChoose(boolean fromNavigationContextChoose) {
        this.fromNavigationContextChoose = fromNavigationContextChoose;
    }

    @Generated
    public void setFilter(String filter) {
        this.filter = filter;
    }

    @Generated
    public void setSelectedCampaigns(Set<Integer> selectedCampaigns) {
        this.selectedCampaigns = selectedCampaigns;
    }

    @Generated
    public void setSelectedNetworks(Set<String> selectedNetworks) {
        this.selectedNetworks = selectedNetworks;
    }
}

