/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.auth;

import fr.inra.agrosyst.api.services.users.UserService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.convention.annotation.Action;

public class ForgottenPassword
extends AbstractAgrosystAction {
    private static final long serialVersionUID = 2328784341047848966L;
    private UserService userService;
    private String email;
    private boolean reminderSent;
    private String next;

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setNext(String next) {
        this.next = next;
    }

    public String getNext() {
        return this.next;
    }

    @Action(value="forgotten-password-input")
    public String input() throws Exception {
        return super.input();
    }

    public String execute() throws Exception {
        if (StringUtils.isNotBlank((CharSequence)this.email)) {
            this.reminderSent = this.userService.askForPasswordReminder(this.email, this.next);
            if (!this.reminderSent && this.userService.isValidEmail(this.email) && !this.userService.isUserActive(this.email)) {
                this.addFieldError("email", "Votre compte est d\u00e9sactiv\u00e9, merci de contacter un administrateur d'Agrosyst.");
            } else {
                this.addActionMessage(String.format("Email de r\u00e9cup\u00e9ration du mot de passe envoy\u00e9 \u00e0 l'adresse %s, consultez votre bo\u00eete mail", this.email));
                this.reminderSent = true;
            }
        }
        return "input";
    }

    public String getEmail() {
        return this.email;
    }

    public boolean isReminderSent() {
        return this.reminderSent;
    }
}

