/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.auth;

import com.google.common.base.Strings;
import fr.inra.agrosyst.api.entities.Sector;
import fr.inra.agrosyst.api.entities.TypeDEPHY;
import fr.inra.agrosyst.api.entities.referential.FeedbackCategory;
import fr.inra.agrosyst.api.services.users.FeedbackContext;
import fr.inra.agrosyst.api.services.users.UserService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.List;
import javax.imageio.ImageIO;
import lombok.Generated;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FeedbackJson
extends AbstractJsonAction {
    private static final long serialVersionUID = -6415308969543420930L;
    private static final Log LOGGER = LogFactory.getLog(FeedbackJson.class);
    protected transient UserService userService;
    protected transient String clientAppVersion;
    protected transient String feedback;
    protected transient FeedbackCategory feedbackCategory;
    protected transient List<Sector> sectorTypes;
    protected transient TypeDEPHY dephyType;
    protected transient String itEmail;
    protected transient boolean isNotNetworkIr;
    protected transient String env;
    protected transient String location;
    protected transient String locationTitle;
    protected transient String referer;
    protected transient String requested;
    protected transient String screenshot;
    protected transient String attachment;
    protected transient String attachmentName;
    protected transient String attachmentType;

    public void setIsNotNetworkIr(boolean notNetworkIr) {
        this.isNotNetworkIr = notNetworkIr;
    }

    public String execute() throws Exception {
        Object envInfo = Strings.nullToEmpty((String)this.env);
        envInfo = (String)envInfo + "Adresse IP : " + this.servletRequest.getRemoteAddr() + "\n";
        envInfo = (String)envInfo + "Session ID : " + this.getSessionId() + "\n";
        envInfo = (String)envInfo + "Version cliente : " + this.clientAppVersion + "\n";
        envInfo = (String)envInfo + "Version web : " + this.getConfig().getApplicationVersion() + "\n";
        byte[] imgData = this.convertBase64ToByteArray(this.screenshot, true);
        FeedbackContext feedbackContext = new FeedbackContext(this.sectorTypes, this.dephyType, this.feedbackCategory, this.feedback, this.itEmail, this.isNotNetworkIr, imgData);
        feedbackContext.addTechnicalDetails((String)envInfo, this.location, this.locationTitle, this.requested, this.referer);
        byte[] attachmentData = this.convertBase64ToByteArray(this.attachment, false);
        if (attachmentData != null) {
            feedbackContext.addAttachment(attachmentData, this.attachmentName, this.attachmentType);
        }
        this.jsonData = this.userService.sendFeedback(feedbackContext);
        if (FeedbackContext.FeedbackStatus.SUCCESS.equals((Object)feedbackContext.getFeedbackStatus()) || FeedbackContext.FeedbackStatus.NOT_SEND.equals((Object)feedbackContext.getFeedbackStatus())) {
            return "success";
        }
        return "error";
    }

    protected byte[] convertBase64ToByteArray(String fullBase64, boolean isImage) {
        byte[] result;
        block13: {
            result = null;
            if (fullBase64 != null) {
                try {
                    String base64Data = fullBase64.substring(fullBase64.indexOf(",") + 1);
                    result = Base64.decodeBase64((String)base64Data);
                    if (!isImage) break block13;
                    try (ByteArrayInputStream is = new ByteArrayInputStream(result);
                         ByteArrayOutputStream os = new ByteArrayOutputStream();){
                        BufferedImage image = ImageIO.read(is);
                        ImageIO.write((RenderedImage)image, "jpeg", os);
                        result = os.toByteArray();
                    }
                }
                catch (Exception ex) {
                    if (!LOGGER.isErrorEnabled()) break block13;
                    LOGGER.error((Object)("Can't convert base64 data to " + (isImage ? "image" : "file")), (Throwable)ex);
                }
            }
        }
        return result;
    }

    @Generated
    public UserService getUserService() {
        return this.userService;
    }

    @Generated
    public String getClientAppVersion() {
        return this.clientAppVersion;
    }

    @Generated
    public String getFeedback() {
        return this.feedback;
    }

    @Generated
    public FeedbackCategory getFeedbackCategory() {
        return this.feedbackCategory;
    }

    @Generated
    public List<Sector> getSectorTypes() {
        return this.sectorTypes;
    }

    @Generated
    public TypeDEPHY getDephyType() {
        return this.dephyType;
    }

    @Generated
    public String getItEmail() {
        return this.itEmail;
    }

    @Generated
    public boolean isNotNetworkIr() {
        return this.isNotNetworkIr;
    }

    @Generated
    public String getEnv() {
        return this.env;
    }

    @Generated
    public String getLocation() {
        return this.location;
    }

    @Generated
    public String getLocationTitle() {
        return this.locationTitle;
    }

    @Generated
    public String getReferer() {
        return this.referer;
    }

    @Generated
    public String getRequested() {
        return this.requested;
    }

    @Generated
    public String getScreenshot() {
        return this.screenshot;
    }

    @Generated
    public String getAttachment() {
        return this.attachment;
    }

    @Generated
    public String getAttachmentName() {
        return this.attachmentName;
    }

    @Generated
    public String getAttachmentType() {
        return this.attachmentType;
    }

    @Generated
    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    @Generated
    public void setClientAppVersion(String clientAppVersion) {
        this.clientAppVersion = clientAppVersion;
    }

    @Generated
    public void setFeedback(String feedback) {
        this.feedback = feedback;
    }

    @Generated
    public void setFeedbackCategory(FeedbackCategory feedbackCategory) {
        this.feedbackCategory = feedbackCategory;
    }

    @Generated
    public void setSectorTypes(List<Sector> sectorTypes) {
        this.sectorTypes = sectorTypes;
    }

    @Generated
    public void setDephyType(TypeDEPHY dephyType) {
        this.dephyType = dephyType;
    }

    @Generated
    public void setItEmail(String itEmail) {
        this.itEmail = itEmail;
    }

    @Generated
    public void setEnv(String env) {
        this.env = env;
    }

    @Generated
    public void setLocation(String location) {
        this.location = location;
    }

    @Generated
    public void setLocationTitle(String locationTitle) {
        this.locationTitle = locationTitle;
    }

    @Generated
    public void setReferer(String referer) {
        this.referer = referer;
    }

    @Generated
    public void setRequested(String requested) {
        this.requested = requested;
    }

    @Generated
    public void setScreenshot(String screenshot) {
        this.screenshot = screenshot;
    }

    @Generated
    public void setAttachment(String attachment) {
        this.attachment = attachment;
    }

    @Generated
    public void setAttachmentName(String attachmentName) {
        this.attachmentName = attachmentName;
    }

    @Generated
    public void setAttachmentType(String attachmentType) {
        this.attachmentType = attachmentType;
    }
}

