/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web;

import com.google.common.base.Preconditions;
import fr.inra.agrosyst.api.entities.Sector;
import fr.inra.agrosyst.api.exceptions.AgrosystTechnicalException;
import fr.inra.agrosyst.services.AgrosystServiceConfig;
import fr.inra.agrosyst.web.AgrosystWebConfig;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.config.ArgumentsParserException;
import org.nuiton.config.ConfigOptionDef;

/*
 * Exception performing whole class analysis ignored.
 */
public class AgrosystWebConfig {
    private static final Log LOGGER = LogFactory.getLog(AgrosystWebConfig.class);
    private static final String AGROSYST_DEFAULT_CONF_FILENAME = "agrosyst-default.properties";
    public static final String NAVIGATION_CONTEXT_COOKIE_NAME = "nav.context";
    public static final String NB_ELEMENT_BY_PAGE_COOKIE_NAME = "list.nbByPage";
    private final String configFileName;
    protected ApplicationConfig config;

    public AgrosystWebConfig(String configFileName) {
        this.loadConfig(configFileName);
        this.configFileName = configFileName;
    }

    private void loadConfig(String configFileName) {
        try {
            ApplicationConfig defaultConfig = new ApplicationConfig("agrosyst-default.properties");
            defaultConfig.loadDefaultOptions((ConfigOptionDef[])WebConfigOption.values());
            defaultConfig.parse(new String[0]);
            if (StringUtils.isNotBlank((CharSequence)configFileName)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Load config file name: " + configFileName));
                }
                Properties flatOptions = defaultConfig.getFlatOptions(false);
                this.config = new ApplicationConfig(flatOptions, configFileName);
                this.config.parse(new String[0]);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("jakarta.persistence.jdbc.url = " + this.config.getOption("jakarta.persistence.jdbc.url")));
                    LOGGER.debug((Object)("jakarta.persistence.jdbc.user = " + this.config.getOption("jakarta.persistence.jdbc.user")));
                    LOGGER.debug((Object)("hibernate.dialect = " + this.config.getOption("hibernate.dialect")));
                }
            } else {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info((Object)"No specific configuration provided, using the default one");
                }
                this.config = defaultConfig;
            }
        }
        catch (ArgumentsParserException ex) {
            throw new AgrosystTechnicalException("Can't read configuration", (Throwable)ex);
        }
    }

    public String getConfigFileName() {
        return this.configFileName;
    }

    public void reloadConfig() {
        this.loadConfig(this.configFileName);
    }

    public String getApplicationVersion() {
        return this.config.getOption(WebConfigOption.APPLICATION_VERSION.key);
    }

    public String getApplicationBuildDate() {
        return this.config.getOption(WebConfigOption.APPLICATION_BUILD_DATE.key);
    }

    public String getApplicationRevision() {
        return this.config.getOption(WebConfigOption.APPLICATION_REVISION.key);
    }

    public int getListResultsPerPage() {
        return this.config.getOptionAsInt(WebConfigOption.LIST_RESULTS_PER_PAGE.key);
    }

    public String getIgnKeyjs() {
        return this.config.getOption(WebConfigOption.IGN_KEYJS.key);
    }

    public long getUploadAttachmentsMaxSize() {
        return this.config.getOptionAsLong(WebConfigOption.UPLOAD_ATTACHMENTS_MAX_SIZE.key);
    }

    public long getUploadGlobalMaxSize() {
        return this.config.getOptionAsLong(WebConfigOption.UPLOAD_GLOBAL_MAX_SIZE.key);
    }

    public String getUploadAllowedExtensions() {
        return this.config.getOption(WebConfigOption.UPLOAD_ALLOWED_EXTENSIONS.key);
    }

    public int getHttpSessionTimeout() {
        return this.config.getOptionAsInt(WebConfigOption.SESSION_TIMEOUT.key);
    }

    public String getContactEmail() {
        return this.config.getOption(WebConfigOption.CONTACT_EMAIL.getKey());
    }

    public boolean isDemoModeEnabled() {
        return this.config.getOptionAsBoolean(WebConfigOption.DEMO_MODE.key);
    }

    public boolean isDephygraphConnexionEnabled() {
        String dephyGraphUrl = this.config.getOption(WebConfigOption.DEPHYGRAPH_URL.getKey());
        return StringUtils.isNotBlank((CharSequence)dephyGraphUrl);
    }

    public String getInstanceBannerText() {
        return this.config.getOption(WebConfigOption.INSTANCE_BANNER_TEXT.key);
    }

    public String getInstanceBannerStyle() {
        return this.config.getOption(WebConfigOption.INSTANCE_BANNER_STYLE.key);
    }

    public int getDomainsExportAsyncThreshold() {
        return this.config.getOptionAsInt(WebConfigOption.DOMAINS_EXPORT_ASYNC_THRESHOLD.key);
    }

    public int getPlotsExportAsyncThreshold() {
        return this.config.getOptionAsInt(WebConfigOption.PLOTS_EXPORT_ASYNC_THRESHOLD.key);
    }

    public int getGrowingPlansExportAsyncThreshold() {
        return this.config.getOptionAsInt(WebConfigOption.GROWING_PLANS_EXPORT_ASYNC_THRESHOLD.key);
    }

    public int getGrowingSystemsExportAsyncThreshold() {
        return this.config.getOptionAsInt(WebConfigOption.GROWING_SYSTEMS_EXPORT_ASYNC_THRESHOLD.key);
    }

    public int getEffectiveCropCyclesExportAsyncThreshold() {
        return this.config.getOptionAsInt(WebConfigOption.EFFECTIVE_CROP_CYCLES_EXPORT_ASYNC_THRESHOLD.key);
    }

    public int getEffectiveMeasurementsExportAsyncThreshold() {
        return this.config.getOptionAsInt(WebConfigOption.EFFECTIVE_MEASUREMENTS_EXPORT_ASYNC_THRESHOLD.key);
    }

    public int getManagementModesExportAsyncThreshold() {
        return this.config.getOptionAsInt(WebConfigOption.MANAGEMENT_MODES_EXPORT_ASYNC_THRESHOLD.key);
    }

    public int getDecisionRulesExportAsyncThreshold() {
        return this.config.getOptionAsInt(WebConfigOption.DECISION_RULES_EXPORT_ASYNC_THRESHOLD.key);
    }

    public int getPracticedSystemsExportAsyncThreshold() {
        return this.config.getOptionAsInt(WebConfigOption.PRACTICED_SYSTEMS_EXPORT_ASYNC_THRESHOLD.key);
    }

    public int getReportGrowingSystemsExportAsyncThreshold() {
        return this.config.getOptionAsInt(WebConfigOption.REPORT_GROWING_SYSTEMS_EXPORT_ASYNC_THRESHOLD.key);
    }

    public int getReportRegionalsExportAsyncThreshold() {
        return this.config.getOptionAsInt(WebConfigOption.REPORT_REGIONALS_EXPORT_ASYNC_THRESHOLD.key);
    }

    public String getJwtSecret() {
        String key = WebConfigOption.JWT_SECRET.key;
        String result = this.config.getOption(key);
        Preconditions.checkState((boolean)StringUtils.isNotEmpty((CharSequence)result), (Object)("La propri\u00e9t\u00e9 " + key + " est obligatoire"));
        return result;
    }

    public int getJwtRefreshSeconds() {
        int result = this.config.getOptionAsInt(WebConfigOption.JWT_REFRESH_SECONDS.key);
        return result;
    }

    public boolean isSecuredCookies() {
        String baseUrl = this.config.getOption(AgrosystServiceConfig.ServiceConfigOption.APPLICATION_BASE_URL.getKey());
        boolean result = baseUrl != null && baseUrl.startsWith("https://");
        return result;
    }

    public String getBaseUrl() {
        String baseUrl = this.config.getOption(AgrosystServiceConfig.ServiceConfigOption.APPLICATION_BASE_URL.getKey());
        return baseUrl != null ? baseUrl : "";
    }

    public OptionalInt getHazelcastPort() {
        int option = this.config.getOptionAsInt(WebConfigOption.HAZELCAST_PORT.key);
        if (option == 0) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(option);
    }

    public Optional<String> getHazelcastOutboundPorts() {
        String option = this.config.getOption(WebConfigOption.HAZELCAST_OUTBOUND_PORTS.key);
        Optional<String> result = Optional.ofNullable(StringUtils.trimToNull((String)option));
        return result;
    }

    public Optional<String> getHazelcastMembers() {
        String option = this.config.getOption(WebConfigOption.HAZELCAST_MEMBERS.key);
        Optional<String> result = Optional.ofNullable(StringUtils.trimToNull((String)option));
        return result;
    }

    public ApplicationConfig.OptionList getAllowedRestRequestOrigins() {
        return this.config.getOptionAsList(WebConfigOption.ALLOWED_REST_REQUEST_ORIGINS.key);
    }

    public Sector[] getIpmWorksSectors() {
        List sectorList = this.config.getOptionAsList(WebConfigOption.IPMWORKS_SECTORS.key).getOption();
        return (Sector[])sectorList.stream().map(Sector::valueOf).toArray(value -> new Sector[sectorList.size()]);
    }

    public LinkedHashMap<String, String> readConfigurationAsMap() throws ArgumentsParserException {
        ApplicationConfig configToPrint = new ApplicationConfig();
        configToPrint.setOptions(this.config.getFlatOptions());
        configToPrint.setOption("jakarta.persistence.jdbc.user", "*****");
        configToPrint.setOption("jakarta.persistence.jdbc.password", "*****");
        configToPrint.parse(new String[0]);
        for (WebConfigOption webConfigOption : WebConfigOption.values()) {
            if (configToPrint.getOption(webConfigOption.getKey()) != null) continue;
            configToPrint.setOption(webConfigOption.getKey(), webConfigOption.getDefaultValue());
        }
        for (WebConfigOption webConfigOption : AgrosystServiceConfig.ServiceConfigOption.values()) {
            if (configToPrint.getOption(webConfigOption.getKey()) != null) continue;
            configToPrint.setOption(webConfigOption.getKey(), webConfigOption.getDefaultValue());
        }
        HashMap<String, String> agrosystKeyValues = new HashMap<String, String>();
        HashMap<String, String> otherKeyValues = new HashMap<String, String>();
        for (String string : configToPrint.getFlatOptions().stringPropertyNames()) {
            String value = configToPrint.getOption(string);
            if (string.matches("agrosyst.*")) {
                agrosystKeyValues.put(string, value);
                continue;
            }
            otherKeyValues.put(string, value);
        }
        LinkedHashMap agrosystKeyValueSortedByKey = agrosystKeyValues.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        LinkedHashMap linkedHashMap = otherKeyValues.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        agrosystKeyValueSortedByKey.putAll(linkedHashMap);
        return agrosystKeyValueSortedByKey;
    }
}

