/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.rest.performances;

import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.Plot;
import fr.inra.agrosyst.api.entities.Zone;
import fr.inra.agrosyst.api.entities.performance.ActiveSubstance;
import fr.inra.agrosyst.api.entities.performance.DecomposedOperatingExpenses;
import fr.inra.agrosyst.api.entities.performance.ExportType;
import fr.inra.agrosyst.api.entities.performance.Ift;
import fr.inra.agrosyst.api.entities.performance.IndicatorFilter;
import fr.inra.agrosyst.api.entities.performance.IndicatorFilterImpl;
import fr.inra.agrosyst.api.entities.performance.MineralFertilization;
import fr.inra.agrosyst.api.entities.performance.OrganicFertilization;
import fr.inra.agrosyst.api.entities.performance.OrganicProduct;
import fr.inra.agrosyst.api.entities.performance.Performance;
import fr.inra.agrosyst.api.entities.performance.TotalFertilization;
import fr.inra.agrosyst.api.services.common.AttachmentService;
import fr.inra.agrosyst.api.services.performance.PerformanceService;
import fr.inra.agrosyst.api.utils.DaoUtils;
import fr.inra.agrosyst.services.performance.indicators.IndicatorOrganicProducts;
import fr.inra.agrosyst.services.performance.indicators.fertilization.IndicatorMineralFertilization;
import fr.inra.agrosyst.services.performance.indicators.fertilization.IndicatorOrganicFertilization;
import fr.inra.agrosyst.services.performance.indicators.fertilization.IndicatorTotalFertilization;
import fr.inra.agrosyst.services.performance.indicators.operatingexpenses.IndicatorDecomposedOperatingExpenses;
import fr.inra.agrosyst.services.performance.indicators.qsa.IndicatorActiveSubstanceAmount;
import fr.inra.agrosyst.services.performance.indicators.qsa.IndicatorNeonicotinoidsAmount;
import fr.inra.agrosyst.services.performance.indicators.qsa.IndicatorSoilAppliedHerbicidesAmount;
import fr.inra.agrosyst.web.rest.CustomInject;
import fr.inra.agrosyst.web.rest.Secured;
import fr.inra.agrosyst.web.rest.performances.Indicator;
import fr.inra.agrosyst.web.rest.performances.IndicatorUtils;
import fr.inra.agrosyst.web.rest.performances.Method;
import fr.inra.agrosyst.web.rest.performances.MethodUtils;
import fr.inra.agrosyst.web.rest.performances.PerformanceCreationEditionDto;
import fr.inra.agrosyst.web.rest.performances.PerformanceDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Secured
@Path(value="/performances")
public class PerformancesResource {
    @CustomInject
    private PerformanceService performanceService;
    @CustomInject
    private AttachmentService attachmentService;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response create(PerformanceCreationEditionDto performanceDto) {
        List indicatorFilters = this.buildIndicatorFilters(performanceDto);
        boolean computeOnReal = this.isComputeOnReal(performanceDto);
        boolean computeOnStandardised = this.isComputeOnStandardised(performanceDto);
        Performance performanceCreated = this.performanceService.createperformance(performanceDto.name(), performanceDto.domainIds(), performanceDto.growingSystemIds(), performanceDto.plotIds(), performanceDto.zoneIds(), indicatorFilters, Collections.emptySet(), performanceDto.exportToDb(), performanceDto.practiced());
        Response response = Response.status((Response.Status)Response.Status.CREATED).entity((Object)this.buildPerformanceDto(performanceCreated, 0)).build();
        return response;
    }

    @PUT
    @Path(value="/{topiaId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response update(@PathParam(value="topiaId") String topiaId, PerformanceCreationEditionDto performanceDto) {
        List indicatorFilters = this.buildIndicatorFilters(performanceDto);
        boolean computeOnReal = this.isComputeOnReal(performanceDto);
        boolean computeOnStandardised = this.isComputeOnStandardised(performanceDto);
        Performance performanceUpdated = this.performanceService.updatePerformance(topiaId, performanceDto.name(), performanceDto.domainIds(), performanceDto.growingSystemIds(), performanceDto.plotIds(), performanceDto.zoneIds(), indicatorFilters, Collections.emptySet(), performanceDto.exportToDb());
        int attachmentCount = this.attachmentService.getAttachmentMetadatas(performanceUpdated.getTopiaId()).size();
        Response response = Response.ok().entity((Object)this.buildPerformanceDto(performanceUpdated, attachmentCount)).build();
        return response;
    }

    private Performance buildPerformance(PerformanceCreationEditionDto performanceDto) {
        Performance performance = this.performanceService.newPerformance();
        this.editPerformance(performance, performanceDto);
        return performance;
    }

    private void editPerformance(Performance performance, PerformanceCreationEditionDto performanceDto) {
        performance.setName(performanceDto.name());
        performance.setPracticed(performanceDto.practiced());
    }

    private List<IndicatorFilter> buildIndicatorFilters(PerformanceCreationEditionDto performanceDto) {
        ArrayList<IndicatorFilter> indicatorFilters = new ArrayList<IndicatorFilter>();
        ArrayList does = new ArrayList();
        ArrayList ifts = new ArrayList();
        ArrayList mineralFertilizations = new ArrayList();
        ArrayList organicFertilizations = new ArrayList();
        ArrayList totalFertilizations = new ArrayList();
        ArrayList sasActiveSubstances = new ArrayList();
        ArrayList organicProducts = new ArrayList();
        for (Indicator indicator : performanceDto.indicators()) {
            indicator.getClazz().ifPresent(clazz -> {
                block9: {
                    block8: {
                        if (clazz.equals(IndicatorDecomposedOperatingExpenses.class)) {
                            indicator.getDoe().ifPresent(does::add);
                            return;
                        }
                        if (clazz.equals(IndicatorMineralFertilization.class)) {
                            indicator.getMineralFertilization().ifPresent(mineralFertilizations::add);
                            return;
                        }
                        if (clazz.equals(IndicatorOrganicFertilization.class)) {
                            indicator.getOrganicFertilization().ifPresent(organicFertilizations::add);
                            return;
                        }
                        if (clazz.equals(IndicatorTotalFertilization.class)) {
                            indicator.getTotalFertilization().ifPresent(totalFertilizations::add);
                            return;
                        }
                        if (clazz.equals(IndicatorActiveSubstanceAmount.class) || clazz.equals(IndicatorSoilAppliedHerbicidesAmount.class)) break block8;
                        if (!clazz.equals(IndicatorNeonicotinoidsAmount.class)) break block9;
                    }
                    indicator.getActiveSubstance().ifPresent(sasActiveSubstances::add);
                    return;
                }
                if (clazz.equals(IndicatorOrganicProducts.class)) {
                    indicator.getOrganicProduct().ifPresent(organicProducts::add);
                    return;
                }
                IndicatorFilterImpl filter = new IndicatorFilterImpl();
                filter.setClazz(((Class)indicator.getClazz().get()).getSimpleName());
                indicator.getHandleParameters().ifPresent(consumer -> consumer.accept(performanceDto.methods(), filter));
                indicatorFilters.add((IndicatorFilter)filter);
            });
            indicator.getIft().ifPresent(ifts::add);
            indicator.getClazzResolver().ifPresent(resolver -> {
                List classes = (List)resolver.apply(performanceDto.methods());
                List<IndicatorFilterImpl> filters = classes.stream().map(clazz -> {
                    IndicatorFilterImpl filter = new IndicatorFilterImpl();
                    filter.setClazz(clazz.getSimpleName());
                    indicator.getHandleParameters().ifPresent(consumer -> consumer.accept(performanceDto.methods(), filter));
                    return filter;
                }).toList();
                indicatorFilters.addAll(filters);
            });
        }
        this.createDecomposedOperatingExpensesIndicator(performanceDto, does, indicatorFilters);
        this.createIftIndicators(performanceDto, ifts, indicatorFilters);
        this.createMineralFertilizationIndicator(mineralFertilizations, indicatorFilters);
        this.createOrganicFertilizationIndicator(organicFertilizations, indicatorFilters);
        this.createTotalFertilizationIndicator(totalFertilizations, indicatorFilters);
        this.createSpecificActiveSubstanceAmountIndicator(performanceDto, sasActiveSubstances, indicatorFilters);
        this.createOrganicProductsIndicator(organicProducts, indicatorFilters);
        return indicatorFilters;
    }

    private void createDecomposedOperatingExpensesIndicator(PerformanceCreationEditionDto performanceDto, ArrayList<DecomposedOperatingExpenses> does, ArrayList<IndicatorFilter> indicatorFilters) {
        if (!does.isEmpty()) {
            IndicatorFilterImpl filter = new IndicatorFilterImpl();
            filter.setClazz(IndicatorDecomposedOperatingExpenses.class.getSimpleName());
            filter.setDoeIndicators(does);
            MethodUtils.CHARGES_METHODS_PARAMETER.accept(performanceDto.methods(), filter);
            indicatorFilters.add((IndicatorFilter)filter);
        }
    }

    private void createIftIndicators(PerformanceCreationEditionDto performanceDto, ArrayList<Ift> ifts, ArrayList<IndicatorFilter> indicatorFilters) {
        if (!ifts.isEmpty()) {
            ((List)IndicatorUtils.IFT_INDICATORS_PARAMETER.apply(performanceDto.methods())).forEach(clazz -> {
                IndicatorFilterImpl filter = new IndicatorFilterImpl();
                filter.setClazz(clazz.getSimpleName());
                filter.setIfts((Collection)ifts);
                indicatorFilters.add((IndicatorFilter)filter);
            });
        }
    }

    private void createMineralFertilizationIndicator(ArrayList<MineralFertilization> mineralFertilizations, ArrayList<IndicatorFilter> indicatorFilters) {
        if (!mineralFertilizations.isEmpty()) {
            IndicatorFilterImpl filter = new IndicatorFilterImpl();
            filter.setClazz(IndicatorMineralFertilization.class.getSimpleName());
            filter.setMineralFertilizations(mineralFertilizations);
            indicatorFilters.add((IndicatorFilter)filter);
        }
    }

    private void createOrganicFertilizationIndicator(ArrayList<OrganicFertilization> organicFertilizations, ArrayList<IndicatorFilter> indicatorFilters) {
        if (!organicFertilizations.isEmpty()) {
            IndicatorFilterImpl filter = new IndicatorFilterImpl();
            filter.setClazz(IndicatorOrganicFertilization.class.getSimpleName());
            filter.setOrganicFertilizations(organicFertilizations);
            indicatorFilters.add((IndicatorFilter)filter);
        }
    }

    private void createTotalFertilizationIndicator(ArrayList<TotalFertilization> totalFertilizations, ArrayList<IndicatorFilter> indicatorFilters) {
        if (!totalFertilizations.isEmpty()) {
            IndicatorFilterImpl filter = new IndicatorFilterImpl();
            filter.setClazz(IndicatorTotalFertilization.class.getSimpleName());
            filter.setTotalFertilizations(totalFertilizations);
            indicatorFilters.add((IndicatorFilter)filter);
        }
    }

    private void createSpecificActiveSubstanceAmountIndicator(PerformanceCreationEditionDto performanceDto, ArrayList<ActiveSubstance> sasActiveSubstances, ArrayList<IndicatorFilter> indicatorFilters) {
        if (!sasActiveSubstances.isEmpty()) {
            IndicatorFilterImpl filter = new IndicatorFilterImpl();
            filter.setClazz(IndicatorActiveSubstanceAmount.class.getSimpleName());
            filter.setActiveSubstances(sasActiveSubstances);
            MethodUtils.SUBSTANCES_ACTIVES_SPECIFIQUES_METHODS_PARAMETER.accept(performanceDto.methods(), filter);
            indicatorFilters.add((IndicatorFilter)filter);
            if (sasActiveSubstances.contains(ActiveSubstance.NEONICOTINOIDES)) {
                IndicatorFilterImpl neonicotinoidesFilter = new IndicatorFilterImpl();
                neonicotinoidesFilter.setClazz(IndicatorNeonicotinoidsAmount.class.getSimpleName());
                MethodUtils.SUBSTANCES_ACTIVES_SPECIFIQUES_METHODS_PARAMETER.accept(performanceDto.methods(), neonicotinoidesFilter);
                indicatorFilters.add((IndicatorFilter)neonicotinoidesFilter);
            }
            if (sasActiveSubstances.contains(ActiveSubstance.HERBICIDES_RACINAIRES)) {
                IndicatorFilterImpl soilAppliedHerbicidesAmountFilter = new IndicatorFilterImpl();
                soilAppliedHerbicidesAmountFilter.setClazz(IndicatorSoilAppliedHerbicidesAmount.class.getSimpleName());
                MethodUtils.SUBSTANCES_ACTIVES_SPECIFIQUES_METHODS_PARAMETER.accept(performanceDto.methods(), soilAppliedHerbicidesAmountFilter);
                indicatorFilters.add((IndicatorFilter)soilAppliedHerbicidesAmountFilter);
            }
        }
    }

    private void createOrganicProductsIndicator(ArrayList<OrganicProduct> organicProducts, ArrayList<IndicatorFilter> indicatorFilters) {
        if (!organicProducts.isEmpty()) {
            IndicatorFilterImpl filter = new IndicatorFilterImpl();
            filter.setClazz(IndicatorOrganicProducts.class.getSimpleName());
            filter.setOrganicProducts(organicProducts);
            indicatorFilters.add((IndicatorFilter)filter);
        }
    }

    private boolean isComputeOnReal(PerformanceCreationEditionDto performanceDto) {
        return performanceDto.methods().contains(Method.PRIX_REELS_CHARGES) || performanceDto.methods().contains(Method.PRIX_REELS_PRODUITS_MARGES);
    }

    private boolean isComputeOnStandardised(PerformanceCreationEditionDto performanceDto) {
        return performanceDto.methods().contains(Method.PRIX_STANDARDISES_MILLESIMES_CHARGES) || performanceDto.methods().contains(Method.PRIX_STANDARDISES_MILLESIMES_PRODUITS_MARGES);
    }

    private PerformanceDto buildPerformanceDto(Performance performance, int attachmentCount) {
        Set methods = MethodUtils.CONVERT_TO_METHODS((Collection)performance.getIndicatorFilter());
        Set indicators = IndicatorUtils.CONVERT_TO_INDICATORS((Collection)performance.getIndicatorFilter());
        Collection domainsTopiaIds = DaoUtils.getShortenIds((Collection)performance.getDomainsTopiaIds(), Domain.class);
        Collection growingSystemsTopiaIds = DaoUtils.getShortenIds((Collection)performance.getGrowingSystemsTopiaIds(), GrowingSystem.class);
        Collection plotsTopiaIds = DaoUtils.getShortenIds((Collection)performance.getPlotsTopiaIds(), Plot.class);
        Collection zonesTopiaIds = DaoUtils.getShortenIds((Collection)performance.getZonesTopiaIds(), Zone.class);
        PerformanceDto performanceDto = new PerformanceDto(performance.getTopiaId(), performance.getName(), performance.isPracticed(), methods, indicators, domainsTopiaIds, growingSystemsTopiaIds, plotsTopiaIds, zonesTopiaIds, ExportType.DB.equals((Object)performance.getExportType()), performance.getComputeStatus(), attachmentCount);
        return performanceDto;
    }

    @GET
    @Path(value="/{topiaId}")
    @Produces(value={"application/json"})
    public Response read(@PathParam(value="topiaId") String topiaId) {
        Performance performance = this.performanceService.getPerformance(topiaId);
        int attachmentCount = this.attachmentService.getAttachmentMetadatas(performance.getTopiaId()).size();
        Response response = Response.ok().entity((Object)this.buildPerformanceDto(performance, attachmentCount)).build();
        return response;
    }
}

