/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.rest.growingsystems;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.Sector;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemFilter;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemService;
import fr.inra.agrosyst.api.utils.DaoUtils;
import fr.inra.agrosyst.web.rest.CustomInject;
import fr.inra.agrosyst.web.rest.Secured;
import fr.inra.agrosyst.web.rest.common.PaginationResultDto;
import fr.inra.agrosyst.web.rest.growingsystems.GrowingSystemDto;
import fr.inra.agrosyst.web.rest.growingsystems.GrowingSystemRequestFilter;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.CookieParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.util.pagination.PaginationResult;

@Secured
@Path(value="/growing-systems")
public class GrowingSystemsResource {
    @CustomInject
    private GrowingSystemService growingSystemService;

    private GrowingSystemFilter buildFilter(NavigationContext navigationContext, Set<String> selectedDomains, String name, String domainName, String growingPlanName, Integer campaign, Sector sector, String dephyNumber, Boolean active, Set<String> selectedIds, Integer pageNumber, Integer pageSize) {
        GrowingSystemFilter filter = new GrowingSystemFilter();
        NavigationContext context = this.mergeNavigationContext(navigationContext, selectedDomains);
        filter.setNavigationContext(context);
        filter.setGrowingSystemName(name);
        filter.setDomainName(domainName);
        filter.setGrowingPlanName(growingPlanName);
        filter.setCampaign(campaign);
        filter.setSector(sector);
        filter.setDephyNumber(dephyNumber);
        filter.setActive(active);
        if (selectedIds != null && !selectedIds.isEmpty()) {
            filter.setSelectedIds(selectedIds);
        }
        if (pageNumber != null) {
            filter.setPage(pageNumber.intValue());
        }
        if (pageSize != null) {
            filter.setPageSize(pageSize.intValue());
        }
        return filter;
    }

    private NavigationContext mergeNavigationContext(NavigationContext context, Set<String> selectedDomains) {
        NavigationContext navigationContext = new NavigationContext(context.getCampaigns(), context.getNetworks(), selectedDomains != null && !selectedDomains.isEmpty() ? selectedDomains : context.getDomains(), context.getGrowingPlans(), context.getGrowingSystems());
        return navigationContext;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response readAll(@CookieParam(value="nav.context") Cookie jsonContext, GrowingSystemRequestFilter request) throws JsonProcessingException {
        NavigationContext context = jsonContext != null ? (NavigationContext)new ObjectMapper().readValue(URLDecoder.decode(jsonContext.getValue(), StandardCharsets.UTF_8), NavigationContext.class) : new NavigationContext();
        GrowingSystemFilter filter = this.buildFilter(context, request.getSelectedDomains(), request.getName(), request.getDomainName(), request.getGorwinPlanName(), request.getCampaign(), request.getSector(), request.getDephyNumber(), request.getActive(), request.getSelectedIds(), request.getPageNumber(), request.getPageSize());
        PaginationResult paginationResult = this.growingSystemService.getFilteredGrowingSystems(filter);
        List<GrowingSystemDto> growingSystems = paginationResult.getElements().stream().map(arg_0 -> this.convertToDto(arg_0)).toList();
        Response response = Response.ok().entity((Object)new PaginationResultDto(growingSystems, paginationResult.getCount(), paginationResult.getCurrentPage())).build();
        return response;
    }

    private GrowingSystemDto convertToDto(GrowingSystem gs) {
        String domainName = gs.getGrowingPlan() != null && gs.getGrowingPlan().getDomain() != null ? gs.getGrowingPlan().getDomain().getName() : "";
        String growingPlanName = gs.getGrowingPlan() != null ? gs.getGrowingPlan().getName() : "";
        int campaign = gs.getGrowingPlan() != null && gs.getGrowingPlan().getDomain() != null ? gs.getGrowingPlan().getDomain().getCampaign() : 0;
        GrowingSystemDto growingSystemDto = new GrowingSystemDto(StringUtils.remove((String)gs.getTopiaId(), (String)GrowingSystem.class.getName()), gs.getName(), domainName, growingPlanName, campaign, gs.getSector(), gs.getDephyNumber(), gs.isActive());
        return growingSystemDto;
    }

    @POST
    @Path(value="/filtered-ids")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response readIds(@CookieParam(value="nav.context") Cookie jsonContext, GrowingSystemRequestFilter request) throws JsonProcessingException {
        NavigationContext context = jsonContext != null ? (NavigationContext)new ObjectMapper().readValue(URLDecoder.decode(jsonContext.getValue(), StandardCharsets.UTF_8), NavigationContext.class) : new NavigationContext();
        GrowingSystemFilter filter = this.buildFilter(context, request.getSelectedDomains(), request.getName(), request.getDomainName(), request.getGorwinPlanName(), request.getCampaign(), request.getSector(), request.getDephyNumber(), request.getActive(), null, null, null);
        Collection ids = DaoUtils.getShortenIds((Collection)this.growingSystemService.getFilteredGrowingSystemIds(filter), GrowingSystem.class);
        Response response = Response.ok().entity((Object)ids).build();
        return response;
    }
}

