/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.rest.growingplans;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.GrowingPlan;
import fr.inra.agrosyst.api.entities.TypeDEPHY;
import fr.inra.agrosyst.api.services.growingplan.GrowingPlanFilter;
import fr.inra.agrosyst.api.services.growingplan.GrowingPlanService;
import fr.inra.agrosyst.api.services.security.AuthorizationService;
import fr.inra.agrosyst.web.rest.CustomInject;
import fr.inra.agrosyst.web.rest.Secured;
import fr.inra.agrosyst.web.rest.common.PaginationResultDto;
import fr.inra.agrosyst.web.rest.growingplans.GrowingPlanDto;
import fr.inra.agrosyst.web.rest.growingplans.GrowingPlanRequestFilter;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.CookieParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.util.pagination.PaginationResult;

@Secured
@Path(value="/growing-plans")
public class GrowingPlansResource {
    @CustomInject
    private GrowingPlanService growingPlanService;
    @CustomInject
    private AuthorizationService authorizationService;

    private GrowingPlanFilter buildFilter(NavigationContext context, String name, String domainName, Integer campaign, TypeDEPHY typeDEPHY, String responsable, Boolean active, Set<String> selectedIds, Integer pageNumber, Integer pageSize) {
        GrowingPlanFilter filter = new GrowingPlanFilter();
        filter.setNavigationContext(context);
        filter.setGrowingPlanName(name);
        filter.setDomainName(domainName);
        filter.setCampaign(campaign);
        filter.setTypeDephy(typeDEPHY);
        filter.setResponsable(responsable);
        filter.setActive(active);
        if (selectedIds != null && !selectedIds.isEmpty()) {
            filter.setSelectedIds(selectedIds);
        }
        if (pageNumber != null) {
            filter.setPage(pageNumber.intValue());
        }
        if (pageSize != null) {
            filter.setPageSize(pageSize.intValue());
        }
        return filter;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response readAll(@CookieParam(value="nav.context") Cookie jsonContext, GrowingPlanRequestFilter requestFilter) throws JsonProcessingException {
        NavigationContext context = jsonContext != null ? (NavigationContext)new ObjectMapper().readValue(URLDecoder.decode(jsonContext.getValue(), StandardCharsets.UTF_8), NavigationContext.class) : new NavigationContext();
        GrowingPlanFilter filter = this.buildFilter(context, requestFilter.getName(), requestFilter.getDomainName(), requestFilter.getCampaign(), requestFilter.getTypeDEPHY(), requestFilter.getResponsable(), requestFilter.getActive(), requestFilter.getSelectedIds(), requestFilter.getPageNumber(), requestFilter.getPageSize());
        PaginationResult paginationResult = this.growingPlanService.getFilteredGrowingPlans(filter);
        List<GrowingPlanDto> growingPlans = paginationResult.getElements().stream().map(gp -> {
            List responsibles = this.authorizationService.getGrowingPlanResponsibles(gp.getCode());
            String responsiblesAsStr = responsibles.stream().map(r -> r.getFirstName() + " " + r.getLastName()).collect(Collectors.joining(", "));
            return this.convertToDto(gp, responsiblesAsStr);
        }).toList();
        return Response.ok().entity((Object)new PaginationResultDto(growingPlans, paginationResult.getCount(), paginationResult.getCurrentPage())).build();
    }

    private GrowingPlanDto convertToDto(GrowingPlan gp, String responsibles) {
        String domainName = gp.getDomain() != null ? gp.getDomain().getName() : "";
        int campaign = gp.getDomain() != null ? gp.getDomain().getCampaign() : 0;
        return new GrowingPlanDto(StringUtils.remove((String)gp.getTopiaId(), (String)GrowingPlan.class.getName()), gp.getName(), domainName, campaign, gp.getType(), responsibles, gp.isActive());
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/filtered-ids")
    @Produces(value={"application/json"})
    public Response readIds(@CookieParam(value="nav.context") Cookie jsonContext, GrowingPlanRequestFilter requestFilter) throws JsonProcessingException {
        NavigationContext context = jsonContext != null ? (NavigationContext)new ObjectMapper().readValue(URLDecoder.decode(jsonContext.getValue(), StandardCharsets.UTF_8), NavigationContext.class) : new NavigationContext();
        GrowingPlanFilter filter = this.buildFilter(context, requestFilter.getName(), requestFilter.getDomainName(), requestFilter.getCampaign(), requestFilter.getTypeDEPHY(), requestFilter.getResponsable(), requestFilter.getActive(), null, null, null);
        Set ids = this.growingPlanService.getFilteredGrowingPlanIds(filter);
        return Response.ok().entity((Object)ids).build();
    }
}

