/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.filters;

import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.exceptions.SignatureVerificationException;
import com.auth0.jwt.exceptions.TokenExpiredException;
import com.google.common.collect.ImmutableSet;
import fr.inra.agrosyst.api.services.security.AuthenticationService;
import fr.inra.agrosyst.api.services.users.AuthenticatedUser;
import fr.inra.agrosyst.services.AgrosystServiceConfig;
import fr.inra.agrosyst.services.ServiceContext;
import fr.inra.agrosyst.web.AgrosystWebApplicationContext;
import fr.inra.agrosyst.web.AgrosystWebConfig;
import fr.inra.agrosyst.web.CookieHelper;
import fr.inra.agrosyst.web.actions.security.JwtHelper;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AgrosystWebAuthenticationFilter
implements Filter {
    private static final Log LOGGER = LogFactory.getLog(AgrosystWebAuthenticationFilter.class);
    public static final String AGROSYST_WEB_LOGIN_ACTION = "/auth/login.action";
    public static final String AGROSYST_WEB_LOGIN_ACTION_INPUT = "/auth/login-input.action";
    public static final String AGROSYST_WEB_CHARTER_ACTION = "/auth/charter.action";
    public static final String AGROSYST_WEB_CHARTER_ACTION_INPUT = "/auth/charter-input.action";
    public static final String IPMWORKS_WEB_LOGIN_ACTION = "/ipmworks/auth/login.action";
    public static final String IPMWORKS_WEB_LOGIN_ACTION_INPUT = "/ipmworks/auth/login-input.action";
    protected static final Set<String> PUBLIC_URLS = ImmutableSet.of((Object)"/auth/login.action", (Object)"/auth/login-input.action", (Object)"/auth/login-json.action", (Object)"/auth/charter.action", (Object)"/auth/charter-input.action", (Object)"/auth/forgotten-password.action", (Object[])new String[]{"/auth/forgotten-password-input.action", "/auth/forgotten-password-json.action", "/auth/retrieve-password.action", "/auth/retrieve-password-input.action", "/auth/logout.action", "/auth/logout-json.action", "/auth/legal.action", "/commons/help-raw.action", "/commons/endpoints.action", "/admin/status-json.action", "/ipmworks/auth/login.action", "/ipmworks/auth/login-input.action"});
    protected static final Set<String> STATIC_RESOURCES = ImmutableSet.of((Object)"/favicon.ico", (Object)"/ipmworks/favicon.ico", (Object)"/js/", (Object)"/img/", (Object)"/help/", (Object)"/font/", (Object[])new String[]{"/webjars/", "/nuiton-js/"});
    public static final String AUTHENTICATED_USER = "authenticatedUser";
    protected static final Function<HttpServletRequest, String> GET_FULL_REQUESTED_URI = input -> {
        String queryString;
        String contextPath = input.getContextPath();
        Object requestURI = input.getRequestURI();
        if (((String)requestURI).startsWith("/context/") || ((String)requestURI).startsWith(contextPath + "/js/") || ((String)requestURI).startsWith(contextPath + "/help/") || ((String)requestURI).startsWith(contextPath + "/img/") || ((String)requestURI).startsWith(contextPath + "/font/") || ((String)requestURI).startsWith(contextPath + "/webjars/") || ((String)requestURI).startsWith(contextPath + "/nuiton-js/")) {
            requestURI = contextPath + "/";
        }
        Object result = (queryString = input.getQueryString()) == null ? requestURI : String.format("%s?%s", requestURI, queryString);
        return result;
    };
    protected static final Function<HttpServletRequest, String> GET_REDIRECT_TO_LOGIN_PAGE_URI = input -> {
        String contextPath = input.getContextPath();
        String servletPath = input.getServletPath();
        Object result = "";
        if (!"/".equals(contextPath)) {
            result = (String)result + contextPath;
        }
        result = servletPath.startsWith("/ipmworks") ? (String)result + IPMWORKS_WEB_LOGIN_ACTION_INPUT : (String)result + AGROSYST_WEB_LOGIN_ACTION_INPUT;
        return result;
    };
    protected static final Function<HttpServletRequest, String> GET_REDIRECT_TO_CHARTER_PAGE_URI = input -> {
        String contextPath = input.getContextPath();
        Object result = "/".equals(contextPath) ? AGROSYST_WEB_CHARTER_ACTION_INPUT : contextPath + AGROSYST_WEB_CHARTER_ACTION_INPUT;
        return result;
    };
    protected AgrosystWebApplicationContext webApplicationContext;

    public void init(FilterConfig filterConfig) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Initializing " + AgrosystWebAuthenticationFilter.class.getName()));
        }
        ServletContext servletContext = filterConfig.getServletContext();
        this.webApplicationContext = (AgrosystWebApplicationContext)servletContext.getAttribute(AgrosystWebApplicationContext.APPLICATION_CONTEXT_PARAMETER);
    }

    protected Optional<AuthenticatedUser> refreshIfNecessary(Optional<AuthenticatedUser> authenticatedUserOptional, Optional<String> jwtToken, JwtHelper jwtHelper, CookieHelper cookieHelper) {
        Optional result = authenticatedUserOptional;
        if (authenticatedUserOptional.isPresent() && jwtToken.isPresent()) {
            Date issuedAt = jwtHelper.getTokenIssuedAt(jwtToken.get());
            Duration tokenAge = Duration.between(issuedAt.toInstant(), new Date().toInstant());
            int refreshSeconds = this.webApplicationContext.getWebConfig().getJwtRefreshSeconds();
            if (tokenAge.toSeconds() > (long)refreshSeconds) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info((Object)String.format("Token \u00e9mis depuis plus de %d secondes, on va la rafra\u00eechir", refreshSeconds));
                }
                String userId = authenticatedUserOptional.get().getTopiaId();
                String sid = authenticatedUserOptional.get().getSid();
                result = this.loadUserDto(userId, sid);
                result.ifPresent(user -> this.webApplicationContext.writeAuthenticationCookie(user, cookieHelper));
            }
        }
        return result;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)request;
            if (response instanceof HttpServletResponse) {
                boolean acceptedCharter;
                AgrosystServiceConfig serviceConfig;
                boolean authenticated;
                String origin;
                HttpServletResponse httpServletResponse = (HttpServletResponse)response;
                List allowedRestRequestOrigins = this.webApplicationContext.getWebConfig().getAllowedRestRequestOrigins().getOption();
                if (allowedRestRequestOrigins.contains(origin = httpServletRequest.getHeader("origin"))) {
                    httpServletResponse.addHeader("Access-Control-Allow-Origin", origin);
                    httpServletResponse.addHeader("Access-Control-Allow-Credentials", "true");
                }
                String servletPath = httpServletRequest.getServletPath();
                boolean publicAction = PUBLIC_URLS.contains(servletPath);
                boolean staticResource = STATIC_RESOURCES.stream().anyMatch(servletPath::startsWith);
                boolean publicUrl = publicAction || staticResource;
                boolean jsonRequest = servletPath.endsWith("json.action");
                boolean requestContextWhenNotLogin = httpServletRequest.getRequestURI().startsWith("/context/");
                boolean requestAdminAction = httpServletRequest.getRequestURI().startsWith("/admin/");
                Optional<Object> authenticatedUser = Optional.empty();
                if (!staticResource) {
                    try {
                        AgrosystWebConfig webConfig = this.webApplicationContext.getWebConfig();
                        JwtHelper jwtHelper = new JwtHelper(webConfig);
                        CookieHelper cookieHelper = new CookieHelper(httpServletRequest, httpServletResponse, webConfig);
                        Optional jwtToken = this.webApplicationContext.readAuthenticationCookie(cookieHelper);
                        authenticatedUser = jwtToken.map(arg_0 -> ((JwtHelper)jwtHelper).verifyJwtToken(arg_0));
                        if (!publicUrl) {
                            authenticatedUser = this.refreshIfNecessary(authenticatedUser, jwtToken, jwtHelper, cookieHelper);
                        }
                        authenticatedUser.ifPresent(userDto -> httpServletRequest.setAttribute(AUTHENTICATED_USER, userDto));
                    }
                    catch (TokenExpiredException tee) {
                        LOGGER.warn((Object)("Token expir\u00e9 : " + tee.getMessage()));
                    }
                    catch (SignatureVerificationException sve) {
                        LOGGER.warn((Object)("Signature du token invalide : " + sve.getMessage()));
                    }
                    catch (JWTDecodeException jde) {
                        LOGGER.warn((Object)("Token invalide : " + jde.getMessage()));
                    }
                }
                if ((authenticated = authenticatedUser.isPresent()) && !publicUrl && !authenticatedUser.map(AuthenticatedUser::isAdmin).get().booleanValue() && (serviceConfig = this.webApplicationContext.getServiceConfig()).isMaintenanceModeActive() && serviceConfig.isMaintenanceModeDisconnectAllUsers()) {
                    authenticated = false;
                }
                boolean bl = acceptedCharter = authenticatedUser.isEmpty() || authenticatedUser.map(AuthenticatedUser::isAcceptedCharter).get() != false;
                if (LOGGER.isTraceEnabled()) {
                    String message = String.format("Is '%s' [publicUrl=%b] [authenticated=%b] [acceptedCharter=%b]", servletPath, publicUrl, authenticated, acceptedCharter);
                    LOGGER.trace((Object)message);
                }
                if (publicUrl) {
                    chain.doFilter(request, response);
                } else if (authenticated && acceptedCharter) {
                    chain.doFilter(request, response);
                } else if (!authenticated && (jsonRequest || requestContextWhenNotLogin || requestAdminAction)) {
                    this.failWithUnauthorizedError(httpServletResponse);
                } else if (!authenticated) {
                    this.redirectToLoginPage(httpServletRequest, httpServletResponse);
                } else {
                    this.redirectToCharterPage(httpServletRequest, httpServletResponse);
                }
            }
        }
    }

    protected Optional<AuthenticatedUser> loadUserDto(String userId, String sid) {
        Optional<AuthenticatedUser> optional;
        block8: {
            ServiceContext serviceContext = this.webApplicationContext.getApplicationContext().newServiceContext();
            try {
                AuthenticationService authenticationService = (AuthenticationService)serviceContext.newService(AuthenticationService.class);
                AuthenticatedUser newUserDto = authenticationService.getAuthenticatedUserFromUserId(userId, sid);
                optional = Optional.of(newUserDto);
                if (serviceContext == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (serviceContext != null) {
                        try {
                            serviceContext.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception eee) {
                    LOGGER.warn((Object)"Unable to close serviceContext", (Throwable)eee);
                    return Optional.empty();
                }
            }
            serviceContext.close();
        }
        return optional;
    }

    private void failWithUnauthorizedError(HttpServletResponse httpServletResponse) throws IOException {
        httpServletResponse.sendError(401, "Vous n'\u00eates plus connect\u00e9");
    }

    private void redirectToLoginPage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String redirectPageUri = (String)GET_REDIRECT_TO_LOGIN_PAGE_URI.apply(httpServletRequest);
        String requestedUri = (String)GET_FULL_REQUESTED_URI.apply(httpServletRequest);
        String queryString = "?next=" + URLEncoder.encode(requestedUri, StandardCharsets.UTF_8);
        httpServletResponse.sendRedirect(redirectPageUri + queryString);
    }

    private void redirectToCharterPage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String redirectPageUri = (String)GET_REDIRECT_TO_CHARTER_PAGE_URI.apply(httpServletRequest);
        String requestedUri = (String)GET_FULL_REQUESTED_URI.apply(httpServletRequest);
        String queryString = "?next=" + URLEncoder.encode(requestedUri, StandardCharsets.UTF_8);
        httpServletResponse.sendRedirect(redirectPageUri + queryString);
    }

    public void destroy() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Destroying " + AgrosystWebAuthenticationFilter.class.getName()));
        }
    }
}

