/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.reports;

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.services.report.ReportGrowingSystemDto;
import fr.inra.agrosyst.api.services.report.ReportGrowingSystemFilter;
import fr.inra.agrosyst.api.services.report.ReportService;
import fr.inra.agrosyst.web.actions.reports.AbstractReportAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.pagination.PaginationResult;

public class ReportGrowingSystemsList
extends AbstractReportAction {
    private static final Log LOGGER = LogFactory.getLog(ReportGrowingSystemsList.class);
    private static final long serialVersionUID = -5631153546808063018L;
    protected transient ReportService reportService;
    protected PaginationResult<ReportGrowingSystemDto> reportGrowingSystems;
    protected ReportGrowingSystemFilter reportGrowingSystemFilter;
    protected int reportGrowingSystemsExportAsyncThreshold;

    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public String execute() {
        try {
            NavigationContext navigationContext = this.getNavigationContext();
            this.reportGrowingSystemFilter = new ReportGrowingSystemFilter();
            this.reportGrowingSystemFilter.setNavigationContext(navigationContext);
            this.reportGrowingSystemFilter.setPageSize(this.getListNbElementByPage(ReportGrowingSystemDto.class).intValue());
            this.reportGrowingSystems = this.reportService.getAllReportGrowingSystem(this.reportGrowingSystemFilter);
            this.reportGrowingSystemsExportAsyncThreshold = this.config.getReportGrowingSystemsExportAsyncThreshold();
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Failed to load report growing system list", (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    public PaginationResult<ReportGrowingSystemDto> getReportGrowingSystems() {
        return this.reportGrowingSystems;
    }

    public ReportGrowingSystemFilter getReportGrowingSystemFilter() {
        return this.reportGrowingSystemFilter;
    }

    public int getReportGrowingSystemsExportAsyncThreshold() {
        return this.reportGrowingSystemsExportAsyncThreshold;
    }
}

