/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.plots;

import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import fr.inra.agrosyst.api.entities.BufferStrip;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.Entities;
import fr.inra.agrosyst.api.entities.FrostProtectionType;
import fr.inra.agrosyst.api.entities.Ground;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.HosesPositionning;
import fr.inra.agrosyst.api.entities.IrrigationSystemType;
import fr.inra.agrosyst.api.entities.MaxSlope;
import fr.inra.agrosyst.api.entities.Plot;
import fr.inra.agrosyst.api.entities.PlotImpl;
import fr.inra.agrosyst.api.entities.PompEngineType;
import fr.inra.agrosyst.api.entities.SolWaterPh;
import fr.inra.agrosyst.api.entities.WaterFlowDistance;
import fr.inra.agrosyst.api.entities.Zone;
import fr.inra.agrosyst.api.entities.ZoneType;
import fr.inra.agrosyst.api.entities.measure.MeasurementSession;
import fr.inra.agrosyst.api.entities.referential.RefElementVoisinage;
import fr.inra.agrosyst.api.entities.referential.RefParcelleZonageEDI;
import fr.inra.agrosyst.api.entities.referential.RefSolCaracteristiqueIndigo;
import fr.inra.agrosyst.api.entities.referential.RefSolProfondeurIndigo;
import fr.inra.agrosyst.api.entities.referential.RefSolTextureGeppa;
import fr.inra.agrosyst.api.services.common.UsageList;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemService;
import fr.inra.agrosyst.api.services.plot.PlotService;
import fr.inra.agrosyst.api.services.plot.Plots;
import fr.inra.agrosyst.api.services.plot.SolHorizonDto;
import fr.inra.agrosyst.api.services.referential.ReferentialService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.Preparable;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.nuiton.topia.persistence.TopiaEntity;

public class PlotsEdit
extends AbstractAgrosystAction
implements Preparable {
    private static final long serialVersionUID = -4471100957699944974L;
    private static final Log LOGGER = LogFactory.getLog(PlotsEdit.class);
    private static final String INCORRECT_PLOT_AREA = "Surface incorrecte";
    private static final String LOWER_PLOT_AREA = "La surface de la parcelle doit \u00eatre sup\u00e9rieur ou \u00e9gale \u00e0 la surface totale des zones";
    protected transient DomainService domainService;
    protected transient PlotService plotService;
    protected transient GrowingSystemService growingSystemService;
    protected transient ReferentialService referentialService;
    protected String plotTopiaId;
    protected Plot plot;
    protected LinkedHashMap<Integer, String> relatedPlots;
    protected List<GrowingSystem> growingSystems;
    protected String growingSystemTopiaId;
    protected boolean changeableGrowingSystem;
    protected String locationTopiaId;
    protected String domainTopiaId;
    protected Domain domain;
    protected List<Ground> grounds;
    protected List<RefParcelleZonageEDI> parcelleZonages;
    protected List<String> selectedPlotZoningIds;
    protected String selectedSolId;
    protected List<RefSolTextureGeppa> solTextures;
    protected String selectedSurfaceTextureId;
    protected String selectedSubSoilTextureId;
    protected List<RefSolProfondeurIndigo> solProfondeurs;
    protected String selectedSolProfondeurId;
    protected List<SolHorizonDto> solHorizons;
    protected List<RefSolCaracteristiqueIndigo> solCaracteristiques;
    protected List<Zone> zones;
    protected UsageList<Zone> zonesUsageList;
    protected List<RefElementVoisinage> adjacentElements;
    protected List<String> adjacentElementIds;
    protected List<MeasurementSession> measurementSessions;

    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }

    public void setPlotService(PlotService plotService) {
        this.plotService = plotService;
    }

    public void setGrowingSystemService(GrowingSystemService growingSystemService) {
        this.growingSystemService = growingSystemService;
    }

    public void setReferentialService(ReferentialService referentialService) {
        this.referentialService = referentialService;
    }

    public void prepare() {
        this.plot = this.plotService.getPlot(this.plotTopiaId);
        if (this.plot != null) {
            if (this.plot.isPersisted()) {
                this.authorizationService.checkPlotReadable(this.plotTopiaId);
                boolean bl = this.readOnly = !this.authorizationService.isPlotWritable(this.plotTopiaId);
                if (this.readOnly) {
                    this.notificationSupport.plotNotWritable();
                }
                boolean bl2 = this.activated = this.plot.isActive() && this.plot.getDomain().isActive();
            }
            if (this.plot.getGrowingSystem() == null) {
                this.changeableGrowingSystem = true;
            } else {
                this.growingSystemTopiaId = this.plot.getGrowingSystem().getTopiaId();
                this.changeableGrowingSystem = this.authorizationService.isGrowingSystemWritable(this.growingSystemTopiaId);
            }
        }
    }

    @Action(value="plots-edit-input")
    public String input() throws Exception {
        this.initForInput();
        if (this.plot.getLocation() != null) {
            this.locationTopiaId = this.plot.getLocation().getTopiaId();
        }
        if (this.plot.getPlotZonings() != null) {
            this.selectedPlotZoningIds = this.plot.getPlotZonings().stream().map(Entities.GET_TOPIA_ID).collect(Collectors.toList());
        }
        if (this.plot.getGround() != null) {
            this.selectedSolId = this.plot.getGround().getTopiaId();
        }
        if (this.plot.getSurfaceTexture() != null) {
            this.selectedSurfaceTextureId = this.plot.getSurfaceTexture().getTopiaId();
        }
        if (this.plot.getSubSoilTexture() != null) {
            this.selectedSubSoilTextureId = this.plot.getSubSoilTexture().getTopiaId();
        }
        if (this.plot.getSolDepth() != null) {
            this.selectedSolProfondeurId = this.plot.getSolDepth().getTopiaId();
        }
        this.solHorizons = this.plot.getSolHorizon() != null ? Lists.newArrayList((Iterable)Collections2.transform((Collection)this.plot.getSolHorizon(), Plots.SOL_HORIZON_TO_DTO::apply)) : new ArrayList();
        this.adjacentElementIds = this.plot.getAdjacentElements() != null ? this.plot.getAdjacentElements().stream().map(Entities.GET_TOPIA_ID).collect(Collectors.toList()) : new ArrayList();
        this.zones = this.plotService.getPlotZones(this.plot);
        this.zonesUsageList = this.plotService.getZonesAndUsages(this.plot.getTopiaId());
        return "input";
    }

    protected void initForInput() {
        if (this.plot.isPersisted()) {
            this.domain = this.plot.getDomain();
            this.relatedPlots = this.plotService.getRelatedPlots(this.plot.getCode());
            this.measurementSessions = this.plotService.getPlotMeasurementSessions(this.plot.getTopiaId());
        } else {
            this.domain = this.domainService.getDomain(this.domainTopiaId);
        }
        this.growingSystems = this.growingSystemService.findAllActiveByDomainForPlotEdit(this.domain);
        if (this.plot.isPersisted() && this.plot.getGrowingSystem() != null && !this.growingSystems.contains(this.plot.getGrowingSystem())) {
            this.growingSystems.add(this.plot.getGrowingSystem());
        }
        this.parcelleZonages = this.referentialService.getAllActiveParcelleZonage();
        this.solTextures = this.referentialService.getAllActiveSolTextures();
        this.solProfondeurs = this.referentialService.getAllActiveSolProfondeurs();
        this.solCaracteristiques = this.referentialService.getAllActiveSolCaracteristiques();
        this.adjacentElements = this.referentialService.getAllActiveElementVoisinages();
        this.grounds = this.domainService.getGrounds(this.domain.getTopiaId());
    }

    public void validate() {
        if (StringUtils.isBlank((CharSequence)this.domainTopiaId)) {
            this.addActionError("domainTopiaId is required");
        }
        if (StringUtils.isBlank((CharSequence)this.plot.getName())) {
            this.addFieldError("plot.name", this.getText("common.filedValue.required"));
        }
        if (CollectionUtils.isEmpty((Collection)this.zones)) {
            this.addActionError("La parcelle doit contenir au moins une zone !");
        } else {
            double totalZoneArea = 0.0;
            for (Zone zone : this.zones) {
                totalZoneArea += zone.getArea();
            }
            double epsilon = 1.0E-14;
            if (this.plot.getArea() < totalZoneArea && Math.abs(this.plot.getArea() - totalZoneArea) > epsilon) {
                this.addFieldError("plot.area", INCORRECT_PLOT_AREA);
                this.addActionError(LOWER_PLOT_AREA);
            }
        }
        if (this.hasErrors()) {
            if (LOGGER.isErrorEnabled()) {
                String entityId = this.getLogEntityId((TopiaEntity)this.plot);
                LOGGER.error((Object)String.format("For user email:" + this.getAuthenticatedUser().getEmail() + ":validate, action errors : parcelle:'%s' -> %s", entityId, this.getActionErrors().toString()));
                LOGGER.error((Object)String.format("For user email:" + this.getAuthenticatedUser().getEmail() + ":validate, fields errors : parcelle:'%s' -> %s", entityId, this.getFieldErrors().toString()));
            }
            this.initForInput();
        }
    }

    @Action(results={@Result(type="redirectAction", params={"actionName", "plots-edit-input", "plotTopiaId", "${plot.topiaId}"})})
    public String execute() throws Exception {
        if (!this.changeableGrowingSystem) {
            this.growingSystemTopiaId = null;
            if (this.plot.getGrowingSystem() != null) {
                this.growingSystemTopiaId = this.plot.getGrowingSystem().getTopiaId();
            }
        }
        this.plot = this.plotService.createOrUpdatePlot(this.plot, this.domainTopiaId, this.locationTopiaId, this.growingSystemTopiaId, (Collection)this.selectedPlotZoningIds, this.selectedSolId, this.selectedSurfaceTextureId, this.selectedSubSoilTextureId, this.selectedSolProfondeurId, this.solHorizons, (Collection)this.zones, this.adjacentElementIds);
        this.notificationSupport.plotSaved(this.plot);
        return "success";
    }

    public Plot getPlot() {
        return Objects.requireNonNullElseGet(this.plot, PlotImpl::new);
    }

    public void setDomainTopiaId(String domainTopiaId) {
        this.domainTopiaId = domainTopiaId;
    }

    public Domain getDomain() {
        return this.domain;
    }

    public List<Ground> getGrounds() {
        return this.grounds;
    }

    public Map<MaxSlope, String> getMaxSlopes() {
        return this.getEnumAsMap((Object[])MaxSlope.values());
    }

    public Map<BufferStrip, String> getBufferStrips() {
        return this.getEnumAsMap((Object[])BufferStrip.values());
    }

    public Map<WaterFlowDistance, String> getWaterFlowDistances() {
        return this.getEnumAsMap((Object[])WaterFlowDistance.values());
    }

    public String getPlotTopiaId() {
        return this.plotTopiaId;
    }

    public void setPlotTopiaId(String plotTopiaId) {
        this.plotTopiaId = plotTopiaId;
    }

    public LinkedHashMap<Integer, String> getRelatedPlots() {
        return this.relatedPlots;
    }

    public void setLocationTopiaId(String locationTopiaId) {
        this.locationTopiaId = locationTopiaId;
    }

    public String getLocationTopiaId() {
        return this.locationTopiaId;
    }

    public List<GrowingSystem> getGrowingSystems() {
        return this.growingSystems;
    }

    public String getGrowingSystemTopiaId() {
        return this.growingSystemTopiaId;
    }

    public void setGrowingSystemTopiaId(String growingSystemTopiaId) {
        this.growingSystemTopiaId = growingSystemTopiaId;
    }

    public List<RefParcelleZonageEDI> getParcelleZonages() {
        return this.parcelleZonages;
    }

    public void setSelectedPlotZoningIds(List<String> selectedPlotZoningIds) {
        this.selectedPlotZoningIds = selectedPlotZoningIds;
    }

    public List<String> getSelectedPlotZoningIds() {
        return this.selectedPlotZoningIds;
    }

    public Map<IrrigationSystemType, String> getIrrigationSystemTypes() {
        return this.getEnumAsMap((Object[])IrrigationSystemType.values());
    }

    public Map<PompEngineType, String> getPompEngineTypes() {
        return this.getEnumAsMap((Object[])PompEngineType.values());
    }

    public Map<HosesPositionning, String> getHosesPositionnings() {
        return this.getEnumAsMap((Object[])HosesPositionning.values());
    }

    public Map<FrostProtectionType, String> getFrostProtectionTypes() {
        return this.getEnumAsMap((Object[])FrostProtectionType.values());
    }

    public Map<SolWaterPh, String> getSolWaterPhs() {
        return this.getEnumAsMap((Object[])SolWaterPh.values());
    }

    public String getSelectedSolId() {
        return this.selectedSolId;
    }

    public void setSelectedSolId(String selectedSolId) {
        this.selectedSolId = selectedSolId;
    }

    public List<RefSolTextureGeppa> getSolTextures() {
        return this.solTextures;
    }

    public List<RefSolProfondeurIndigo> getSolProfondeurs() {
        return this.solProfondeurs;
    }

    public String getSelectedSurfaceTextureId() {
        return this.selectedSurfaceTextureId;
    }

    public void setSelectedSurfaceTextureId(String selectedSurfaceTextureId) {
        this.selectedSurfaceTextureId = selectedSurfaceTextureId;
    }

    public String getSelectedSubSoilTextureId() {
        return this.selectedSubSoilTextureId;
    }

    public void setSelectedSubSoilTextureId(String selectedSubSoilTextureId) {
        this.selectedSubSoilTextureId = selectedSubSoilTextureId;
    }

    public String getSelectedSolProfondeurId() {
        return this.selectedSolProfondeurId;
    }

    public void setSelectedSolProfondeurId(String selectedSolProfondeurId) {
        this.selectedSolProfondeurId = selectedSolProfondeurId;
    }

    public List<SolHorizonDto> getSolHorizons() {
        return this.solHorizons;
    }

    public void setSolHorizons(String json) {
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.solHorizons = (List)this.getGson().fromJson(json, type);
    }

    public List<RefSolCaracteristiqueIndigo> getSolCaracteristiques() {
        return this.solCaracteristiques;
    }

    public List<Zone> getZones() {
        return this.zones;
    }

    public void setZones(String json) {
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.zones = (List)this.getGson().fromJson(json, type);
    }

    public UsageList<Zone> getZonesUsageList() {
        return this.zonesUsageList;
    }

    public Map<ZoneType, String> getZoneTypes() {
        return this.getEnumAsMap((Object[])ZoneType.values());
    }

    public List<RefElementVoisinage> getAdjacentElements() {
        return this.adjacentElements;
    }

    public List<String> getAdjacentElementIds() {
        return this.adjacentElementIds;
    }

    public void setAdjacentElementIds(List<String> adjacentElementIds) {
        this.adjacentElementIds = adjacentElementIds;
    }

    public List<MeasurementSession> getMeasurementSessions() {
        return this.measurementSessions;
    }

    public boolean isChangeableGrowingSystem() {
        return this.changeableGrowingSystem;
    }
}

