/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.performances;

import com.google.common.net.MediaType;
import fr.inra.agrosyst.api.exceptions.AgrosystTechnicalException;
import fr.inra.agrosyst.api.services.common.BinaryStream;
import fr.inra.agrosyst.api.services.performance.PerformanceService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;
import java.io.InputStream;
import lombok.Generated;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

public class PerformancesDownload
extends AbstractAgrosystAction {
    private static final long serialVersionUID = -2944160203634155778L;
    private static final Log LOGGER = LogFactory.getLog(PerformancesDownload.class);
    protected transient PerformanceService performanceService;
    protected String performanceTopiaId;
    protected transient BinaryStream binaryStream;

    @Action(results={@Result(type="stream", params={"contentType", "${mimetype}", "inputName", "inputStream", "contentDisposition", "attachment; filename=\"${filename}\""})})
    public String execute() throws Exception {
        try {
            this.binaryStream = this.performanceService.downloadPerformances(this.performanceTopiaId);
        }
        catch (Exception ex) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Can't generate xsl", (Throwable)ex);
            }
            throw new AgrosystTechnicalException("Can't create input stream", (Throwable)ex);
        }
        return "success";
    }

    public InputStream getInputStream() {
        return this.binaryStream.getStream();
    }

    public String getMimetype() {
        String mimetype = this.binaryStream.getType() == BinaryStream.FileType.XLS ? "aapplication/vnd.ms-excel" : MediaType.OOXML_SHEET.toString();
        return mimetype;
    }

    public String getFilename() {
        Object filename = "performance.xls";
        if (this.binaryStream.getType() == BinaryStream.FileType.XLSX) {
            filename = (String)filename + "x";
        }
        return filename;
    }

    @Generated
    public void setPerformanceService(PerformanceService performanceService) {
        this.performanceService = performanceService;
    }

    @Generated
    public void setPerformanceTopiaId(String performanceTopiaId) {
        this.performanceTopiaId = performanceTopiaId;
    }
}

