/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.networks;

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.Network;
import fr.inra.agrosyst.api.services.network.NetworkConnectionDto;
import fr.inra.agrosyst.api.services.network.NetworkFilter;
import fr.inra.agrosyst.api.services.network.NetworkGraph;
import fr.inra.agrosyst.api.services.network.NetworkService;
import fr.inra.agrosyst.api.services.network.SmallNetworkDto;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;
import java.util.List;
import java.util.Set;
import org.nuiton.util.pagination.PaginationResult;

public class NetworksList
extends AbstractAgrosystAction {
    private static final long serialVersionUID = 4474047833187143193L;
    protected transient NetworkService networkService;
    protected PaginationResult<Network> networks;
    protected NetworkFilter networkFilter;
    protected NetworkGraph networksGraph;

    public void setNetworkService(NetworkService networkService) {
        this.networkService = networkService;
    }

    public String execute() throws Exception {
        NavigationContext navigationContext = this.getNavigationContext();
        this.networkFilter = new NetworkFilter();
        this.networkFilter.setNavigationContext(navigationContext);
        this.networkFilter.setActive(Boolean.TRUE);
        this.networkFilter.setPageSize(this.getListNbElementByPage(Network.class).intValue());
        this.networks = this.networkService.getFilteredNetworks(this.networkFilter);
        if (this.networks.getCount() < this.getNetworkDisplayLimit()) {
            this.networksGraph = this.networkService.buildFullNetworkGraph();
        }
        return "success";
    }

    public PaginationResult<Network> getNetworks() {
        return this.networks;
    }

    public List<List<SmallNetworkDto>> getGraphNetworks() {
        return this.networksGraph == null ? null : this.networksGraph.getNetworks();
    }

    public Set<NetworkConnectionDto> getGraphConnections() {
        return this.networksGraph == null ? null : this.networksGraph.getConnections();
    }

    public NetworkFilter getNetworkFilter() {
        return this.networkFilter;
    }

    public long getNetworkDisplayLimit() {
        return 50L;
    }
}

