/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.ipmworks.practiced;

import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.Sector;
import fr.inra.agrosyst.api.entities.practiced.PracticedSystem;
import fr.inra.agrosyst.api.entities.referential.RefTypeAgriculture;
import fr.inra.agrosyst.api.services.domain.CroppingPlans;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.api.services.growingplan.GrowingPlanService;
import fr.inra.agrosyst.api.services.network.NetworkService;
import fr.inra.agrosyst.api.services.practiced.CropCycleModelDto;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;

@Results(value={@Result(name={"success"}, type="redirectAction", params={"namespace", "/ipmworks/practiced", "actionName", "practiced-systems-edit-input", "practicedSystemTopiaId", "${practicedSystemTopiaId}"}), @Result(name={"error"}, type="redirectAction", params={"namespace", "/ipmworks//practiced", "actionName", "practiced-systems-edit-input", "practicedSystemTopiaId", "${practicedSystemTopiaId}"})})
public class PracticedSystemsEdit
extends fr.inra.agrosyst.web.actions.practiced.PracticedSystemsEdit {
    protected transient DomainService domainService;
    protected transient GrowingPlanService growingPlanService;
    protected transient NetworkService networkService;
    protected String typeAgricultureTopiaId;
    protected String ipmWorksId;
    protected String missingTypeAgricultureTopiaId;
    protected List<RefTypeAgriculture> typeAgricultures;

    public void prepare() {
        super.prepare();
        this.missingTypeAgricultureTopiaId = this.growingSystemService.getMissingTypeAgricultureTopiaId();
    }

    public void validate() {
        if (StringUtils.isBlank((CharSequence)this.typeAgricultureTopiaId) || !this.typeAgricultureTopiaId.startsWith(RefTypeAgriculture.class.getName()) || this.typeAgricultureTopiaId.equals(this.missingTypeAgricultureTopiaId)) {
            this.addFieldError("typeAgricultureTopiaId", this.getText("common.filedValue.required"));
            this.addActionError(this.getText("practicedSystem-error-typeAgricultureTopiaId-action-message"));
        }
        if (StringUtils.isBlank((CharSequence)this.ipmWorksId)) {
            this.addFieldError("ipmWorksId", this.getText("common.filedValue.required"));
            this.addActionError(this.getText("practicedSystem-error-ipmWorksId-action-message"));
        }
        super.validate();
    }

    protected void validateGrowingSystemForNewPracticedSystem() {
    }

    @Action(value="practiced-systems-edit-input")
    public String input() {
        Domain domain = null;
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.domainId})) {
            domain = this.domainService.getDomain(this.domainId);
            this.campaigns = String.valueOf(domain.getCampaign());
        }
        this.typeAgricultures = this.referentialService.getIpmWorksTypeAgricultures();
        GrowingSystem growingSystem = this.getPracticedSystem().getGrowingSystem();
        if (growingSystem != null) {
            if (growingSystem.getTypeAgriculture() != null) {
                this.typeAgricultureTopiaId = growingSystem.getTypeAgriculture().getTopiaId();
            }
            this.typeAgricultureTopiaId = growingSystem.getTypeAgriculture().getTopiaId();
            this.ipmWorksId = growingSystem.getDephyNumber();
            this.growingSystemSector = growingSystem.getSector();
        } else if (domain != null) {
            growingSystem = this.getGrowingSystemForNewPracticedSystem(domain.getTopiaId(), domain.getName(), (RefTypeAgriculture)this.typeAgricultures.get(0));
            this.growingSystemTopiaId = growingSystem.getTopiaId();
        }
        this.practicedSystem = this.getPracticedSystem();
        if (!this.practicedSystem.isPersisted()) {
            this.practicedSystem.setCampaigns(this.campaigns);
            this.practicedSystem.setGrowingSystem(growingSystem);
        }
        Map modelToSpecies = this.practicedSystemService.getIpmworksCropCycleModelMap(this.domainId);
        Set croppingPlanEntryDtos = modelToSpecies.keySet();
        this.practicedSystemMainCropCycleModels = croppingPlanEntryDtos.stream().filter(CroppingPlans.IS_NOT_INTERMEDIATE).collect(Collectors.toList());
        this.practicedSystemIntermediateCropCycleModels = croppingPlanEntryDtos.stream().filter(CroppingPlans.IS_INTERMEDIATE).collect(Collectors.toList());
        this.practicedSystemCroppingPlanEntryCodesToSpecies = new HashMap();
        for (Map.Entry entry : modelToSpecies.entrySet()) {
            this.practicedSystemCroppingPlanEntryCodesToSpecies.put(((CropCycleModelDto)entry.getKey()).getCroppingPlanEntryCode(), (List)entry.getValue());
        }
        return super.input();
    }

    protected Map<String, List<Sector>> getSectorByCodeEspceBotaniqueCodeQualifiant() {
        if (this.practicedSystem.isPersisted()) {
            return super.getSectorByCodeEspceBotaniqueCodeQualifiant();
        }
        return this.practicedSystemService.getSectorByCodeEspceBotaniqueCodeQualifiant2(this.domainId, this.practicedSystem.getCampaigns());
    }

    protected Map<String, List<Pair<String, String>>> getAllCodeEspeceBotaniqueCodeQualifantBySpeciesCode() {
        if (this.practicedSystem.isPersisted()) {
            return super.getAllCodeEspeceBotaniqueCodeQualifantBySpeciesCode();
        }
        return this.practicedSystemService.getAllCodeEspeceBotaniqueCodeQualifantBySpeciesCodeForDomainIds2(this.domainId, this.practicedSystem.getCampaigns());
    }

    protected List<String> getCropCodesForCampaigns() {
        if (this.practicedSystem.isPersisted()) {
            return super.getCropCodesForCampaigns();
        }
        return this.practicedSystemService.getCropCodesFromDomainIdForCampaigns(this.domainId, this.practicedSystem.getCampaigns());
    }

    public String execute() throws Exception {
        GrowingSystem growingSystem;
        PracticedSystem practicedSystem1 = this.getPracticedSystem();
        if (practicedSystem1.isPersisted()) {
            growingSystem = practicedSystem1.getGrowingSystem();
            this.growingSystemTopiaId = growingSystem.getTopiaId();
        }
        if (StringUtils.isNotBlank((CharSequence)this.growingSystemTopiaId)) {
            growingSystem = this.growingSystemService.getGrowingSystem(this.growingSystemTopiaId);
            growingSystem.setTypeAgriculture(this.referentialService.getRefTypeAgricultureWithId(this.typeAgricultureTopiaId));
            growingSystem.setDephyNumber(this.ipmWorksId);
            growingSystem.setName(practicedSystem1.getName());
            growingSystem.setSector(this.growingSystemSector);
            this.growingSystemService.updateGrowingSystem(growingSystem);
        }
        return super.execute();
    }

    protected GrowingSystem getGrowingSystemForNewPracticedSystem(String domainId, String name, RefTypeAgriculture typeAgriculture) {
        GrowingSystem result = this.growingSystemService.createDefaultIpmworksGrowingSystem(domainId, name, Sector.GRANDES_CULTURES, "NEW_GROWING_SYSTEM_IPMWORKS_ID", typeAgriculture.getTopiaId(), new EnumMap(Sector.class));
        return result;
    }

    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }

    public void setGrowingPlanService(GrowingPlanService growingPlanService) {
        this.growingPlanService = growingPlanService;
    }

    public void setNetworkService(NetworkService networkService) {
        this.networkService = networkService;
    }

    public String getTypeAgricultureTopiaId() {
        return this.typeAgricultureTopiaId;
    }

    public void setTypeAgricultureTopiaId(String typeAgricultureTopiaId) {
        this.typeAgricultureTopiaId = typeAgricultureTopiaId;
    }

    public String getIpmWorksId() {
        return this.ipmWorksId;
    }

    public void setIpmWorksId(String ipmWorksId) {
        this.ipmWorksId = ipmWorksId;
    }

    public String getMissingTypeAgricultureTopiaId() {
        return this.missingTypeAgricultureTopiaId;
    }

    public List<RefTypeAgriculture> getTypeAgricultures() {
        return this.typeAgricultures;
    }

    public Map<Sector, String> getGrowingSystemSectors() {
        return this.i18nService.getEnumAsMap(null, (Object[])this.getConfig().getIpmWorksSectors());
    }
}

